/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.util.Objects;
import javax.money.MonetaryException;

public class MonetaryParseException
extends MonetaryException {
    private static final long serialVersionUID = -2855079387296896628L;
    private int errorIndex;
    private CharSequence data;

    public MonetaryParseException(String message, CharSequence parsedData, int errorIndex) {
        super(message);
        if (errorIndex > parsedData.length()) {
            throw new IllegalArgumentException("Invalid error index > input.length");
        }
        this.data = parsedData;
        this.errorIndex = errorIndex;
    }

    public MonetaryParseException(CharSequence parsedData, int errorIndex) {
        super("Parse Error");
        if (errorIndex > parsedData.length()) {
            throw new IllegalArgumentException("Invalid error index > input.length");
        }
        this.data = parsedData;
        this.errorIndex = errorIndex;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public String getInput() {
        if (Objects.isNull(this.data)) {
            return null;
        }
        return this.data.toString();
    }
}

