/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.snakeyaml.engine.v1.constructor;

import com.hazelcast.org.snakeyaml.engine.external.biz.base64Coder.Base64Coder;
import com.hazelcast.org.snakeyaml.engine.v1.api.ConstructNode;
import com.hazelcast.org.snakeyaml.engine.v1.api.LoadSettings;
import com.hazelcast.org.snakeyaml.engine.v1.constructor.BaseConstructor;
import com.hazelcast.org.snakeyaml.engine.v1.exceptions.ConstructorException;
import com.hazelcast.org.snakeyaml.engine.v1.exceptions.DuplicateKeyException;
import com.hazelcast.org.snakeyaml.engine.v1.exceptions.YamlEngineException;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.MappingNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.Node;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.NodeTuple;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.NodeType;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.ScalarNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.SequenceNode;
import com.hazelcast.org.snakeyaml.engine.v1.nodes.Tag;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class StandardConstructor
extends BaseConstructor {
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();

    public StandardConstructor(LoadSettings settings) {
        super(settings);
        this.tagConstructors.put(Tag.NULL, new ConstructYamlNull());
        this.tagConstructors.put(Tag.BOOL, new ConstructYamlBool());
        this.tagConstructors.put(Tag.INT, new ConstructYamlInt());
        this.tagConstructors.put(Tag.FLOAT, new ConstructYamlFloat());
        this.tagConstructors.put(Tag.BINARY, new ConstructYamlBinary());
        this.tagConstructors.put(Tag.SET, new ConstructYamlSet());
        this.tagConstructors.put(Tag.STR, new ConstructYamlStr());
        this.tagConstructors.put(Tag.SEQ, new ConstructYamlSeq());
        this.tagConstructors.put(Tag.MAP, new ConstructYamlMap());
        this.tagConstructors.put(new Tag(UUID.class), new ConstructUuidClass());
        this.tagConstructors.put(new Tag(Optional.class), new ConstructOptionalClass());
    }

    protected void flattenMapping(MappingNode node) {
        this.processDuplicateKeys(node);
        if (node.isMerged()) {
            node.setValue(this.mergeNode(node, true, new HashMap<Object, Integer>(), new ArrayList<NodeTuple>()));
        }
    }

    protected void processDuplicateKeys(MappingNode node) {
        List<NodeTuple> nodeValue = node.getValue();
        HashMap<Object, Integer> keys = new HashMap<Object, Integer>(nodeValue.size());
        TreeSet<Integer> toRemove = new TreeSet<Integer>();
        int i = 0;
        for (NodeTuple tuple : nodeValue) {
            Node keyNode = tuple.getKeyNode();
            if (!keyNode.getTag().equals(Tag.MERGE)) {
                Integer prevIndex;
                Object key = this.constructObject(keyNode);
                if (key != null) {
                    try {
                        key.hashCode();
                    }
                    catch (Exception e) {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), e);
                    }
                }
                if ((prevIndex = keys.put(key, i)) != null) {
                    if (!this.settings.getAllowDuplicateKeys()) {
                        throw new DuplicateKeyException(node.getStartMark(), key, tuple.getKeyNode().getStartMark());
                    }
                    toRemove.add(prevIndex);
                }
            }
            ++i;
        }
        Iterator indicies2remove = toRemove.descendingIterator();
        while (indicies2remove.hasNext()) {
            nodeValue.remove((Integer)indicies2remove.next());
        }
    }

    private List<NodeTuple> mergeNode(MappingNode node, boolean isPreffered, Map<Object, Integer> key2index, List<NodeTuple> values) {
        Iterator<NodeTuple> iter = node.getValue().iterator();
        block4: while (iter.hasNext()) {
            NodeTuple nodeTuple = iter.next();
            Node keyNode = nodeTuple.getKeyNode();
            Node valueNode = nodeTuple.getValueNode();
            if (keyNode.getTag().equals(Tag.MERGE)) {
                iter.remove();
                switch (valueNode.getNodeType()) {
                    case MAPPING: {
                        MappingNode mn = (MappingNode)valueNode;
                        this.mergeNode(mn, false, key2index, values);
                        continue block4;
                    }
                    case SEQUENCE: {
                        SequenceNode sn = (SequenceNode)valueNode;
                        List<Node> vals = sn.getValue();
                        for (Node subnode : vals) {
                            if (!(subnode instanceof MappingNode)) {
                                throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping for merging, but found " + (Object)((Object)subnode.getNodeType()), subnode.getStartMark());
                            }
                            MappingNode mnode = (MappingNode)subnode;
                            this.mergeNode(mnode, false, key2index, values);
                        }
                        continue block4;
                    }
                    default: {
                        throw new ConstructorException("while constructing a mapping", node.getStartMark(), "expected a mapping or list of mappings for merging, but found " + (Object)((Object)valueNode.getNodeType()), valueNode.getStartMark());
                    }
                }
            }
            Object key = this.constructObject(keyNode);
            if (!key2index.containsKey(key)) {
                values.add(nodeTuple);
                key2index.put(key, values.size() - 1);
                continue;
            }
            if (!isPreffered) continue;
            values.set(key2index.get(key), nodeTuple);
        }
        return values;
    }

    @Override
    ConstructNode getDefaultConstruct(Node node) {
        return new ConstructUndefined();
    }

    @Override
    protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        this.flattenMapping(node);
        super.constructMapping2ndStep(node, mapping);
    }

    @Override
    protected void constructSet2ndStep(MappingNode node, Set<Object> set) {
        this.flattenMapping(node);
        super.constructSet2ndStep(node, set);
    }

    private Number createNumber(int sign, String number, int radix) {
        Number result;
        if (sign < 0) {
            number = "-" + number;
        }
        try {
            result = Integer.valueOf(number, radix);
        }
        catch (NumberFormatException e) {
            try {
                result = Long.valueOf(number, radix);
            }
            catch (NumberFormatException e1) {
                result = new BigInteger(number, radix);
            }
        }
        return result;
    }

    static {
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
    }

    public static final class ConstructUndefined
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            throw new ConstructorException(null, Optional.empty(), "could not determine a constructor for the tag " + node.getTag(), node.getStartMark());
        }
    }

    public class ConstructYamlMap
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            MappingNode mnode = (MappingNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.createDefaultMap(mnode.getValue().size());
            }
            return StandardConstructor.this.constructMapping(mnode);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive mapping structure. Node: " + node);
            }
            StandardConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
        }
    }

    public class ConstructYamlSeq
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            SequenceNode seqNode = (SequenceNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.settings.getDefaultList().apply(seqNode.getSequence().size());
            }
            return StandardConstructor.this.constructSequence(seqNode);
        }

        @Override
        public void constructRecursive(Node node, Object data) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
            }
            StandardConstructor.this.constructSequenceStep2((SequenceNode)node, (List)data);
        }
    }

    public class ConstructYamlStr
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            return StandardConstructor.this.constructScalar((ScalarNode)node);
        }
    }

    public class ConstructYamlSet
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node.isRecursive()) {
                return StandardConstructor.this.constructedObjects.containsKey(node) ? StandardConstructor.this.constructedObjects.get(node) : StandardConstructor.this.createDefaultSet(((MappingNode)node).getValue().size());
            }
            return StandardConstructor.this.constructSet((MappingNode)node);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (!node.isRecursive()) {
                throw new YamlEngineException("Unexpected recursive set structure. Node: " + node);
            }
            StandardConstructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
        }
    }

    public class ConstructYamlOmap
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            LinkedHashMap<Object, Object> omap = new LinkedHashMap<Object, Object>();
            if (!(node instanceof SequenceNode)) {
                throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a sequence, but found " + (Object)((Object)node.getNodeType()), node.getStartMark());
            }
            SequenceNode snode = (SequenceNode)node;
            for (Node subnode : snode.getValue()) {
                if (!(subnode instanceof MappingNode)) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a mapping of length 1, but found " + (Object)((Object)subnode.getNodeType()), subnode.getStartMark());
                }
                MappingNode mnode = (MappingNode)subnode;
                if (mnode.getValue().size() != 1) {
                    throw new ConstructorException("while constructing an ordered map", node.getStartMark(), "expected a single mapping item, but found " + mnode.getValue().size() + " items", mnode.getStartMark());
                }
                Node keyNode = mnode.getValue().get(0).getKeyNode();
                Node valueNode = mnode.getValue().get(0).getValueNode();
                Object key = StandardConstructor.this.constructObject(keyNode);
                Object value = StandardConstructor.this.constructObject(valueNode);
                omap.put(key, value);
            }
            return omap;
        }
    }

    public class ConstructOptionalClass
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node.getNodeType() != NodeType.SCALAR) {
                throw new ConstructorException("while constructing Optional", Optional.empty(), "found non scalar node", node.getStartMark());
            }
            String value = StandardConstructor.this.constructScalar((ScalarNode)node);
            Tag implicitTag = StandardConstructor.this.settings.getScalarResolver().resolve(value, true);
            if (implicitTag.equals(Tag.NULL)) {
                return Optional.empty();
            }
            return Optional.of(value);
        }
    }

    public class ConstructUuidClass
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String uuidValue = StandardConstructor.this.constructScalar((ScalarNode)node);
            return UUID.fromString(uuidValue);
        }
    }

    public class ConstructYamlBinary
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String noWhiteSpaces = StandardConstructor.this.constructScalar((ScalarNode)node).replaceAll("\\s", "");
            byte[] decoded = Base64Coder.decode(noWhiteSpaces.toCharArray());
            return decoded;
        }
    }

    public class ConstructYamlFloat
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String value = StandardConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            String valLower = value.toLowerCase();
            if (".inf".equals(valLower)) {
                return sign == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (".nan".equals(valLower)) {
                return Double.NaN;
            }
            if (value.indexOf(58) != -1) {
                String[] digits = value.split(":");
                int bes = 1;
                double val = 0.0;
                int j = digits.length;
                for (int i = 0; i < j; ++i) {
                    val += Double.parseDouble(digits[j - i - 1]) * (double)bes;
                    bes *= 60;
                }
                return (double)sign * val;
            }
            Double d = Double.valueOf(value);
            return d * (double)sign;
        }
    }

    public class ConstructYamlInt
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String value = StandardConstructor.this.constructScalar((ScalarNode)node).replaceAll("_", "");
            int sign = 1;
            char first = value.charAt(0);
            if (first == '-') {
                sign = -1;
                value = value.substring(1);
            } else if (first == '+') {
                value = value.substring(1);
            }
            int base = 10;
            if ("0".equals(value)) {
                return 0;
            }
            if (value.startsWith("0b")) {
                value = value.substring(2);
                base = 2;
            } else if (value.startsWith("0x")) {
                value = value.substring(2);
                base = 16;
            } else if (value.startsWith("0")) {
                value = value.substring(1);
                base = 8;
            } else {
                if (value.indexOf(58) != -1) {
                    String[] digits = value.split(":");
                    int bes = 1;
                    int val = 0;
                    int j = digits.length;
                    for (int i = 0; i < j; ++i) {
                        val = (int)((long)val + Long.parseLong(digits[j - i - 1]) * (long)bes);
                        bes *= 60;
                    }
                    return StandardConstructor.this.createNumber(sign, String.valueOf(val), 10);
                }
                return StandardConstructor.this.createNumber(sign, value, 10);
            }
            return StandardConstructor.this.createNumber(sign, value, base);
        }
    }

    public class ConstructYamlBool
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            String val = StandardConstructor.this.constructScalar((ScalarNode)node);
            return BOOL_VALUES.get(val.toLowerCase());
        }
    }

    public class ConstructYamlNull
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            StandardConstructor.this.constructScalar((ScalarNode)node);
            return null;
        }
    }
}

