/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.unmodifiable;

import aQute.lib.unmodifiable.ImmutableIterator;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

final class ImmutableSet<E>
extends AbstractSet<E>
implements Set<E> {
    static final ImmutableSet<?> EMPTY = new ImmutableSet<Object>(new Object[0]);
    final E[] elements;
    final int[] hash_bucket;

    @SafeVarargs
    ImmutableSet(E ... elements) {
        this.elements = elements;
        this.hash_bucket = ImmutableSet.hash(elements);
    }

    private static <E> int[] hash(E[] elements) {
        int length = elements.length;
        if (length == 0) {
            return new int[1];
        }
        int[] hash_bucket = new int[length * 2];
        int i = 0;
        while (i < length) {
            int slot = ImmutableSet.linear_probe(elements, hash_bucket, elements[i]);
            if (slot >= 0) {
                throw new IllegalArgumentException("duplicate element: " + elements[i]);
            }
            hash_bucket[-1 - slot] = ++i;
        }
        return hash_bucket;
    }

    private static <E> int linear_probe(E[] elements, int[] hash_bucket, Object e) {
        int length = hash_bucket.length;
        int hash = (e.hashCode() & Integer.MAX_VALUE) % length;
        int slot;
        while ((slot = hash_bucket[hash] - 1) >= 0) {
            if (elements[slot].equals(e)) {
                return slot;
            }
            hash = (hash + 1) % length;
        }
        return -1 - hash;
    }

    private int linear_probe(Object e) {
        return ImmutableSet.linear_probe(this.elements, this.hash_bucket, e);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator<E>(this.elements);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            return this.linear_probe(o) >= 0;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int length = this.elements.length;
        if (length > array.length) {
            return Arrays.copyOf(this.elements, length, array.getClass());
        }
        System.arraycopy(this.elements, 0, array, 0, length);
        if (length < array.length) {
            array[length] = null;
        }
        return array;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        if (this.elements.length != other.size()) {
            return false;
        }
        try {
            for (E element : this.elements) {
                if (other.contains(element)) continue;
                return false;
            }
        }
        catch (ClassCastException checkedSet) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (E element : this.elements) {
            hashCode += element.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }
}

