/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoUnlinked;
import io.github.classgraph.ClassfileBinaryParser;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ClasspathElementDir;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.ClasspathElementZip;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ModuleInfo;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classpath.ClassLoaderAndModuleFinder;
import nonapi.io.github.classgraph.classpath.ClasspathFinder;
import nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import nonapi.io.github.classgraph.concurrency.SingletonMap;
import nonapi.io.github.classgraph.concurrency.WorkQueue;
import nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

class Scanner
implements Callable<ScanResult> {
    private final ScanSpec scanSpec;
    private final ExecutorService executorService;
    private final int numParallelTasks;
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final ClassGraph.ScanResultProcessor scanResultProcessor;
    private final ClassGraph.FailureHandler failureHandler;
    private final LogNode topLevelLog;
    private static final Comparator<Map.Entry<Integer, ClasspathElement>> INDEXED_CLASSPATH_ELEMENT_COMPARATOR = new Comparator<Map.Entry<Integer, ClasspathElement>>(){

        @Override
        public int compare(Map.Entry<Integer, ClasspathElement> o1, Map.Entry<Integer, ClasspathElement> o2) {
            return o1.getKey() - o2.getKey();
        }
    };

    Scanner(ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, ClassGraph.ScanResultProcessor scannResultProcessor, ClassGraph.FailureHandler failureHandler, LogNode log) {
        this.scanSpec = scanSpec;
        scanSpec.sortPrefixes();
        this.executorService = executorService;
        this.numParallelTasks = numParallelTasks;
        this.scanResultProcessor = scannResultProcessor;
        this.failureHandler = failureHandler;
        this.topLevelLog = log;
        scanSpec.log(log);
    }

    private static void findClasspathOrderRec(ClasspathElement currClasspathElement, HashSet<ClasspathElement> visitedClasspathElts, ArrayList<ClasspathElement> order) {
        if (visitedClasspathElts.add(currClasspathElement)) {
            if (!currClasspathElement.skipClasspathElement) {
                order.add(currClasspathElement);
            }
            for (ClasspathElement childClasspathElt : currClasspathElement.childClasspathElementsOrdered) {
                Scanner.findClasspathOrderRec(childClasspathElt, visitedClasspathElts, order);
            }
        }
    }

    private static List<ClasspathElement> orderClasspathElements(Collection<Map.Entry<Integer, ClasspathElement>> classpathEltsIndexed) {
        ArrayList<Map.Entry<Integer, ClasspathElement>> classpathEltsIndexedOrdered = new ArrayList<Map.Entry<Integer, ClasspathElement>>(classpathEltsIndexed);
        Collections.sort(classpathEltsIndexedOrdered, INDEXED_CLASSPATH_ELEMENT_COMPARATOR);
        ArrayList<ClasspathElement> classpathEltsOrdered = new ArrayList<ClasspathElement>(classpathEltsIndexedOrdered.size());
        for (Map.Entry entry : classpathEltsIndexedOrdered) {
            classpathEltsOrdered.add((ClasspathElement)entry.getValue());
        }
        return classpathEltsOrdered;
    }

    private List<ClasspathElement> findClasspathOrder(Set<ClasspathElement> openedClasspathElementsSet, Queue<Map.Entry<Integer, ClasspathElement>> toplevelClasspathEltsIndexed) {
        List<ClasspathElement> toplevelClasspathEltsOrdered = Scanner.orderClasspathElements(toplevelClasspathEltsIndexed);
        for (ClasspathElement classpathElt : openedClasspathElementsSet) {
            classpathElt.childClasspathElementsOrdered = Scanner.orderClasspathElements(classpathElt.childClasspathElementsIndexed);
        }
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (ClasspathElement toplevelClasspathElt : toplevelClasspathEltsOrdered) {
            Scanner.findClasspathOrderRec(toplevelClasspathElt, visitedClasspathElts, order);
        }
        return order;
    }

    private void findNestedClasspathElements(List<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathElts, LogNode log) {
        Collections.sort(classpathElts, new Comparator<AbstractMap.SimpleEntry<String, ClasspathElement>>(){

            @Override
            public int compare(AbstractMap.SimpleEntry<String, ClasspathElement> o1, AbstractMap.SimpleEntry<String, ClasspathElement> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        LogNode nestedClasspathRootNode = null;
        block0: for (int i = 0; i < classpathElts.size(); ++i) {
            AbstractMap.SimpleEntry<String, ClasspathElement> ei = classpathElts.get(i);
            String basePath = ei.getKey();
            int basePathLen = basePath.length();
            for (int j = i + 1; j < classpathElts.size(); ++j) {
                String nestedClasspathRelativePath;
                char nextChar;
                AbstractMap.SimpleEntry<String, ClasspathElement> ej = classpathElts.get(j);
                String comparePath = ej.getKey();
                int comparePathLen = comparePath.length();
                boolean foundNestedClasspathRoot = false;
                if (comparePath.startsWith(basePath) && comparePathLen > basePathLen && ((nextChar = comparePath.charAt(basePathLen)) == '/' || nextChar == '!') && (nestedClasspathRelativePath = comparePath.substring(basePathLen + 1)).indexOf(33) < 0) {
                    foundNestedClasspathRoot = true;
                    ClasspathElement baseElement = ei.getValue();
                    if (baseElement.nestedClasspathRootPrefixes == null) {
                        baseElement.nestedClasspathRootPrefixes = new ArrayList<String>();
                    }
                    baseElement.nestedClasspathRootPrefixes.add(nestedClasspathRelativePath + "/");
                    if (log != null) {
                        if (nestedClasspathRootNode == null) {
                            nestedClasspathRootNode = log.log("Found nested classpath elements");
                        }
                        nestedClasspathRootNode.log(basePath + " is a prefix of the nested element " + comparePath);
                    }
                }
                if (!foundNestedClasspathRoot) continue block0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ScanResult call() throws InterruptedException, ExecutionException {
        final LogNode classpathFinderLog = this.topLevelLog == null ? null : this.topLevelLog.log("Finding classpath entries");
        final NestedJarHandler nestedJarHandler = new NestedJarHandler(this.scanSpec, classpathFinderLog);
        final ConcurrentHashMap<String, ClassLoader[]> classpathEltPathToClassLoaders = new ConcurrentHashMap<String, ClassLoader[]>();
        try {
            void var21_37;
            long scanStart = System.nanoTime();
            ClasspathFinder classpathFinder = new ClasspathFinder(this.scanSpec, classpathEltPathToClassLoaders, nestedJarHandler, classpathFinderLog);
            ClassLoaderAndModuleFinder classLoaderAndModuleFinder = classpathFinder.getClassLoaderAndModuleFinder();
            ClassLoader[] contextClassLoaders = classLoaderAndModuleFinder.getContextClassLoaders();
            ArrayList<ClasspathElementModule> moduleClasspathEltOrder = new ArrayList<ClasspathElementModule>();
            if (this.scanSpec.overrideClasspath == null && this.scanSpec.overrideClassLoaders == null && this.scanSpec.scanModules) {
                Object nonSystemModuleRefs;
                List<ModuleRef> systemModuleRefs = classLoaderAndModuleFinder.getSystemModuleRefs();
                if (systemModuleRefs != null) {
                    for (ModuleRef moduleRef : systemModuleRefs) {
                        String moduleName = moduleRef.getName();
                        if (this.scanSpec.enableSystemJarsAndModules && this.scanSpec.moduleWhiteBlackList.whitelistAndBlacklistAreEmpty() || this.scanSpec.moduleWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(moduleName)) {
                            ClasspathElementModule classpathElementModule = new ClasspathElementModule(moduleRef, contextClassLoaders, nestedJarHandler, this.scanSpec);
                            classpathElementModule.open(null, classpathFinderLog);
                            moduleClasspathEltOrder.add(classpathElementModule);
                            continue;
                        }
                        if (classpathFinderLog == null) continue;
                        classpathFinderLog.log("Skipping non-whitelisted or blacklisted system module: " + moduleName);
                    }
                }
                if ((nonSystemModuleRefs = classLoaderAndModuleFinder.getNonSystemModuleRefs()) != null) {
                    Iterator iterator = nonSystemModuleRefs.iterator();
                    while (iterator.hasNext()) {
                        ModuleRef nonSystemModuleRef = (ModuleRef)iterator.next();
                        String moduleName = nonSystemModuleRef.getName();
                        if (this.scanSpec.moduleWhiteBlackList.isWhitelistedAndNotBlacklisted(moduleName)) {
                            ClasspathElementModule classpathElementModule = new ClasspathElementModule(nonSystemModuleRef, contextClassLoaders, nestedJarHandler, this.scanSpec);
                            classpathElementModule.open(null, classpathFinderLog);
                            moduleClasspathEltOrder.add(classpathElementModule);
                            continue;
                        }
                        if (classpathFinderLog == null) continue;
                        classpathFinderLog.log("Skipping non-whitelisted or blacklisted module: " + moduleName);
                    }
                }
            }
            ArrayList<RawClasspathElementWorkUnit> rawClasspathElementWorkUnits = new ArrayList<RawClasspathElementWorkUnit>();
            for (String string : classpathFinder.getClasspathOrder().getOrder()) {
                rawClasspathElementWorkUnits.add(new RawClasspathElementWorkUnit(string, null, rawClasspathElementWorkUnits.size()));
            }
            final SingletonMap<String, ClasspathElement> classpathElementSingletonMap = new SingletonMap<String, ClasspathElement>(){

                @Override
                public ClasspathElement newInstance(String classpathEltPath, LogNode log) throws Exception {
                    String canonicalPathNormalized;
                    boolean isJar;
                    ClassLoader[] classLoaders = (ClassLoader[])classpathEltPathToClassLoaders.get(classpathEltPath);
                    if (classpathEltPath.regionMatches(true, 0, "http://", 0, 7) || classpathEltPath.regionMatches(true, 0, "https://", 0, 8)) {
                        return new ClasspathElementZip(classpathEltPath, classLoaders, nestedJarHandler, Scanner.this.scanSpec);
                    }
                    String pathNormalized = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, classpathEltPath);
                    int plingIdx = pathNormalized.indexOf("!");
                    String pathToCanonicalize = plingIdx < 0 ? pathNormalized : pathNormalized.substring(0, plingIdx);
                    File fileCanonicalized = new File(pathToCanonicalize).getCanonicalFile();
                    if (!fileCanonicalized.exists()) {
                        throw new FileNotFoundException();
                    }
                    if (!FileUtils.canRead(fileCanonicalized)) {
                        throw new IOException("Cannot read file or directory");
                    }
                    boolean bl = isJar = classpathEltPath.regionMatches(true, 0, "jar:", 0, 4) || plingIdx > 0;
                    if (fileCanonicalized.isFile()) {
                        isJar = true;
                    } else if (fileCanonicalized.isDirectory()) {
                        if (isJar) {
                            throw new IOException("Expected jar, found directory");
                        }
                    } else {
                        throw new IOException("Not a normal file or directory");
                    }
                    String baseFileCanonicalPathNormalized = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, fileCanonicalized.getPath());
                    String string = canonicalPathNormalized = plingIdx < 0 ? baseFileCanonicalPathNormalized : baseFileCanonicalPathNormalized + pathNormalized.substring(plingIdx);
                    if (!canonicalPathNormalized.equals(pathNormalized)) {
                        return (ClasspathElement)this.get(canonicalPathNormalized, log);
                    }
                    return isJar ? new ClasspathElementZip(canonicalPathNormalized, classLoaders, nestedJarHandler, Scanner.this.scanSpec) : new ClasspathElementDir(fileCanonicalized, classLoaders, Scanner.this.scanSpec);
                }
            };
            final LogNode logNode = classpathFinderLog == null ? null : classpathFinderLog.log("Reading jarfile directories and manifest files");
            final Set<ClasspathElement> openedClasspathElementsSet = Collections.newSetFromMap(new ConcurrentHashMap());
            final ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>> toplevelClasspathEltOrder = new ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>>();
            WorkQueue.runWorkQueue(rawClasspathElementWorkUnits, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<RawClasspathElementWorkUnit>(){

                @Override
                public void processWorkUnit(RawClasspathElementWorkUnit workUnit, WorkQueue<RawClasspathElementWorkUnit> workQueue) throws Exception {
                    block9: {
                        try {
                            ClasspathElement classpathElt = (ClasspathElement)classpathElementSingletonMap.get(workUnit.rawClasspathEltPath, classpathFinderLog);
                            if (openedClasspathElementsSet.add(classpathElt)) {
                                classpathElt.open(workQueue, logNode);
                                AbstractMap.SimpleEntry<Integer, ClasspathElement> classpathEltEntry = new AbstractMap.SimpleEntry<Integer, ClasspathElement>(workUnit.orderWithinParentClasspathElement, classpathElt);
                                if (workUnit.parentClasspathElement != null) {
                                    workUnit.parentClasspathElement.childClasspathElementsIndexed.add(classpathEltEntry);
                                } else {
                                    toplevelClasspathEltOrder.add(classpathEltEntry);
                                }
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (classpathFinderLog != null) {
                                classpathFinderLog.log("Skipping invalid classpath element " + workUnit.rawClasspathEltPath);
                            }
                        }
                        catch (IOException e) {
                            if (classpathFinderLog != null) {
                                classpathFinderLog.log("Skipping invalid classpath element " + workUnit.rawClasspathEltPath + " : " + e);
                            }
                        }
                        catch (Exception e) {
                            if (classpathFinderLog == null) break block9;
                            classpathFinderLog.log("Uncaught exception while processing classpath element " + workUnit.rawClasspathEltPath + " : " + e);
                        }
                    }
                }
            }, this.interruptionChecker, logNode);
            List<ClasspathElement> finalTraditionalClasspathEltOrder = this.findClasspathOrder(openedClasspathElementsSet, toplevelClasspathEltOrder);
            ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathEltDirs = new ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>>();
            ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathEltZips = new ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>>();
            for (ClasspathElement classpathElt : finalTraditionalClasspathEltOrder) {
                if (classpathElt instanceof ClasspathElementDir) {
                    classpathEltDirs.add(new AbstractMap.SimpleEntry<String, ClasspathElement>(((ClasspathElementDir)classpathElt).getDirFile().getPath(), classpathElt));
                    continue;
                }
                if (!(classpathElt instanceof ClasspathElementZip)) continue;
                Iterator<ClasspathElement> classpathEltZip = (ClasspathElementZip)classpathElt;
                classpathEltZips.add(new AbstractMap.SimpleEntry<String, ClasspathElement>(((ClasspathElementZip)((Object)classpathEltZip)).getZipFilePath(), classpathElt));
                if (((ClasspathElementZip)((Object)classpathEltZip)).logicalZipFile == null) continue;
                if (((ClasspathElementZip)((Object)classpathEltZip)).logicalZipFile.addExportsManifestEntryValue != null) {
                    for (String addExports : JarUtils.smartPathSplit(((ClasspathElementZip)((Object)classpathEltZip)).logicalZipFile.addExportsManifestEntryValue, ' ')) {
                        this.scanSpec.modulePathInfo.addExports.add(addExports + "=ALL-UNNAMED");
                    }
                }
                if (((ClasspathElementZip)((Object)classpathEltZip)).logicalZipFile.addOpensManifestEntryValue == null) continue;
                for (String addOpens : JarUtils.smartPathSplit(((ClasspathElementZip)((Object)classpathEltZip)).logicalZipFile.addOpensManifestEntryValue, ' ')) {
                    this.scanSpec.modulePathInfo.addOpens.add(addOpens + "=ALL-UNNAMED");
                }
            }
            this.findNestedClasspathElements(classpathEltDirs, classpathFinderLog);
            this.findNestedClasspathElements(classpathEltZips, classpathFinderLog);
            LogNode classpathOrderLog = classpathFinderLog == null ? null : classpathFinderLog.log("Final classpath element order:");
            int numElts = moduleClasspathEltOrder.size() + finalTraditionalClasspathEltOrder.size();
            ArrayList<ClasspathElement> finalClasspathEltOrder = new ArrayList<ClasspathElement>(numElts);
            ArrayList<String> finalClasspathEltOrderStrs = new ArrayList<String>(numElts);
            for (ClasspathElementModule classpathElementModule : moduleClasspathEltOrder) {
                finalClasspathEltOrder.add(classpathElementModule);
                finalClasspathEltOrderStrs.add(classpathElementModule.toString());
                if (classpathOrderLog == null) continue;
                ModuleRef moduleRef = classpathElementModule.getModuleRef();
                classpathOrderLog.log(moduleRef.toString());
            }
            for (ClasspathElement classpathElement : finalTraditionalClasspathEltOrder) {
                finalClasspathEltOrder.add(classpathElement);
                finalClasspathEltOrderStrs.add(classpathElement.toString());
                if (classpathOrderLog == null) continue;
                classpathOrderLog.log(classpathElement.toString());
            }
            if (!this.scanSpec.performScan) {
                if (this.topLevelLog != null) {
                    this.topLevelLog.log("Only returning classpath elements (not performing a scan)");
                }
                ScanResult scanResult = new ScanResult(this.scanSpec, finalClasspathEltOrder, finalClasspathEltOrderStrs, contextClassLoaders, null, null, null, null, nestedJarHandler, this.topLevelLog);
                if (this.topLevelLog != null) {
                    this.topLevelLog.log("Completed", System.nanoTime() - scanStart);
                }
                ScanResult scanResult2 = scanResult;
                return scanResult2;
            }
            final LogNode pathScanLog = classpathFinderLog == null ? null : classpathFinderLog.log("Scanning filenames within classpath elements");
            WorkQueue.runWorkQueue(finalClasspathEltOrder, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<ClasspathElement>(){

                @Override
                public void processWorkUnit(ClasspathElement classpathElement, WorkQueue<ClasspathElement> workQueueIgnored) {
                    classpathElement.scanPaths(pathScanLog);
                    if (logNode != null) {
                        logNode.addElapsedTime();
                    }
                }
            }, this.interruptionChecker, pathScanLog);
            if (logNode != null) {
                logNode.addElapsedTime();
            }
            ArrayList<ClasspathElement> arrayList = finalClasspathEltOrder;
            if (!this.scanSpec.classpathElementResourcePathWhiteBlackList.whitelistIsEmpty()) {
                ArrayList<ClasspathElement> arrayList2 = new ArrayList<ClasspathElement>(finalClasspathEltOrder.size());
                for (ClasspathElement classpathElement : finalClasspathEltOrder) {
                    if (!classpathElement.containsSpecificallyWhitelistedClasspathElementResourcePath) continue;
                    arrayList2.add(classpathElement);
                }
            }
            LogNode maskLog = this.topLevelLog == null ? null : this.topLevelLog.log("Masking classfiles");
            HashSet<String> nonBlacklistedClasspathRelativePathsFound = new HashSet<String>();
            HashSet<String> whitelistedClasspathRelativePathsFound = new HashSet<String>();
            for (int classpathIdx = 0; classpathIdx < var21_37.size(); ++classpathIdx) {
                ((ClasspathElement)var21_37.get(classpathIdx)).maskClassfiles(classpathIdx, whitelistedClasspathRelativePathsFound, nonBlacklistedClasspathRelativePathsFound, maskLog);
            }
            HashMap<File, Long> fileToLastModified = new HashMap<File, Long>();
            for (ClasspathElement classpathElement : var21_37) {
                fileToLastModified.putAll(classpathElement.fileToLastModified);
            }
            HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
            HashMap<String, PackageInfo> packageNameToPackageInfo = new HashMap<String, PackageInfo>();
            HashMap<String, ModuleInfo> moduleNameToModuleInfo = new HashMap<String, ModuleInfo>();
            if (!this.scanSpec.enableClassInfo) {
                if (this.topLevelLog != null) {
                    this.topLevelLog.log("Classfile scanning is disabled");
                }
            } else {
                ArrayList<ClassfileScanWorkUnit> classfileScanWorkItems = new ArrayList<ClassfileScanWorkUnit>();
                Set<String> scannedClassNames = Collections.newSetFromMap(new ConcurrentHashMap());
                for (ClasspathElement classpathElement : var21_37) {
                    for (Resource resource : classpathElement.whitelistedClassfileResources) {
                        classfileScanWorkItems.add(new ClassfileScanWorkUnit(classpathElement, resource, false));
                        scannedClassNames.add(JarUtils.classfilePathToClassName(resource.getPath()));
                    }
                }
                ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinkedQueue = new ConcurrentLinkedQueue<ClassInfoUnlinked>();
                LogNode classfileScanLog = this.topLevelLog == null ? null : this.topLevelLog.log("Scanning classfiles");
                WorkQueue.runWorkQueue(classfileScanWorkItems, this.executorService, this.numParallelTasks, new ClassfileScannerWorkUnitProcessor(this.scanSpec, (List<ClasspathElement>)var21_37, scannedClassNames, classInfoUnlinkedQueue, classfileScanLog, this.interruptionChecker), this.interruptionChecker, classfileScanLog);
                if (classfileScanLog != null) {
                    classfileScanLog.addElapsedTime();
                }
                LogNode classGraphLog = this.topLevelLog == null ? null : this.topLevelLog.log("Building class graph");
                for (ClassInfoUnlinked c : classInfoUnlinkedQueue) {
                    c.link(this.scanSpec, classNameToClassInfo, packageNameToPackageInfo, moduleNameToModuleInfo, classGraphLog);
                }
                if (classGraphLog != null) {
                    classGraphLog.addElapsedTime();
                }
            }
            ScanResult scanResult = new ScanResult(this.scanSpec, finalClasspathEltOrder, finalClasspathEltOrderStrs, contextClassLoaders, classNameToClassInfo, packageNameToPackageInfo, moduleNameToModuleInfo, fileToLastModified, nestedJarHandler, this.topLevelLog);
            if (this.topLevelLog != null) {
                this.topLevelLog.log("Completed", System.nanoTime() - scanStart);
            }
            if (this.scanResultProcessor != null) {
                try {
                    this.scanResultProcessor.processScanResult(scanResult);
                }
                catch (Throwable e) {
                    throw new ExecutionException("Exception while calling scan result processor", e);
                }
            }
            ScanResult scanResult3 = scanResult;
            return scanResult3;
        }
        catch (Throwable e) {
            nestedJarHandler.close(this.topLevelLog);
            if (this.topLevelLog != null) {
                this.topLevelLog.log("Exception while scanning", e);
            }
            if (this.failureHandler != null) {
                try {
                    this.failureHandler.onFailure(e);
                    ScanResult scanResult = null;
                    return scanResult;
                }
                catch (Throwable t) {
                    throw new ExecutionException("Exception while calling failure handler", t);
                }
            }
            throw new ExecutionException("Exception while scanning", e);
        }
        finally {
            if (this.scanSpec.removeTemporaryFilesAfterScan) {
                nestedJarHandler.close(this.topLevelLog);
            }
            if (this.topLevelLog != null) {
                this.topLevelLog.flush();
            }
        }
    }

    private static class ClassfileScannerWorkUnitProcessor
    implements WorkQueue.WorkUnitProcessor<ClassfileScanWorkUnit> {
        private final ScanSpec scanSpec;
        private final List<ClasspathElement> classpathOrder;
        private final Set<String> scannedClassNames;
        private final ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinkedQueue;
        private final LogNode log;
        private final InterruptionChecker interruptionChecker;

        public ClassfileScannerWorkUnitProcessor(ScanSpec scanSpec, List<ClasspathElement> classpathOrder, Set<String> scannedClassNames, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinkedQueue, LogNode log, InterruptionChecker interruptionChecker) {
            this.scanSpec = scanSpec;
            this.classpathOrder = classpathOrder;
            this.scannedClassNames = scannedClassNames;
            this.classInfoUnlinkedQueue = classInfoUnlinkedQueue;
            this.log = log;
            this.interruptionChecker = interruptionChecker;
        }

        private List<ClassfileScanWorkUnit> extendScanningUpwards(String className, String relationship, ClasspathElement currClasspathElement, List<ClassfileScanWorkUnit> additionalWorkUnitsIn, LogNode subLog) {
            List<ClassfileScanWorkUnit> additionalWorkUnits = additionalWorkUnitsIn;
            if (className != null && this.scannedClassNames.add(className)) {
                String classfilePath = JarUtils.classNameToClassfilePath(className);
                Resource classResource = currClasspathElement.getResource(classfilePath);
                ClasspathElement foundInClasspathElt = null;
                if (classResource != null) {
                    foundInClasspathElt = currClasspathElement;
                } else {
                    for (ClasspathElement classpathElt : this.classpathOrder) {
                        if (classpathElt == currClasspathElement || (classResource = classpathElt.getResource(classfilePath)) == null) continue;
                        foundInClasspathElt = classpathElt;
                        break;
                    }
                }
                if (classResource != null) {
                    if (subLog != null) {
                        subLog.log("Scheduling external class for scanning: " + relationship + " " + className + " -- found in classpath element " + foundInClasspathElt);
                    }
                    if (additionalWorkUnits == null) {
                        additionalWorkUnits = new ArrayList<ClassfileScanWorkUnit>();
                    }
                    additionalWorkUnits.add(new ClassfileScanWorkUnit(foundInClasspathElt, classResource, true));
                } else if (subLog != null && !className.equals("java.lang.Object")) {
                    subLog.log("External " + relationship + " " + className + " was not found in non-blacklisted packages -- cannot extend scanning to this class");
                }
            }
            return additionalWorkUnits;
        }

        private List<ClassfileScanWorkUnit> extendScanningUpwards(ClasspathElement classpathElement, ClassInfoUnlinked classInfoUnlinked, LogNode subLog) {
            List<ClassfileScanWorkUnit> additionalWorkUnits = null;
            additionalWorkUnits = this.extendScanningUpwards(classInfoUnlinked.superclassName, "superclass", classpathElement, additionalWorkUnits, subLog);
            if (classInfoUnlinked.implementedInterfaces != null) {
                for (String className : classInfoUnlinked.implementedInterfaces) {
                    additionalWorkUnits = this.extendScanningUpwards(className, "interface", classpathElement, additionalWorkUnits, subLog);
                }
            }
            if (classInfoUnlinked.classAnnotations != null) {
                for (AnnotationInfo annotationInfo : classInfoUnlinked.classAnnotations) {
                    additionalWorkUnits = this.extendScanningUpwards(annotationInfo.getName(), "class annotation", classpathElement, additionalWorkUnits, subLog);
                }
            }
            if (classInfoUnlinked.methodInfoList != null) {
                for (MethodInfo methodInfo : classInfoUnlinked.methodInfoList) {
                    if (methodInfo.annotationInfo == null) continue;
                    for (AnnotationInfo methodAnnotationInfo : methodInfo.annotationInfo) {
                        additionalWorkUnits = this.extendScanningUpwards(methodAnnotationInfo.getName(), "method annotation", classpathElement, additionalWorkUnits, subLog);
                    }
                    if (methodInfo.parameterAnnotationInfo == null || methodInfo.parameterAnnotationInfo.length <= 0) continue;
                    for (AnnotationInfo[] paramAnns : methodInfo.parameterAnnotationInfo) {
                        if (paramAnns == null || paramAnns.length <= 0) continue;
                        for (AnnotationInfo paramAnn : paramAnns) {
                            additionalWorkUnits = this.extendScanningUpwards(paramAnn.getName(), "method parameter annotation", classpathElement, additionalWorkUnits, subLog);
                        }
                    }
                }
            }
            if (classInfoUnlinked.fieldInfoList != null) {
                for (FieldInfo fieldInfo : classInfoUnlinked.fieldInfoList) {
                    if (fieldInfo.annotationInfo == null) continue;
                    for (AnnotationInfo fieldAnnotationInfo : fieldInfo.annotationInfo) {
                        additionalWorkUnits = this.extendScanningUpwards(fieldAnnotationInfo.getName(), "field annotation", classpathElement, additionalWorkUnits, subLog);
                    }
                }
            }
            return additionalWorkUnits;
        }

        @Override
        public void processWorkUnit(ClassfileScanWorkUnit workUnit, WorkQueue<ClassfileScanWorkUnit> workQueue) throws Exception {
            block9: {
                LogNode subLog = this.log == null ? null : this.log.log(workUnit.classfileResource.getPath(), "Parsing classfile " + workUnit.classfileResource);
                try {
                    ClassInfoUnlinked classInfoUnlinked = new ClassfileBinaryParser().readClassInfoFromClassfileHeader(workUnit.classpathElement, workUnit.classfileResource.getPath(), workUnit.classfileResource, workUnit.isExternalClass, this.scanSpec, subLog);
                    if (classInfoUnlinked != null) {
                        List<ClassfileScanWorkUnit> additionalWorkUnits;
                        this.classInfoUnlinkedQueue.add(classInfoUnlinked);
                        classInfoUnlinked.logTo(subLog);
                        if (this.scanSpec.extendScanningUpwardsToExternalClasses && (additionalWorkUnits = this.extendScanningUpwards(workUnit.classpathElement, classInfoUnlinked, subLog)) != null) {
                            workQueue.addWorkUnits(additionalWorkUnits);
                        }
                    }
                    if (subLog != null) {
                        subLog.addElapsedTime();
                    }
                }
                catch (IOException e) {
                    if (subLog != null) {
                        subLog.log("IOException while attempting to read classfile " + workUnit.classfileResource + " : " + e);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (subLog != null) {
                        subLog.log("Corrupt or unsupported classfile " + workUnit.classfileResource + " : " + e);
                    }
                }
                catch (Throwable e) {
                    if (subLog == null) break block9;
                    subLog.log("Exception while parsing classfile " + workUnit.classfileResource, e);
                }
            }
            this.interruptionChecker.check();
        }
    }

    private static class ClassfileScanWorkUnit {
        final ClasspathElement classpathElement;
        final Resource classfileResource;
        final boolean isExternalClass;

        ClassfileScanWorkUnit(ClasspathElement classpathElement, Resource classfileResource, boolean isExternalClass) {
            this.classpathElement = classpathElement;
            this.classfileResource = classfileResource;
            this.isExternalClass = isExternalClass;
        }
    }

    static class RawClasspathElementWorkUnit {
        final String rawClasspathEltPath;
        final ClasspathElement parentClasspathElement;
        final int orderWithinParentClasspathElement;

        public RawClasspathElementWorkUnit(String rawClasspathEltPath, ClasspathElement parentClasspathElement, int orderWithinParentClasspathElement) {
            this.rawClasspathEltPath = rawClasspathEltPath;
            this.parentClasspathElement = parentClasspathElement;
            this.orderWithinParentClasspathElement = orderWithinParentClasspathElement;
        }
    }
}

