/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="feature", name="refresh", description="Reloads features processing instructions and reprovisions existing features.")
@Service
public class RefreshFeaturesCommand
extends FeaturesCommandSupport {
    @Option(name="-v", aliases={"--verbose"}, description="Explain what is being done", required=false, multiValued=false)
    boolean verbose;
    @Option(name="-t", aliases={"--simulate"}, description="Perform a simulation only", required=false, multiValued=false)
    boolean simulate;
    @Option(name="--features-wiring", description="Print the wiring between features")
    boolean featuresWiring;
    @Option(name="--all-wiring", description="Print the full wiring")
    boolean allWiring;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        this.addOption(FeaturesService.Option.Simulate, this.simulate);
        this.addOption(FeaturesService.Option.Verbose, this.verbose);
        this.addOption(FeaturesService.Option.DisplayFeaturesWiring, this.featuresWiring);
        this.addOption(FeaturesService.Option.DisplayAllWiring, this.allWiring);
        try {
            featuresService.refreshFeatures(this.options);
        }
        catch (Exception e) {
            System.err.println("Error refreshing features: " + e.getMessage());
        }
    }
}

