/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.PropertyData;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Role;

public class RoleData {
    protected String name;
    protected int type;
    protected List<PropertyData<? extends Object>> properties = new ArrayList<PropertyData<? extends Object>>();

    public RoleData(Role role) {
        this(role.getName(), role.getType(), role.getProperties());
    }

    public RoleData(String name, int type) {
        this(name, type, null);
    }

    public RoleData(String name, int type, Dictionary properties) {
        this.name = name;
        this.type = type;
        if (properties != null) {
            Enumeration e = properties.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement().toString();
                this.properties.add(PropertyData.newInstance(key, properties.get(key)));
            }
        }
    }

    public CompositeData toCompositeData() {
        try {
            HashMap<String, Object> items = new HashMap<String, Object>();
            items.put("Name", this.name);
            items.put("Type", this.type);
            return new CompositeDataSupport(UserAdminMBean.ROLE_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Can't create CompositeData" + e);
        }
    }

    protected TabularData getPropertiesTable() {
        return RoleData.getPropertiesTable(this.properties);
    }

    protected static TabularData getPropertiesTable(List<PropertyData<? extends Object>> data) {
        TabularDataSupport propertiesTable = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        for (PropertyData<? extends Object> propertyData : data) {
            propertiesTable.put(propertyData.toCompositeData());
        }
        return propertiesTable;
    }

    public static RoleData from(CompositeData data) {
        if (data == null) {
            return null;
        }
        String name = (String)data.get("Name");
        int type = (Integer)data.get("Type");
        return new RoleData(name, type, null);
    }

    protected static TabularData toTabularData(Dictionary<String, Object> props) {
        if (props == null) {
            return null;
        }
        TabularDataSupport data = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            data.put(PropertyData.newInstance(key, props.get(key)).toCompositeData());
        }
        return data;
    }

    protected static Dictionary<String, Object> propertiesFrom(TabularData data) {
        if (data == null) {
            return null;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (CompositeData compositeData : data.values()) {
            PropertyData property = PropertyData.from(compositeData);
            ((Dictionary)props).put(property.getKey(), property.getValue());
        }
        return props;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }
}

