/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.core.PageParams;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GetInfluencersRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField INFLUENCER_SCORE = new ParseField("influencer_score", new String[0]);
    public static final ParseField SORT = new ParseField("sort", new String[0]);
    public static final ParseField DESCENDING = new ParseField("desc", new String[0]);
    public static final ConstructingObjectParser<GetInfluencersRequest, Void> PARSER = new ConstructingObjectParser("get_influencers_request", a -> new GetInfluencersRequest((String)a[0]));
    private final String jobId;
    private Boolean excludeInterim;
    private String start;
    private String end;
    private Double influencerScore;
    private PageParams pageParams;
    private String sort;
    private Boolean descending;

    public GetInfluencersRequest(String jobId) {
        this.jobId = Objects.requireNonNull(jobId);
    }

    public String getJobId() {
        return this.jobId;
    }

    public Boolean getExcludeInterim() {
        return this.excludeInterim;
    }

    public void setExcludeInterim(Boolean excludeInterim) {
        this.excludeInterim = excludeInterim;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public Double getInfluencerScore() {
        return this.influencerScore;
    }

    public void setInfluencerScore(Double influencerScore) {
        this.influencerScore = influencerScore;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public Boolean getDescending() {
        return this.descending;
    }

    public void setDescending(Boolean descending) {
        this.descending = descending;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.excludeInterim != null) {
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.pageParams != null) {
            builder.field(PageParams.PAGE.getPreferredName(), this.pageParams);
        }
        if (this.influencerScore != null) {
            builder.field(INFLUENCER_SCORE.getPreferredName(), this.influencerScore);
        }
        if (this.sort != null) {
            builder.field(SORT.getPreferredName(), this.sort);
        }
        if (this.descending != null) {
            builder.field(DESCENDING.getPreferredName(), this.descending);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.excludeInterim, this.influencerScore, this.pageParams, this.start, this.end, this.sort, this.descending);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetInfluencersRequest other = (GetInfluencersRequest)obj;
        return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.influencerScore, other.influencerScore) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.descending, other.descending);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareBoolean(GetInfluencersRequest::setExcludeInterim, EXCLUDE_INTERIM);
        PARSER.declareStringOrNull(GetInfluencersRequest::setStart, START);
        PARSER.declareStringOrNull(GetInfluencersRequest::setEnd, END);
        PARSER.declareObject(GetInfluencersRequest::setPageParams, PageParams.PARSER, PageParams.PAGE);
        PARSER.declareDouble(GetInfluencersRequest::setInfluencerScore, INFLUENCER_SCORE);
        PARSER.declareString(GetInfluencersRequest::setSort, SORT);
        PARSER.declareBoolean(GetInfluencersRequest::setDescending, DESCENDING);
    }
}

