/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.discovery;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.cellar.core.discovery.DiscoveryService;
import org.apache.karaf.cellar.core.utils.CellarUtils;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTask
implements Runnable {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DiscoveryTask.class);
    private List<DiscoveryService> discoveryServices;
    private ConfigurationAdmin configurationAdmin;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public void init() {
        LOGGER.debug("CELLAR DISCOVERY: a new Task initialized");
        this.scheduler.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.SECONDS);
    }

    public void destroy() {
        LOGGER.debug("CELLAR DISCOVERY: task is being destroyed");
        this.scheduler.shutdown();
    }

    @Override
    public void run() {
        block9: {
            LOGGER.trace("CELLAR DISCOVERY: starting the discovery task");
            if (this.configurationAdmin != null) {
                LinkedHashSet<String> members = new LinkedHashSet<String>();
                if (this.discoveryServices != null && !this.discoveryServices.isEmpty()) {
                    for (DiscoveryService service : this.discoveryServices) {
                        service.refresh();
                        Set<String> discovered = service.discoverMembers();
                        members.addAll(discovered);
                        LOGGER.trace("CELLAR DISCOVERY: service {} found members {}", (Object)service, discovered);
                    }
                    try {
                        LOGGER.trace("CELLAR DISCOVERY: retrieving configuration for PID={}", (Object)"org.apache.karaf.cellar.discovery");
                        Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.discovery", null);
                        Hashtable<String, String> properties = configuration.getProperties();
                        if (properties == null) {
                            LOGGER.trace("CELLAR DISCOVERY: configuration is new");
                            properties = new Hashtable<String, String>();
                        }
                        String newMemberText = CellarUtils.createStringFromSet(members, true);
                        String memberText = (String)((Dictionary)properties).get("discoveredMembers");
                        if (newMemberText != null && newMemberText.length() > 0 && !newMemberText.equals(memberText)) {
                            ((Dictionary)properties).put("discoveredMembers", newMemberText);
                            LOGGER.trace("CELLAR DISCOVERY: adding a new member {} to configuration and updating it", (Object)newMemberText);
                            configuration.update(properties);
                            break block9;
                        }
                        LOGGER.trace("CELLAR DISCOVERY: found a valid member in the configuration will skip");
                    }
                    catch (IOException e) {
                        LOGGER.error("CELLAR DISCOVERY: failed to update member list", (Throwable)e);
                    }
                } else {
                    LOGGER.trace("CELLAR DISCOVERY: no discovery services found ... ");
                }
            } else {
                LOGGER.trace("CELLAR DISCOVERY: no config admin found");
            }
        }
    }

    public List<DiscoveryService> getDiscoveryServices() {
        return this.discoveryServices;
    }

    public void setDiscoveryServices(List<DiscoveryService> discoveryServices) {
        this.discoveryServices = discoveryServices;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

