/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpConfigs;
import groovyx.net.http.ToServer;
import groovyx.net.http.TransportingException;
import groovyx.net.http.util.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;

class EmbeddedEncoder {
    EmbeddedEncoder() {
    }

    public static byte[] encode(ChainedHttpConfig config, String contentType, Object content) {
        InMemoryToServer toServer = new InMemoryToServer();
        BiConsumer<ChainedHttpConfig, ToServer> encoder = config.findEncoder(contentType);
        encoder.accept(new ConfigFragment(config, contentType, content), toServer);
        return toServer.getBytes();
    }

    private static class ConfigFragment
    implements ChainedHttpConfig {
        private final ChainedHttpConfig config;
        private final String contentType;
        private final Object content;

        ConfigFragment(ChainedHttpConfig config, String contentType, Object content) {
            this.config = config;
            this.contentType = contentType;
            this.content = content;
        }

        @Override
        public Map<Map.Entry<String, Object>, Object> getContextMap() {
            return this.config.getContextMap();
        }

        @Override
        public ChainedHttpConfig.ChainedResponse getChainedResponse() {
            return this.config.getChainedResponse();
        }

        @Override
        public ChainedHttpConfig.ChainedRequest getChainedRequest() {
            return (ChainedHttpConfig.ChainedRequest)this.getRequest();
        }

        @Override
        public ChainedHttpConfig getParent() {
            return null;
        }

        @Override
        public void context(String contentType, Object id, Object obj) {
            this.config.context(contentType, id, obj);
        }

        @Override
        public HttpConfig.Request getRequest() {
            HttpConfigs.BasicRequest request = new HttpConfigs.BasicRequest(null);
            Charset charset = this.config.getChainedRequest().getCharset();
            request.setCharset(charset != null ? charset : StandardCharsets.UTF_8);
            request.setContentType(this.contentType);
            request.setBody(this.content);
            return request;
        }

        @Override
        public HttpConfig.Response getResponse() {
            return this.config.getResponse();
        }
    }

    private static class InMemoryToServer
    implements ToServer {
        private byte[] bytes;

        private InMemoryToServer() {
        }

        @Override
        public void toServer(InputStream inputStream) {
            try {
                this.bytes = IoUtils.streamToBytes(inputStream);
            }
            catch (IOException e) {
                throw new TransportingException("Unable to perform embedded encoding", e);
            }
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

