/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.gcp.GcpAddress;
import com.hazelcast.gcp.GcpAuthenticator;
import com.hazelcast.gcp.GcpComputeApi;
import com.hazelcast.gcp.GcpConfig;
import com.hazelcast.gcp.GcpDiscoveryStrategy;
import com.hazelcast.gcp.GcpMetadataApi;
import com.hazelcast.gcp.Label;
import com.hazelcast.gcp.RetryUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

class GcpClient {
    private static final ILogger LOGGER = Logger.getLogger(GcpDiscoveryStrategy.class);
    private static final int RETRIES = 10;
    private final GcpMetadataApi gcpMetadataApi;
    private final GcpComputeApi gcpComputeApi;
    private final GcpAuthenticator gcpAuthenticator;
    private final String privateKeyPath;
    private final List<String> projects;
    private final List<String> zones;
    private final Label label;

    GcpClient(GcpMetadataApi gcpMetadataApi, GcpComputeApi gcpComputeApi, GcpAuthenticator gcpAuthenticator, GcpConfig gcpConfig) {
        this.gcpMetadataApi = gcpMetadataApi;
        this.gcpComputeApi = gcpComputeApi;
        this.gcpAuthenticator = gcpAuthenticator;
        this.privateKeyPath = gcpConfig.getPrivateKeyPath();
        this.projects = this.projectFromConfigOrMetadataApi(gcpConfig);
        this.zones = this.zonesFromConfigOrMetadataApi(gcpConfig);
        this.label = gcpConfig.getLabel();
    }

    private List<String> projectFromConfigOrMetadataApi(GcpConfig gcpConfig) {
        if (!gcpConfig.getProjects().isEmpty()) {
            return gcpConfig.getProjects();
        }
        LOGGER.finest("Property 'projects' not configured, fetching the current GCP project");
        return Collections.singletonList(RetryUtils.retry(new Callable<String>(){

            @Override
            public String call() {
                return GcpClient.this.gcpMetadataApi.currentProject();
            }
        }, 10));
    }

    private List<String> zonesFromConfigOrMetadataApi(GcpConfig gcpConfig) {
        if (!gcpConfig.getZones().isEmpty()) {
            return gcpConfig.getZones();
        }
        LOGGER.finest("Property 'zones' not configured, fetching the current GCP zone");
        return Collections.singletonList(RetryUtils.retry(new Callable<String>(){

            @Override
            public String call() {
                return GcpClient.this.gcpMetadataApi.currentZone();
            }
        }, 10));
    }

    List<GcpAddress> getAddresses() {
        return RetryUtils.retry(new Callable<List<GcpAddress>>(){

            @Override
            public List<GcpAddress> call() {
                return GcpClient.this.fetchGcpAddresses();
            }
        }, 10);
    }

    private List<GcpAddress> fetchGcpAddresses() {
        LOGGER.finest("Fetching OAuth Access Token");
        String accessToken = this.fetchAccessToken();
        ArrayList<GcpAddress> result = new ArrayList<GcpAddress>();
        for (String project : this.projects) {
            for (String zone : this.zones) {
                LOGGER.finest(String.format("Fetching instances for project '%s' and zone '%s'", project, zone));
                List<GcpAddress> addresses = this.gcpComputeApi.instances(project, zone, this.label, accessToken);
                LOGGER.finest(String.format("Found the following instances for project '%s' and zone '%s': %s", project, zone, addresses));
                result.addAll(addresses);
            }
        }
        return result;
    }

    private String fetchAccessToken() {
        if (this.privateKeyPath != null) {
            return this.gcpAuthenticator.refreshAccessToken(this.privateKeyPath);
        }
        return this.gcpMetadataApi.accessToken();
    }

    String getAvailabilityZone() {
        return this.gcpMetadataApi.currentZone();
    }
}

