/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.Messages;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ParameterSettingsSection;
import org.apache.uima.taeconfigurator.model.ConfigGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractSectionParm
extends AbstractSection {
    public static final String NOT_IN_ANY_GROUP = Messages.getString("AbstractSectionParm.notInAnyGroup");
    public static final String COMMON_GROUP = Messages.getString("AbstractSectionParm.common");
    protected static final String DELEGATE_HEADER = Messages.getString("AbstractSectionParm.delegateKeyName");
    protected static final String FLOWCTLR_HEADER = "Flow Controller Key Name: ";
    protected static final String GROUP_HEADER = Messages.getString("AbstractSectionParm.headerGroupNames");
    protected static final String COMMON_GROUP_HEADER = Messages.getString("AbstractSectionParm.headerCommon");
    protected static final String NOT_IN_ANY_GROUP_HEADER = Messages.getString("AbstractSectionParm.headerNotInAnyGroup");
    protected final String OVERRIDE_HEADER = Messages.getString("AbstractSectionParm.overrides");
    protected static final String MULTI_VALUE_INDICATOR = "Multi  ";
    protected static final String SINGLE_VALUE_INDICATOR = "Single ";
    protected static final String OPTIONAL_INDICATOR = "Opt ";
    protected static final String REQUIRED_INDICATOR = "Req ";
    protected static final String EXTERNAL_OVERRIDE_INDICATOR = "XO ";
    protected static final String NO_EXTERNAL_OVERRIDE_INDICATOR = "      ";
    protected final String nameHeader = "  Name: ";
    protected static final Map<String, String> typeNamesW = new HashMap<String, String>(4);
    protected Tree tree;
    protected Tree parameterSectionTree = null;
    protected boolean showOverrides;
    protected boolean splitGroupNames;
    protected ConfigurationParameter[] commonParms;
    protected Map groupParms;
    protected ConfigurationParameterDeclarations cpd;
    protected ParameterSettingsSection settings = null;
    protected Tree settingsTree = null;

    public void setSettings(ParameterSettingsSection v) {
        this.settings = v;
        this.settingsTree = v.getTree();
    }

    public AbstractSectionParm(MultiPageEditor aEditor, Composite parent, String header, String description) {
        super(aEditor, parent, header, description);
    }

    @Override
    public void enable() {
    }

    public abstract void handleEvent(Event var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAndRefillTree(boolean usingGroups) {
        this.cpd = this.getConfigurationParameterDeclarations();
        this.tree.removeAll();
        Tree savedSettingsTree = this.settingsTree;
        this.settingsTree = null;
        this.groupParms = new TreeMap();
        try {
            if (null == this.cpd.getConfigurationParameters()) {
                this.cpd.setConfigurationParameters(configurationParameterArray0);
            }
            this.fillGroup(this.cpd.getConfigurationParameters(), NOT_IN_ANY_GROUP, null);
            if (null == this.cpd.getCommonParameters()) {
                this.cpd.setCommonParameters(configurationParameterArray0);
            }
            if (usingGroups) {
                this.fillGroup(this.cpd.getCommonParameters(), COMMON_GROUP, null);
            }
            ConfigurationGroup[] groups = this.cpd.getConfigurationGroups();
            for (int i = 0; i < groups.length; ++i) {
                ConfigurationParameter[] cps = groups[i].getConfigurationParameters();
                if (null == cps) {
                    cps = configurationParameterArray0;
                    groups[i].setConfigurationParameters(configurationParameterArray0);
                }
                this.fillGroup(groups[i].getConfigurationParameters(), groups[i].getNames(), groups[i]);
            }
            if (this.splitGroupNames) {
                this.fillGroupsFromGroupParms();
            }
            this.expandAllItems(this.tree.getItems());
        }
        finally {
            this.settingsTree = savedSettingsTree;
            this.groupParms = null;
        }
    }

    private void expandAllItems(TreeItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            items[i].setExpanded(true);
            TreeItem[] containedItems = items[i].getItems();
            if (null == containedItems) continue;
            this.expandAllItems(containedItems);
        }
    }

    private void fillGroup(ConfigurationParameter[] parms, String[] names, ConfigurationGroup modelCG) {
        this.fillGroup(parms, AbstractSectionParm.groupNameArrayToString(names), modelCG);
    }

    private void fillGroup(ConfigurationParameter[] parms, String names, ConfigurationGroup modelCG) {
        if (this.splitGroupNames) {
            if (names.equals(COMMON_GROUP)) {
                this.commonParms = parms;
            } else {
                String[] nameArray = this.groupNamesToArray(names);
                if (nameArray.length == 1 && nameArray[0].equals(NOT_IN_ANY_GROUP)) {
                    TreeItem groupItem = this.addGroupToGUI(nameArray[0], modelCG);
                    this.fill(parms, groupItem);
                } else {
                    for (int i = 0; i < nameArray.length; ++i) {
                        ArrayList<Object[]> g = (ArrayList<Object[]>)this.groupParms.get(nameArray[i]);
                        if (null == g) {
                            g = new ArrayList<Object[]>();
                            this.groupParms.put(nameArray[i], g);
                        }
                        g.add(new Object[]{modelCG, parms});
                    }
                }
            }
        } else {
            if (names.equals(COMMON_GROUP)) {
                this.commonParms = parms;
            }
            TreeItem groupItem = this.addGroupToGUI(names, modelCG);
            this.fill(parms, groupItem);
        }
    }

    private void fillGroupsFromGroupParms() {
        for (Map.Entry entry : this.groupParms.entrySet()) {
            String key = (String)entry.getKey();
            List pairs = (List)entry.getValue();
            TreeItem groupItem = this.addGroupToGUI(key, null);
            for (Object[] v : pairs) {
                ConfigurationParameter[] parms = (ConfigurationParameter[])v[1];
                this.fill(parms, groupItem);
            }
            this.fill(this.commonParms, groupItem);
        }
    }

    protected void fill(ConfigurationParameter[] parms, TreeItem group) {
        if (parms == null) {
            return;
        }
        for (int i = 0; i < parms.length; ++i) {
            this.addNewConfigurationParameterToGUI(parms[i], group);
        }
    }

    public static String groupNameArrayToString(String[] strings) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                b.append("   ");
            }
            b.append(strings[i]);
        }
        return b.toString();
    }

    protected String[] groupNamesToArray(String names) {
        int start;
        if (names.equals(NOT_IN_ANY_GROUP)) {
            return new String[]{names};
        }
        ArrayList<String> items = new ArrayList<String>();
        for (start = 0; start < names.length() && names.charAt(start) == ' '; ++start) {
        }
        while (start < names.length()) {
            int end = names.indexOf(32, start);
            if (end == -1) {
                ((AbstractList)items).add(names.substring(start));
                break;
            }
            ((AbstractList)items).add(names.substring(start, end));
            for (start = end; start < names.length() && names.charAt(start) == ' '; ++start) {
            }
        }
        return ((AbstractCollection)items).toArray(stringArray0);
    }

    protected void fillParmItem(TreeItem item, ConfigurationParameter parm) {
        item.setText(this.parmGuiString(parm));
        item.setData((Object)parm);
    }

    protected String parmGuiString(ConfigurationParameter parm) {
        return (parm.isMultiValued() ? MULTI_VALUE_INDICATOR : SINGLE_VALUE_INDICATOR) + (parm.isMandatory() ? REQUIRED_INDICATOR : OPTIONAL_INDICATOR) + typeNamesW.get(parm.getType()) + (parm.getExternalOverrideName() == null ? NO_EXTERNAL_OVERRIDE_INDICATOR : EXTERNAL_OVERRIDE_INDICATOR) + "  Name: " + parm.getName();
    }

    protected void setGroupText(TreeItem groupItem, String names) {
        if (names.equals(COMMON_GROUP)) {
            groupItem.setText(COMMON_GROUP_HEADER);
        } else if (names.equals(NOT_IN_ANY_GROUP)) {
            groupItem.setText(NOT_IN_ANY_GROUP_HEADER);
        } else {
            groupItem.setText(GROUP_HEADER + AbstractSectionParm.groupNameArrayToString(this.groupNamesToArray(names)));
        }
    }

    protected TreeItem addGroupToGUI(String names, ConfigurationGroup cg) {
        TreeItem groupItem = new TreeItem(this.tree, 0);
        this.setGroupText(groupItem, names);
        ConfigGroup mcg = names.equals(COMMON_GROUP) ? new ConfigGroup(this.cpd, 2) : (names.equals(NOT_IN_ANY_GROUP) ? new ConfigGroup(this.cpd, 1) : new ConfigGroup(this.cpd, cg));
        groupItem.setData((Object)mcg);
        String[] nameArray = this.groupNamesToArray(names);
        if (null != this.settingsTree) {
            for (int i = 0; i < nameArray.length; ++i) {
                TreeItem[] settingsItems = this.settingsTree.getItems();
                if (this.containsGroup(nameArray[i], settingsItems)) continue;
                TreeItem settingsItem = new TreeItem(this.settingsTree, 0);
                this.setGroupText(settingsItem, nameArray[i]);
                settingsItem.setData(null);
                this.fill(this.commonParms, settingsItem);
            }
        }
        return groupItem;
    }

    private boolean containsGroup(String groupName, TreeItem[] settingsItems) {
        for (int i = 0; i < settingsItems.length; ++i) {
            if (!groupName.equals(this.getName(settingsItems[i]))) continue;
            return true;
        }
        return false;
    }

    protected void addNewConfigurationParameterToGUI(ConfigurationParameter newCP, TreeItem group) {
        if (null == group) {
            throw new InternalErrorCDE("invalid state");
        }
        if (null != this.settingsTree) {
            boolean isCommonOrNotInAnyGrp = COMMON_GROUP.equals(this.getName(group)) || NOT_IN_ANY_GROUP.equals(this.getName(group));
            TreeItem[] groups = this.getSettingsGroups(group);
            for (int i = 0; i < groups.length; ++i) {
                TreeItem newParmGuiItem = isCommonOrNotInAnyGrp ? new TreeItem(groups[i], 0) : new TreeItem(groups[i], 0, 0);
                this.fillParmItem(newParmGuiItem, newCP);
            }
        }
        if (group.getParent() != this.settingsTree) {
            TreeItem newItem = new TreeItem(group, 0);
            this.fillParmItem(newItem, newCP);
            if (this.showOverrides) {
                this.fillOverrides(newItem, newCP);
            }
        }
    }

    protected void fillOverrides(TreeItem parent, ConfigurationParameter modelCP) {
    }

    protected boolean isOverride(TreeItem item) {
        return item.getText().startsWith(this.OVERRIDE_HEADER);
    }

    protected boolean isParameter(TreeItem item) {
        String s = item.getText();
        return !this.isGroup(item) && !s.startsWith(DELEGATE_HEADER) && !s.startsWith(FLOWCTLR_HEADER) && !item.getText().startsWith(this.OVERRIDE_HEADER);
    }

    protected boolean isGroup(TreeItem item) {
        String s = item.getText();
        return s.startsWith(GROUP_HEADER) || s.startsWith(COMMON_GROUP_HEADER) || s.startsWith(NOT_IN_ANY_GROUP_HEADER);
    }

    protected boolean isNOT_IN_ANY_GROUP(TreeItem item) {
        return item.getText().startsWith(NOT_IN_ANY_GROUP_HEADER);
    }

    protected boolean isCommonGroup(TreeItem item) {
        return item.getText().startsWith(COMMON_GROUP_HEADER);
    }

    protected boolean isDelegate(TreeItem item) {
        return item.getText().startsWith(DELEGATE_HEADER) || item.getText().startsWith(FLOWCTLR_HEADER);
    }

    protected boolean isGroupSelection() {
        return this.isGroup(this.tree.getSelection()[0]);
    }

    protected boolean isCommonGroupSelection() {
        return this.isCommonGroup(this.tree.getSelection()[0]);
    }

    protected boolean isOverrideSelection() {
        return this.isOverride(this.tree.getSelection()[0]);
    }

    protected boolean isParmSelection() {
        return this.isParameter(this.tree.getSelection()[0]);
    }

    protected String getName(TreeItem item) {
        return this.getName(item.getText());
    }

    protected String getName(String s) {
        if (s.startsWith(NOT_IN_ANY_GROUP_HEADER)) {
            return NOT_IN_ANY_GROUP;
        }
        if (s.startsWith(COMMON_GROUP_HEADER)) {
            return COMMON_GROUP;
        }
        if (s.startsWith(GROUP_HEADER)) {
            return s.substring(GROUP_HEADER.length());
        }
        if (s.startsWith(this.OVERRIDE_HEADER)) {
            return s.substring(this.OVERRIDE_HEADER.length());
        }
        return s.substring(s.indexOf("  Name: ") + "  Name: ".length());
    }

    protected int getItemIndex(TreeItem parent, TreeItem child) {
        return this.getItemIndex(parent.getItems(), child);
    }

    protected int getItemIndex(Tree parent, TreeItem child) {
        return this.getItemIndex(parent.getItems(), child);
    }

    protected TreeItem[] getSettingsParameter(TreeItem containingGroup, String sourceItemName) {
        if (null == this.settingsTree) {
            return null;
        }
        if (null != containingGroup && this.isNOT_IN_ANY_GROUP(containingGroup)) {
            return new TreeItem[]{this.findMatchingParm(this.settingsTree.getItems()[0], sourceItemName)};
        }
        TreeItem[] groups = this.getSettingsGroups(null == containingGroup ? this.tree.getItems()[1] : containingGroup);
        TreeItem[] results = new TreeItem[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            results[i] = this.findMatchingParm(groups[i], sourceItemName);
        }
        return results;
    }

    private TreeItem findMatchingParm(TreeItem group, String name) {
        TreeItem[] items = group.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!name.equals(this.getName(items[i]))) continue;
            return items[i];
        }
        throw new InternalErrorCDE("invalid state");
    }

    protected TreeItem[] getSettingsGroups(TreeItem group) {
        if (null == this.settingsTree) {
            return null;
        }
        if (this.isNOT_IN_ANY_GROUP(group)) {
            return new TreeItem[]{this.settingsTree.getItems()[0]};
        }
        ArrayList<TreeItem> results = new ArrayList<TreeItem>();
        String[] groupNamesArray = this.groupNamesToArray(this.getName(group.getText()));
        TreeItem[] items = this.settingsTree.getItems();
        if (groupNamesArray.length == 1 && groupNamesArray[0].equals(COMMON_GROUP)) {
            TreeItem[] result = new TreeItem[items.length - 1];
            System.arraycopy(items, 1, result, 0, result.length);
            return result;
        }
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            String name = this.getName(items[itemIndex].getText());
            for (int i = 0; i < groupNamesArray.length; ++i) {
                if (!name.equals(groupNamesArray[i])) continue;
                ((AbstractList)results).add(items[itemIndex]);
            }
        }
        return ((AbstractCollection)results).toArray(treeItemArray0);
    }

    protected TreeItem getSettingsGroupTreeItemByName(String name) {
        TreeItem[] items = this.settingsTree.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!name.equals(this.getName(items[i].getText()))) continue;
            return items[i];
        }
        throw new InternalErrorCDE("invalid state");
    }

    protected ConfigurationParameter getCorrespondingModelParm(TreeItem item) {
        if (!this.isParameter(item)) {
            throw new InternalErrorCDE("invalid argument");
        }
        return (ConfigurationParameter)item.getData();
    }

    protected ConfigGroup getCorrespondingModelGroup(TreeItem item) {
        if (!this.isGroup(item)) {
            throw new InternalErrorCDE("invalid argument");
        }
        return (ConfigGroup)item.getData();
    }

    public ConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.editor.getAeDescription().getMetaData().getConfigurationParameterSettings();
    }

    public ConfigurationParameterSettings getModelSettings() {
        return this.getAnalysisEngineMetaData().getConfigurationParameterSettings();
    }

    public void removeParmSettingFromMultipleGroups(TreeItem parmItem, boolean removeFromGUI) {
        int i;
        if (!this.isParameter(parmItem)) {
            throw new InternalErrorCDE("invalid argument");
        }
        ConfigurationParameterSettings modelSettings = this.getModelSettings();
        String parmName = this.getName(parmItem);
        TreeItem parent = parmItem.getParentItem();
        String groupName = this.getName(parent.getText());
        if (!groupName.equals(NOT_IN_ANY_GROUP)) {
            String[] groupNames = this.getName(parent.getText()).equals(COMMON_GROUP) ? this.getAllGroupNames() : this.getCorrespondingModelGroup(parent).getNameArray();
            for (i = 0; i < groupNames.length; ++i) {
                modelSettings.setParameterValue(groupNames[i], parmName, null);
            }
        } else {
            modelSettings.setParameterValue(parmName, null);
        }
        if (null != this.settings) {
            if (removeFromGUI) {
                TreeItem[] settingsTreeParms = this.getSettingsParameter(parent, parmName);
                for (i = 0; i < settingsTreeParms.length; ++i) {
                    settingsTreeParms[i].dispose();
                }
            } else {
                this.editor.getSettingsPage().getValueSection().refresh();
            }
        }
    }

    public void updateParmInSettingsGUI(ConfigurationParameter existingCP, TreeItem existingTreeItem, String prevName) {
        if (null != this.settings) {
            TreeItem[] settingsTreeParms = this.getSettingsParameter(existingTreeItem.getParentItem(), prevName);
            for (int i = 0; i < settingsTreeParms.length; ++i) {
                this.fillParmItem(settingsTreeParms[i], existingCP);
            }
        }
    }

    protected String[] getAllGroupNames() {
        return this.getAllGroupNames(this.cpd);
    }

    protected String[] getAllGroupNames(ConfigurationParameterDeclarations aCpd) {
        ConfigurationGroup[] cgs = aCpd.getConfigurationGroups();
        TreeSet<String> results = new TreeSet<String>();
        for (int i = 0; i < cgs.length; ++i) {
            String[] names = cgs[i].getNames();
            for (int j = 0; j < names.length; ++j) {
                results.add(names[j]);
            }
        }
        return results.toArray(stringArray0);
    }

    public void removeCommonParmSettingsFromMultipleGroups() {
        ConfigurationParameterSettings modelSettings = this.getModelSettings();
        String[] allGroupNames = this.getAllGroupNames();
        this.commonParms = this.cpd.getCommonParameters();
        for (int i = 0; i < allGroupNames.length; ++i) {
            for (int j = 0; j < this.commonParms.length; ++j) {
                modelSettings.setParameterValue(allGroupNames[i], this.commonParms[j].getName(), null);
            }
        }
        if (null != this.settings) {
            for (int j = 0; j < this.commonParms.length; ++j) {
                TreeItem[] settingsParms = this.getSettingsParameter(null, this.commonParms[j].getName());
                for (int k = 0; k < settingsParms.length; ++k) {
                    settingsParms[k].dispose();
                }
            }
        }
    }

    public void removeIncludedParmSettingsFromMultipleGroups(String[] groupNames, ConfigurationParameter[] cps) {
        for (int j = 0; j < groupNames.length; ++j) {
            this.removeIncludedParmSettingsFromSingleGroup(groupNames[j], cps);
        }
    }

    public void removeIncludedParmSettingsFromSingleGroup(String groupName, ConfigurationParameter[] cps) {
        ConfigurationParameterSettings modelSettings = this.getModelSettings();
        if (groupName.equals(COMMON_GROUP)) {
            throw new InternalErrorCDE("invalid state");
        }
        if (groupName.equals(NOT_IN_ANY_GROUP)) {
            modelSettings.setParameterSettings(nameValuePairArray0);
        } else {
            for (int i = 0; i < cps.length; ++i) {
                modelSettings.setParameterValue(groupName, cps[i].getName(), null);
            }
        }
        if (null != this.settings) {
            TreeItem settingGroup = this.getSettingsGroupTreeItemByName(groupName);
            if (groupName.equals(COMMON_GROUP) || groupName.equals(NOT_IN_ANY_GROUP)) {
                this.disposeAllChildItems(settingGroup);
            } else if (this.getConfigurationParameterDeclarations().getConfigurationGroupDeclarations(groupName).length == 1) {
                settingGroup.dispose();
            } else {
                for (int i = 0; i < cps.length; ++i) {
                    this.findMatchingParm(settingGroup, cps[i].getName()).dispose();
                }
            }
        }
    }

    public void disposeAllChildItems(TreeItem parent) {
        TreeItem[] items = parent.getItems();
        for (int j = 0; j < items.length; ++j) {
            items[j].dispose();
        }
    }

    protected void showDescriptionAsToolTip(Event event) {
        TreeItem item = this.tree.getItem(new Point(event.x, event.y));
        Object text = null;
        if (null != item && this.isParameter(item)) {
            text = this.getCorrespondingModelParm(item).getDescription();
            String extOvr = this.getCorrespondingModelParm(item).getExternalOverrideName();
            if (extOvr != null) {
                text = text == null ? "(ExternalOverrideName = " + extOvr + ")" : (String)text + " (ExternalOverrideName = " + extOvr + ")";
            }
        }
        if (text != null) {
            AbstractSectionParm.setToolTipText((Control)this.tree, text);
        } else {
            this.tree.setToolTipText("");
        }
    }

    static {
        typeNamesW.put("Boolean", "Boolean ");
        typeNamesW.put("Float", "Float      ");
        typeNamesW.put(Messages.getString("AbstractSectionParm.16"), "Integer   ");
        typeNamesW.put("String", "String     ");
    }
}

