/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.util.TCasFormatter;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public class TCasToInlineXml
implements TCasFormatter {
    public void destroy() {
    }

    @Override
    public String format(CAS aCAS) throws CASException {
        return this.generateXML(aCAS, null);
    }

    @Override
    public String format(CAS aCAS, FSMatchConstraint aFilter) throws CASException {
        return this.generateXML(aCAS, aFilter);
    }

    public String generateXML(CAS aCAS) throws CASException {
        return this.generateXML(aCAS, null);
    }

    public String generateXML(CAS aCAS, FSMatchConstraint aFilter) throws CASException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer sax2xml = new XMLSerializer(byteArrayOutputStream);
        String docText = aCAS.getDocumentText();
        char[] docCharArray = docText.toCharArray();
        this.replaceInvalidXmlChars(docCharArray);
        FSIterator iterator = aCAS.getAnnotationIndex().iterator();
        if (aFilter != null) {
            iterator = aCAS.createFilteredIterator(iterator, aFilter);
        }
        ArrayList<AnnotationFS> stack = new ArrayList<AnnotationFS>();
        int pos = 0;
        try {
            ContentHandler handler = sax2xml.getContentHandler();
            handler.startDocument();
            handler.startElement("", "Document", "Document", new AttributesImpl());
            AnnotationFS curAnnot = null;
            while (iterator.isValid()) {
                AnnotationFS nextAnnot = (AnnotationFS)iterator.get();
                if (curAnnot == null || nextAnnot.getBegin() < curAnnot.getEnd()) {
                    if (curAnnot == null || nextAnnot.getEnd() <= curAnnot.getEnd()) {
                        try {
                            handler.characters(docCharArray, pos, nextAnnot.getBegin() - pos);
                            pos = nextAnnot.getBegin();
                            handler.startElement("", nextAnnot.getType().getName(), nextAnnot.getType().getName(), this.getFeatureAttributes(nextAnnot, aCAS));
                            stack.add(curAnnot);
                            curAnnot = nextAnnot;
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            System.err.println("Invalid annotation range: " + nextAnnot.getBegin() + "," + nextAnnot.getEnd() + " in document of length " + docText.length());
                        }
                    }
                    iterator.moveToNext();
                    continue;
                }
                try {
                    handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                    pos = curAnnot.getEnd();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + " in document of length " + docText.length());
                }
                handler.endElement("", curAnnot.getType().getName(), curAnnot.getType().getName());
                curAnnot = (AnnotationFS)stack.remove(stack.size() - 1);
            }
            if (curAnnot != null) {
                try {
                    handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                    pos = curAnnot.getEnd();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + "in document of length " + docText.length());
                }
                handler.endElement("", curAnnot.getType().getName(), curAnnot.getType().getName());
                while (!stack.isEmpty() && (curAnnot = (AnnotationFS)stack.remove(stack.size() - 1)) != null) {
                    try {
                        handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                        pos = curAnnot.getEnd();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + "in document of length " + docText.length());
                    }
                    handler.endElement("", curAnnot.getType().getName(), curAnnot.getType().getName());
                }
            }
            if (pos < docCharArray.length) {
                handler.characters(docCharArray, pos, docCharArray.length - pos);
            }
            handler.endElement("", "Document", "Document");
            handler.endDocument();
            return new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (SAXException e) {
            throw new UIMARuntimeException(e);
        }
    }

    private final Attributes getFeatureAttributes(FeatureStructure aFS, CAS aCAS) {
        AttributesImpl attrs = new AttributesImpl();
        Type stringType = aCAS.getTypeSystem().getType("uima.cas.String");
        List<Feature> aFeatures = aFS.getType().getFeatures();
        for (Feature feat : aFeatures) {
            int i;
            Object[] vals;
            StringBuffer buf;
            CommonArrayFS<String> arrayFS;
            String featName = feat.getShortName();
            String rangeTypeName = feat.getRange().getName();
            if (aCAS.getTypeSystem().subsumes(stringType, feat.getRange())) {
                Object str = aFS.getStringValue(feat);
                if (str == null) {
                    attrs.addAttribute("", featName, featName, "CDATA", "null");
                    continue;
                }
                if (((String)str).length() > 64) {
                    str = ((String)str).substring(0, 64) + "...";
                }
                attrs.addAttribute("", featName, featName, "CDATA", (String)str);
                continue;
            }
            if ("uima.cas.Integer".equals(rangeTypeName)) {
                attrs.addAttribute("", featName, featName, "CDATA", Integer.toString(aFS.getIntValue(feat)));
                continue;
            }
            if ("uima.cas.Float".equals(rangeTypeName)) {
                attrs.addAttribute("", featName, featName, "CDATA", Float.toString(aFS.getFloatValue(feat)));
                continue;
            }
            if ("uima.cas.StringArray".equals(rangeTypeName)) {
                arrayFS = (StringArrayFS)aFS.getFeatureValue(feat);
                if (arrayFS == null) {
                    attrs.addAttribute("", featName, featName, "CDATA", "null");
                    continue;
                }
                buf = new StringBuffer();
                vals = arrayFS.toArray();
                buf.append('[');
                for (i = 0; i < vals.length - 1; ++i) {
                    buf.append(vals[i]);
                    buf.append(',');
                }
                if (vals.length > 0) {
                    buf.append(vals[vals.length - 1]);
                }
                buf.append(']');
                attrs.addAttribute("", featName, featName, "CDATA", buf.toString());
                continue;
            }
            if ("uima.cas.IntegerArray".equals(rangeTypeName)) {
                arrayFS = (IntArrayFS)aFS.getFeatureValue(feat);
                if (arrayFS == null) {
                    attrs.addAttribute("", featName, featName, "CDATA", "null");
                    continue;
                }
                buf = new StringBuffer();
                vals = arrayFS.toArray();
                buf.append('[');
                for (i = 0; i < vals.length - 1; ++i) {
                    buf.append((int)vals[i]);
                    buf.append(',');
                }
                if (vals.length > 0) {
                    buf.append((int)vals[vals.length - 1]);
                }
                buf.append(']');
                attrs.addAttribute("", featName, featName, "CDATA", buf.toString());
                continue;
            }
            if ("uima.cas.FloatArray".equals(rangeTypeName)) {
                arrayFS = (FloatArrayFS)aFS.getFeatureValue(feat);
                if (arrayFS == null) {
                    attrs.addAttribute("", featName, featName, "CDATA", "null");
                    continue;
                }
                buf = new StringBuffer();
                vals = arrayFS.toArray();
                buf.append('[');
                for (i = 0; i < vals.length - 1; ++i) {
                    buf.append((float)vals[i]);
                    buf.append(',');
                }
                if (vals.length > 0) {
                    buf.append((float)vals[vals.length - 1]);
                }
                buf.append(']');
                attrs.addAttribute("", featName, featName, "CDATA", buf.toString());
                continue;
            }
            FeatureStructure fsVal = aFS.getFeatureValue(feat);
            if (fsVal == null) {
                attrs.addAttribute("", featName, featName, "CDATA", "null");
                continue;
            }
            buf = new StringBuffer();
            buf.append(fsVal.getType().getShortName());
            if (fsVal instanceof AnnotationFS) {
                buf.append(" [");
                Object str = ((AnnotationFS)fsVal).getCoveredText();
                if (((String)str).length() > 64) {
                    str = ((String)str).substring(0, 64) + "...";
                }
                buf.append((String)str);
                buf.append(']');
            }
            attrs.addAttribute("", featName, featName, "CDATA", buf.toString());
        }
        return attrs;
    }

    private void replaceInvalidXmlChars(char[] aChars) {
        for (int i = 0; i < aChars.length; ++i) {
            if (!(aChars[i] < ' ' && aChars[i] != '\t' && aChars[i] != '\n' && aChars[i] != '\r' || aChars[i] > '\ud7ff' && aChars[i] < '\ue000' || aChars[i] == '\ufffe') && aChars[i] != '\uffff') continue;
            aChars[i] = 32;
        }
    }
}

