/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class ByteArray
extends TOP
implements CommonPrimitiveArray<Byte>,
ByteArrayFSImpl,
Iterable<Byte> {
    public static final String _TypeName = "uima.cas.ByteArray";
    public static final int typeIndexID;
    public static final int type;
    private final byte[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private ByteArray() {
        this.theArray = null;
    }

    public ByteArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new byte[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    public ByteArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new byte[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    @Override
    public byte get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, byte v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(byte[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public byte[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = Byte.toString(this.theArray[i + srcPos]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, destPos, length);
        for (int i = 0; i < length; ++i) {
            this.theArray[i + destPos] = Byte.parseByte(src[i + srcPos]);
        }
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    public byte[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS<Byte> v) {
        ByteArray bv = (ByteArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Byte.parseByte(v));
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ByteArray.this.size();
            }

            @Override
            public Byte next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ByteArray.this.get(this.i++);
            }
        };
    }

    public static ByteArray create(JCas jcas, byte[] a) {
        ByteArray byteArray = new ByteArray(jcas, a.length);
        byteArray.copyFromArray(a, 0, 0, a.length);
        return byteArray;
    }

    public boolean contains(byte item) {
        for (byte b : this.theArray) {
            if (b != item) continue;
            return true;
        }
        return false;
    }

    static {
        type = typeIndexID = JCasRegistry.register(ByteArray.class);
    }
}

