/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.internal.util.rb_trees.Int2IntRBT;
import org.apache.uima.jcas.cas.TOP;

public class CasSeqAddrMaps {
    private final List<TOP> tgtId2SrcFs;
    private final Int2IntRBT srcId2TgtId;
    private int nextTgt = 0;

    public CasSeqAddrMaps() {
        this.tgtId2SrcFs = new ArrayList<TOP>();
        this.srcId2TgtId = new Int2IntRBT();
        this.addItemId(null, 0, true);
    }

    public CasSeqAddrMaps(List<TOP> tgtSeq2SrcFs, Int2IntRBT srcAddr2TgtSeq) {
        this.tgtId2SrcFs = tgtSeq2SrcFs;
        this.srcId2TgtId = srcAddr2TgtSeq;
    }

    public void addItemId(TOP srcFs, int tgtId, boolean inTarget) {
        int n;
        if (inTarget) {
            this.tgtId2SrcFs.add(srcFs);
        }
        int n2 = null == srcFs ? 0 : srcFs._id;
        if (inTarget) {
            int n3 = this.nextTgt;
            n = n3;
            this.nextTgt = n3 + 1;
        } else {
            n = -1;
        }
        this.srcId2TgtId.put(n2, n);
    }

    public void addSrcFsForTgt(TOP srcFs, boolean inSrc) {
        if (inSrc) {
            this.srcId2TgtId.put(srcFs._id, this.nextTgt);
            this.tgtId2SrcFs.add(srcFs);
        } else {
            this.tgtId2SrcFs.add(null);
        }
        ++this.nextTgt;
    }

    public TOP getSrcFsFromTgtSeq(int seq) {
        if (seq >= this.tgtId2SrcFs.size()) {
            return null;
        }
        return this.tgtId2SrcFs.get(seq);
    }

    public int getTgtSeqFromSrcAddr(int itemAddr) {
        return this.srcId2TgtId.getMostlyClose(itemAddr);
    }

    public int getNumberSrcFss() {
        return this.srcId2TgtId.size();
    }

    CasSeqAddrMaps copy() {
        CasSeqAddrMaps c = new CasSeqAddrMaps(new ArrayList<TOP>(this.tgtId2SrcFs), this.srcId2TgtId.copy());
        c.nextTgt = this.nextTgt;
        return c;
    }
}

