/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.Arrays;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSectionParm;
import org.apache.uima.taeconfigurator.editors.ui.ParameterSettingsSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.CommonInputDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public class ValueSection
extends AbstractSectionParm {
    private Composite valueTextStack;
    private StackLayout valueTextStackLayout;
    private Text valueText;
    private CCombo valueTextCombo;
    private Composite vtc1;
    private Composite vtc2;
    private Table valueTable;
    private ParameterSettingsSection master;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Composite buttonContainer;
    private ConfigurationParameter selectedCP;
    private ConfigurationParameterSettings modelSettings;

    public ValueSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Values", "Specify the value of the selected configuration parameter.");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.master = this.editor.getSettingsPage().getParameterSettingsSection();
        Composite sectionClient = this.new3ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.toolkit.paintBordersFor(sectionClient);
        this.valueTextStack = this.newComposite(sectionClient);
        this.valueTextStack.setLayoutData((Object)new GridData(784));
        ((GridData)this.valueTextStack.getLayoutData()).horizontalSpan = 2;
        this.valueTextStackLayout = new StackLayout();
        this.valueTextStack.setLayout((Layout)this.valueTextStackLayout);
        this.valueTextStackLayout.marginHeight = 5;
        this.valueTextStackLayout.marginWidth = 5;
        this.vtc1 = this.new2ColumnComposite(this.valueTextStack);
        this.vtc2 = this.new2ColumnComposite(this.valueTextStack);
        this.enableBorders(this.vtc1);
        this.enableBorders(this.vtc2);
        this.toolkit.paintBordersFor(this.vtc1);
        this.toolkit.paintBordersFor(this.vtc2);
        this.valueText = this.newLabeledTextField(this.vtc1, "Value", "Specify the value", 0);
        this.valueTextCombo = this.newLabeledCComboWithTip(this.vtc2, "Value", "Use the combo pulldown to pick True or False");
        this.valueTextCombo.add("true");
        this.valueTextCombo.add("false");
        ValueSection.spacer(sectionClient);
        Label valueListLabel = this.toolkit.createLabel(sectionClient, "Value list:");
        valueListLabel.setLayoutData((Object)new GridData(128));
        this.valueTable = this.newTable(sectionClient, 2, 0);
        this.buttonContainer = this.newButtonContainer(sectionClient);
        this.addButton = this.newPushButton(this.buttonContainer, "Add...", "Click here to add a value to the list.");
        this.editButton = this.newPushButton(this.buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(this.buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        this.upButton = this.newPushButton(this.buttonContainer, "Up", "Click here to move the selected item up by one.");
        this.downButton = this.newPushButton(this.buttonContainer, "Down", "Click here to move the selected item down by one.");
    }

    public void refresh() {
        super.refresh();
        this.master = this.editor.getSettingsPage().getParameterSettingsSection();
        this.valueTextStackLayout.topControl = this.vtc1;
        this.selectedCP = this.master.getSelectedModelParameter();
        if (this.selectedCP == null) {
            this.valueText.setText("");
            this.valueTable.removeAll();
        } else {
            Object modelValue;
            this.modelSettings = this.getModelSettings();
            String groupName = this.master.getSelectedParamGroupName();
            String parmName = this.selectedCP.getName();
            Object object = modelValue = NOT_IN_ANY_GROUP.equals(groupName) ? this.modelSettings.getParameterValue(parmName) : this.modelSettings.getParameterValue(groupName, parmName);
            if (this.selectedCP.isMultiValued()) {
                this.valueText.setText("");
                this.valueTable.removeAll();
                if (modelValue != null && modelValue instanceof Object[]) {
                    Object[] valArr = (Object[])modelValue;
                    for (int i = 0; i < valArr.length; ++i) {
                        TableItem item = new TableItem(this.valueTable, 0);
                        item.setText(valArr[i].toString());
                    }
                }
            } else {
                this.valueTable.removeAll();
                this.valueText.setText(modelValue == null ? "" : modelValue.toString());
                if ("Boolean".equals(this.selectedCP.getType())) {
                    this.valueTextCombo.setText(modelValue == null ? "" : modelValue.toString());
                    this.valueTextStackLayout.topControl = this.vtc2;
                } else {
                    this.valueText.setText(modelValue == null ? "" : modelValue.toString());
                    this.valueTextStackLayout.topControl = this.vtc1;
                }
            }
        }
        this.valueTextStack.layout();
        this.enable();
    }

    @Override
    public void enable() {
        boolean mvValue = null != this.selectedCP && this.selectedCP.isMultiValued();
        this.valueText.setVisible(null != this.selectedCP && !this.selectedCP.isMultiValued());
        this.valueTextCombo.setVisible(null != this.selectedCP && !this.selectedCP.isMultiValued());
        this.addButton.setEnabled(mvValue);
        int selected = this.valueTable.getSelectionIndex();
        this.editButton.setEnabled(mvValue && selected > -1);
        this.removeButton.setEnabled(mvValue && selected > -1);
        this.upButton.setEnabled(mvValue && selected > 0);
        this.downButton.setEnabled(mvValue && selected > -1 && selected < this.valueTable.getItemCount() - 1);
        this.valueText.getParent().redraw();
    }

    @Override
    public void handleEvent(Event event) {
        if (event.widget == this.valueText) {
            this.setParmValue(this.valueText.getText());
        } else if (event.widget == this.valueTextCombo) {
            this.setParmValue(this.valueTextCombo.getText());
        } else if (event.widget == this.addButton) {
            String dataType = this.selectedCP.getType();
            int validationFilter = "Boolean".equals(dataType) ? 32 : ("Integer".equals(dataType) ? 64 : ("Float".equals(dataType) ? 128 : 16));
            CommonInputDialog dialog = new CommonInputDialog(this, "Add value", "Enter a value", validationFilter);
            if (dialog.open() == 1) {
                return;
            }
            TableItem item = new TableItem(this.valueTable, 0);
            item.setText(dialog.getValue());
            this.setCurrentParameterValue(this.valueTable.getItems());
        } else if (event.widget == this.editButton) {
            TableItem item = this.valueTable.getItems()[this.valueTable.getSelectionIndex()];
            CommonInputDialog dialog = new CommonInputDialog(this, "Add value", "Enter a value", 16, item.getText());
            if (dialog.open() == 1) {
                return;
            }
            item.setText(dialog.getValue());
            this.setCurrentParameterValue(this.valueTable.getItems());
        } else if (event.widget == this.upButton) {
            int selection = this.valueTable.getSelectionIndex();
            TableItem[] items = this.valueTable.getItems();
            String temp = items[selection - 1].getText();
            items[selection - 1].setText(items[selection].getText());
            items[selection].setText(temp);
            this.valueTable.setSelection(selection - 1);
            this.setCurrentParameterValue(this.valueTable.getItems());
        } else if (event.widget == this.downButton) {
            int selection = this.valueTable.getSelectionIndex();
            TableItem[] items = this.valueTable.getItems();
            String temp = items[selection + 1].getText();
            items[selection + 1].setText(items[selection].getText());
            items[selection].setText(temp);
            this.valueTable.setSelection(selection + 1);
            this.setCurrentParameterValue(this.valueTable.getItems());
        } else if (event.widget == this.removeButton || event.widget == this.valueTable && event.character == '\u007f') {
            this.handleRemove(event);
        }
        this.enable();
    }

    private void setParmValue(String value) {
        if (null != value) {
            if ("".equals(value)) {
                value = null;
            }
            this.setCurrentParameterValue(value);
        }
    }

    public void handleRemove(Event event) {
        this.valueTable.remove(this.valueTable.getSelectionIndices());
        this.setCurrentParameterValue(this.valueTable.getItems());
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Table getValueTable() {
        return this.valueTable;
    }

    public Text getValueText() {
        return this.valueText;
    }

    private void setCurrentParameterValue(String aValueString) {
        Object value = null;
        if (null != aValueString) {
            String paramType = this.selectedCP.getType();
            try {
                if ("String".equals(paramType)) {
                    value = aValueString;
                } else if ("Integer".equals(paramType)) {
                    value = Integer.valueOf(aValueString);
                } else if ("Float".equals(paramType)) {
                    value = Float.valueOf(aValueString);
                } else if ("Boolean".equals(paramType)) {
                    value = Boolean.valueOf(aValueString);
                }
            }
            catch (NumberFormatException e) {
                Utility.popMessage("Invalid Number", "If typing a floating point exponent, please complete the exponent.\nOtherwise, please retype the proper kind of number", 1);
                return;
            }
        }
        this.setModelValue(value);
    }

    private void setCurrentParameterValue(TableItem[] aValues) {
        Object[] valueArr;
        block10: {
            valueArr = null;
            String paramType = this.selectedCP.getType();
            try {
                if ("String".equals(paramType)) {
                    valueArr = new String[aValues.length];
                    for (int i = 0; i < valueArr.length; ++i) {
                        valueArr[i] = aValues[i].getText();
                    }
                    break block10;
                }
                if ("Integer".equals(paramType)) {
                    valueArr = new Integer[aValues.length];
                    for (int i = 0; i < valueArr.length; ++i) {
                        valueArr[i] = Integer.valueOf(aValues[i].getText());
                    }
                    break block10;
                }
                if ("Float".equals(paramType)) {
                    valueArr = new Float[aValues.length];
                    for (int i = 0; i < valueArr.length; ++i) {
                        valueArr[i] = Float.valueOf(aValues[i].getText());
                    }
                    break block10;
                }
                if ("Boolean".equals(paramType)) {
                    valueArr = new Boolean[aValues.length];
                    for (int i = 0; i < valueArr.length; ++i) {
                        valueArr[i] = Boolean.valueOf(aValues[i].getText());
                    }
                    break block10;
                }
                throw new InternalErrorCDE("invalid state");
            }
            catch (NumberFormatException e) {
                Utility.popMessage("Invalid Number", "One or more values is not of the proper kind of number. If this entry is the only one with the wrong numeric type, Please retype the proper kind of number. Otherwise, use the source page to change all the values to the proper type.", 1);
                return;
            }
        }
        this.setModelValue(valueArr);
    }

    private void setModelValue(Object value) {
        String groupName = this.master.getSelectedParamGroupName();
        boolean changed = false;
        if (COMMON_GROUP.equals(groupName)) {
            ConfigurationGroup[] groups = this.getConfigurationParameterDeclarations().getConfigurationGroups();
            for (int i = 0; i < groups.length; ++i) {
                String[] groupNames = groups[i].getNames();
                for (int j = 0; j < groupNames.length; ++j) {
                    if (this.isSameValue(value, this.modelSettings.getParameterValue(groupNames[j], this.selectedCP.getName()))) continue;
                    this.modelSettings.setParameterValue(groupNames[j], this.selectedCP.getName(), value);
                    changed = true;
                }
            }
        } else if (NOT_IN_ANY_GROUP.equals(groupName)) {
            if (!this.isSameValue(value, this.modelSettings.getParameterValue(this.selectedCP.getName()))) {
                this.modelSettings.setParameterValue(this.selectedCP.getName(), value);
                changed = true;
            }
        } else if (!this.isSameValue(value, this.modelSettings.getParameterValue(groupName, this.selectedCP.getName()))) {
            this.modelSettings.setParameterValue(groupName, this.selectedCP.getName(), value);
            changed = true;
        }
        if (changed) {
            this.editor.setFileDirty();
        }
    }

    private boolean isSameValue(Object v1, Object v2) {
        if (v1 instanceof Object[]) {
            return Arrays.equals((Object[])v1, (Object[])v2);
        }
        if (null == v1) {
            return null == v2;
        }
        return v1.equals(v2);
    }
}

