/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.component.initialize;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.fit.component.ExternalResourceAware;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.descriptor.ExternalResourceLocator;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.ResourceList;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.springframework.beans.SimpleTypeConverter;

public final class ExternalResourceInitializer {
    private static final Object INITIALIZED = new Object();
    private static Map<Object, Object> initializedResources = new WeakHashMap<Object, Object>();

    private ExternalResourceInitializer() {
    }

    public static <T> void initialize(T object, UimaContext context) throws ResourceInitializationException {
        ExternalResourceInitializer.configure(context, object.getClass(), object.getClass(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void configure(UimaContext context, Class<?> baseCls, Class<?> cls, T object) throws ResourceInitializationException {
        if (cls.getSuperclass() != null) {
            ExternalResourceInitializer.configure(context, baseCls, cls.getSuperclass(), object);
        } else {
            ExternalResourceInitializer.initializeNestedResources(context);
        }
        for (Field field : cls.getDeclaredFields()) {
            Object value;
            String prefix;
            if (!ReflectionUtil.isAnnotationPresent(field, ExternalResource.class)) continue;
            ExternalResource era = ReflectionUtil.getAnnotation(field, ExternalResource.class);
            String key = era.key();
            if (key.length() == 0) {
                key = field.getName();
            }
            if (object instanceof ExternalResourceAware && (prefix = ((ExternalResourceAware)object).getResourceName()) != null) {
                key = prefix + "##" + key;
            }
            if ((value = ExternalResourceInitializer.getResourceObject(context, key)) instanceof ExternalResourceLocator) {
                value = ((ExternalResourceLocator)value).getResource();
            }
            if (value == null && era.mandatory()) {
                throw new ResourceInitializationException((Throwable)new IllegalStateException("Mandatory resource [" + key + "] is not set on [" + baseCls + "]"));
            }
            if (value == null) continue;
            field.setAccessible(true);
            try {
                if (value instanceof ResourceList) {
                    ResourceList resList = (ResourceList)value;
                    ArrayList<Object> elements = new ArrayList<Object>();
                    for (int i = 0; i < resList.getSize(); ++i) {
                        Object elementValue = ExternalResourceInitializer.getResourceObject(context, resList.getResourceName() + "##" + "ELEMENT" + "[" + i + "]");
                        elements.add(elementValue);
                    }
                    SimpleTypeConverter converter = new SimpleTypeConverter();
                    value = converter.convertIfNecessary(elements, field.getType());
                }
                try {
                    field.set(object, value);
                }
                catch (IllegalAccessException e) {
                    throw new ResourceInitializationException((Throwable)e);
                }
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private static Object getResourceObject(UimaContext aContext, String aKey) throws ResourceInitializationException {
        Object value;
        try {
            value = aContext.getResourceObject(aKey);
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeNestedResources(UimaContext aContext) throws ResourceInitializationException {
        ArrayList<ExternalResourceAware> awareResources = new ArrayList<ExternalResourceAware>();
        for (Object r : ExternalResourceInitializer.getResources(aContext)) {
            Map<Object, Object> map = initializedResources;
            synchronized (map) {
                if (r instanceof ExternalResourceAware && !initializedResources.containsKey(r)) {
                    initializedResources.put(r, INITIALIZED);
                    ExternalResourceInitializer.initialize(r, aContext);
                    awareResources.add((ExternalResourceAware)r);
                }
            }
        }
        for (ExternalResourceAware res : awareResources) {
            res.afterResourcesInitialized();
        }
    }

    private static Collection<?> getResources(UimaContext aContext) throws ResourceInitializationException {
        if (!(aContext instanceof UimaContextAdmin)) {
            return Collections.emptyList();
        }
        ResourceManager resMgr = ((UimaContextAdmin)aContext).getResourceManager();
        if (!(resMgr instanceof ResourceManager_impl)) {
            throw new IllegalStateException("Unsupported resource manager implementation [" + resMgr.getClass() + "]");
        }
        return resMgr.getExternalResources();
    }
}

