/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.client;

import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaASProcessStatusImpl;
import org.apache.uima.aae.message.UimaMessageValidator;
import org.apache.uima.adapter.jms.client.BaseMessageSender;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngineCommon_impl;
import org.apache.uima.adapter.jms.message.PendingMessage;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class ActiveMQMessageSender
extends BaseMessageSender {
    private static final Class<?> CLASS_NAME = ActiveMQMessageSender.class;
    private volatile Connection connection = null;
    private Session session = null;
    private MessageProducer producer = null;
    private String destinationName = null;
    private ConcurrentHashMap<Destination, MessageProducer> producerMap = new ConcurrentHashMap();

    public ActiveMQMessageSender(Connection aConnection, String aDestinationName, BaseUIMAAsynchronousEngineCommon_impl engine) throws Exception {
        super(engine);
        this.connection = aConnection;
        this.destinationName = aDestinationName;
    }

    public synchronized MessageProducer getMessageProducer(Destination destination) throws Exception {
        if (this.producerMap.containsKey(destination)) {
            return this.producerMap.get(destination);
        }
        this.createSession();
        MessageProducer mProducer = this.session.createProducer(destination);
        mProducer.setDeliveryMode(1);
        this.producerMap.put(destination, mProducer);
        return mProducer;
    }

    public void setConnection(Connection aConnection) {
        block2: {
            this.connection = aConnection;
            this.cleanup();
            try {
                this.initializeProducer();
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block2;
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "setConnection", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
        }
    }

    private String getBrokerURL() {
        try {
            return ((ActiveMQConnection)this.connection).getBrokerInfo().getBrokerURL();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void createSession() throws Exception {
        String broker = this.getBrokerURL();
        try {
            if (this.session == null || !this.engine.producerInitialized) {
                this.session = this.connection.createSession(false, 1);
            }
        }
        catch (JMSException e) {
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createSession", "jms_adapter_messages", "UIMAJMS_client_failed_creating_session_INFO", new Object[]{this.destinationName, broker});
            }
            if (this.connection == null) {
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createSession", "jms_adapter_messages", "UIMAJMS_client_connection_not_ready_INFO", new Object[]{broker});
                }
            } else if ((((ActiveMQConnection)this.connection).isClosed() || ((ActiveMQConnection)this.connection).isClosing()) && UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "createSession", "jms_adapter_messages", "UIMAJMS_client_connection_closed_INFO", new Object[]{this.destinationName, broker});
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected String getDestinationEndpoint() throws Exception {
        return ((ActiveMQDestination)this.producer.getDestination()).getPhysicalName();
    }

    protected void initializeProducer() throws Exception {
        this.createSession();
        this.producer = this.getMessageProducer((Destination)this.session.createQueue(this.destinationName));
    }

    public MessageProducer getMessageProducer() {
        block4: {
            if (this.engine.running && !this.engine.producerInitialized) {
                try {
                    BaseUIMAAsynchronousEngineCommon_impl.SharedConnection con = this.engine.lookupConnection(this.getBrokerURL());
                    if (con != null) {
                        this.setConnection(con.getConnection());
                        this.initializeProducer();
                        this.engine.producerInitialized = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) break block4;
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "getMessageProducer", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                }
            }
        }
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws Exception {
        Class<ActiveMQMessageSender> clazz = ActiveMQMessageSender.class;
        synchronized (ActiveMQMessageSender.class) {
            if (this.session == null) {
                this.initializeProducer();
            }
            TextMessage msg = null;
            try {
                msg = this.session.createTextMessage("");
            }
            catch (IllegalStateException e) {
                this.session = null;
                this.initializeProducer();
                msg = this.session.createTextMessage("");
            }
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesMessage createBytesMessage() throws Exception {
        Class<ActiveMQMessageSender> clazz = ActiveMQMessageSender.class;
        synchronized (ActiveMQMessageSender.class) {
            if (this.session == null) {
                this.initializeProducer();
            }
            BytesMessage msg = null;
            try {
                msg = this.session.createBytesMessage();
            }
            catch (IllegalStateException e) {
                this.session = null;
                this.initializeProducer();
                msg = this.session.createBytesMessage();
            }
            return msg;
        }
    }

    protected void cleanup() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.producer != null) {
                this.producer.close();
                this.producer = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.producerMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchMessage(PendingMessage pm, BaseUIMAAsynchronousEngineCommon_impl engine, boolean casProcessRequest) throws Exception {
        BaseUIMAAsynchronousEngineCommon_impl.SharedConnection sc = engine.lookupConnection(engine.getBrokerURI());
        BaseUIMAAsynchronousEngineCommon_impl.ClientRequest cacheEntry = null;
        boolean doCallback = false;
        boolean addTimeToLive = true;
        Session jmsSession = null;
        if (System.getProperty("NoTTL") != null) {
            addTimeToLive = false;
        }
        try {
            jmsSession = sc.getConnection().createSession(false, 1);
            Object message = null;
            message = casProcessRequest && engine.getSerialFormat() != SerialFormat.XMI ? jmsSession.createBytesMessage() : jmsSession.createTextMessage();
            Object d = null;
            String selector = null;
            if (pm.get((Object)"TargetingSelector") != null) {
                selector = (String)pm.get((Object)"TargetingSelector");
            }
            d = selector == null && (pm.getMessageType() == 2005 || pm.getMessageType() == 2006) ? (Destination)pm.get((Object)"Destination") : jmsSession.createQueue(this.destinationName);
            MessageProducer mProducer = jmsSession.createProducer((Destination)d);
            mProducer.setDeliveryMode(1);
            super.initializeMessage(pm, (Message)message);
            String destination = ((ActiveMQDestination)d).getPhysicalName();
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_sending_msg_to_endpoint__FINE", new Object[]{UimaMessageValidator.decodeIntToString((String)"Command", (int)message.getIntProperty("Command")), UimaMessageValidator.decodeIntToString((String)"MessageType", (int)message.getIntProperty("MessageType")), destination});
            }
            if (casProcessRequest) {
                cacheEntry = (BaseUIMAAsynchronousEngineCommon_impl.ClientRequest)engine.getCache().get(pm.get((Object)"CasReference"));
                if (cacheEntry != null) {
                    long timeoutValue;
                    if (System.getProperty("UimaAsCasTracking") != null) {
                        message.setStringProperty("UimaAsCasTracking", "enable");
                    }
                    if (cacheEntry.getTargetServiceId() != null) {
                        message.setStringProperty("TargetServiceId", cacheEntry.getTargetServiceId());
                    }
                    if ((timeoutValue = cacheEntry.getProcessTimeout()) > 0L && addTimeToLive) {
                        message.setJMSExpiration(10L * timeoutValue);
                    }
                    if (pm.getMessageType() == 2000) {
                        cacheEntry.setCASDepartureTime(System.nanoTime());
                    }
                    cacheEntry.setCASDepartureTime(System.nanoTime());
                    doCallback = true;
                } else if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_failed_cache_lookup__WARNING", new Object[]{pm.get((Object)"CasReference"), UimaMessageValidator.decodeIntToString((String)"Command", (int)message.getIntProperty("Command")), UimaMessageValidator.decodeIntToString((String)"MessageType", (int)message.getIntProperty("MessageType")), destination});
                }
            }
            if (casProcessRequest) {
                CAS cas = cacheEntry.getCAS();
                engine.serviceDelegate.addCasToOutstandingList(cacheEntry.getCasReferenceId(), cas.hashCode(), engine.timerPerCAS);
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "sendCAS", "jms_adapter_messages", "UIMAJMS_cas_added_to_pending_FINE", new Object[]{cacheEntry.getCasReferenceId(), String.valueOf(cas.hashCode()), engine.serviceDelegate.toString()});
                }
            } else if (pm.getMessageType() == 2001 && engine.serviceDelegate.getGetMetaTimeout() > 0L) {
                if (!engine.serviceDelegate.isAwaitingPingReply()) {
                    engine.serviceDelegate.startGetMetaRequestTimer();
                }
            } else {
                doCallback = false;
            }
            mProducer.send((Message)message);
            if (doCallback) {
                UimaASProcessStatusImpl status = new UimaASProcessStatusImpl((ProcessTrace)new ProcessTrace_impl(), cacheEntry.getCAS(), cacheEntry.getCasReferenceId());
                if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "run", "jms_adapter_messages", "UIMAJMS_calling_onBeforeMessageSend__FINE", new Object[]{pm.get((Object)"CasReference"), String.valueOf(cacheEntry.getCAS().hashCode())});
                }
                engine.onBeforeMessageSend((UimaASProcessStatus)status);
            }
        }
        finally {
            if (jmsSession != null) {
                try {
                    jmsSession.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

