/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public final class DecimalValue
extends NumericValue {
    public static final int DIVIDE_PRECISION = 18;
    private static boolean stripTrailingZerosMethodUnavailable = false;
    private static Method stripTrailingZerosMethod = null;
    private static boolean canSetScaleNegative = true;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private BigDecimal value;
    public static final BigDecimal BIG_DECIMAL_ONE = BigDecimal.valueOf(1L);
    public static final BigInteger BIG_INTEGER_TEN = BigInteger.valueOf(10L);
    public static final BigDecimal BIG_DECIMAL_ONE_MILLION = BigDecimal.valueOf(1000000L);
    public static final DecimalValue ZERO = new DecimalValue(BigDecimal.valueOf(0L));
    public static final DecimalValue ONE = new DecimalValue(BigDecimal.valueOf(1L));
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");

    public DecimalValue(BigDecimal bigDecimal) {
        this.value = DecimalValue.stripTrailingZeros(bigDecimal);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public static AtomicValue makeDecimalValue(CharSequence charSequence, boolean bl) {
        String string = ((Object)Whitespace.trimWhitespace(charSequence)).toString();
        try {
            if (bl && !decimalPattern.matcher(string).matches()) {
                ValidationException validationException = new ValidationException("Cannot convert string " + Err.wrap(string, 4) + " to xs:decimal");
                validationException.setErrorCode("FORG0001");
                return new ValidationErrorValue(validationException);
            }
            BigDecimal bigDecimal = new BigDecimal(string);
            bigDecimal = DecimalValue.stripTrailingZeros(bigDecimal);
            DecimalValue decimalValue = new DecimalValue(bigDecimal);
            return decimalValue;
        }
        catch (NumberFormatException numberFormatException) {
            ValidationException validationException = new ValidationException("Cannot convert string " + Err.wrap(string, 4) + " to xs:decimal");
            validationException.setErrorCode("FORG0001");
            return new ValidationErrorValue(validationException);
        }
    }

    public static boolean castableAsDecimal(CharSequence charSequence) {
        CharSequence charSequence2 = Whitespace.trimWhitespace(charSequence);
        return decimalPattern.matcher(charSequence2).matches();
    }

    public DecimalValue(double d) throws ValidationException {
        try {
            this.value = DecimalValue.stripTrailingZeros(new BigDecimal(d));
        }
        catch (NumberFormatException numberFormatException) {
            ValidationException validationException = new ValidationException("Cannot convert double " + Err.wrap(d + "", 4) + " to decimal");
            validationException.setErrorCode("FOCA0002");
            throw validationException;
        }
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public DecimalValue(long l) {
        this.value = BigDecimal.valueOf(l);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public AtomicValue copy(AtomicType atomicType) {
        DecimalValue decimalValue = new DecimalValue(this.value);
        decimalValue.typeLabel = atomicType;
        return decimalValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DECIMAL;
    }

    private static BigDecimal stripTrailingZeros(BigDecimal bigDecimal) {
        if (stripTrailingZerosMethodUnavailable) {
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
        try {
            Object object;
            if (stripTrailingZerosMethod == null) {
                object = new Class[]{};
                stripTrailingZerosMethod = BigDecimal.class.getMethod("stripTrailingZeros", (Class<?>)object);
            }
            object = stripTrailingZerosMethod.invoke((Object)bigDecimal, EMPTY_OBJECT_ARRAY);
            return (BigDecimal)object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
        catch (IllegalAccessException illegalAccessException) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
        catch (InvocationTargetException invocationTargetException) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(bigDecimal);
        }
    }

    private static BigDecimal stripTrailingZerosFallback(BigDecimal bigDecimal) {
        int n = bigDecimal.scale();
        if (n > 0) {
            BigInteger[] bigIntegerArray;
            BigInteger bigInteger = bigDecimal.unscaledValue();
            while ((bigIntegerArray = bigInteger.divideAndRemainder(BIG_INTEGER_TEN))[1].equals(BigInteger.ZERO)) {
                bigInteger = bigIntegerArray[0];
                if (--n != 0) continue;
                break;
            }
            if (n != bigDecimal.scale()) {
                bigDecimal = new BigDecimal(bigInteger, n);
            }
        }
        return bigDecimal;
    }

    public BigDecimal getDecimalValue() {
        return this.value;
    }

    public int hashCode() {
        BigDecimal bigDecimal = this.value.setScale(0, 1);
        long l = bigDecimal.longValue();
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return (int)l;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean effectiveBooleanValue() {
        return this.value.signum() != 0;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 514: {
                return BooleanValue.get(this.value.signum() != 0);
            }
            case 88: 
            case 515: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                return BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert decimal to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        return DecimalValue.decimalToString(this.value);
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        String string = this.getStringValue();
        if (string.indexOf(46) < 0) {
            string = string + ".0";
        }
        return string;
    }

    public String getStringValue() {
        return ((Object)DecimalValue.decimalToString(this.value)).toString();
    }

    public static CharSequence decimalToString(BigDecimal bigDecimal) {
        int n = bigDecimal.scale();
        if (n == 0) {
            return bigDecimal.toString();
        }
        if (n < 0) {
            String string = bigDecimal.abs().unscaledValue().toString();
            if (string.equals("0")) {
                return string;
            }
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string.length() + -n + 2);
            if (bigDecimal.signum() < 0) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append(string);
            for (int i = 0; i < -n; ++i) {
                fastStringBuffer.append('0');
            }
            return fastStringBuffer;
        }
        String string = bigDecimal.abs().unscaledValue().toString();
        if (string.equals("0")) {
            return string;
        }
        int n2 = string.length();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2 + 1);
        if (bigDecimal.signum() < 0) {
            fastStringBuffer.append('-');
        }
        if (n >= n2) {
            fastStringBuffer.append("0.");
            for (int i = n2; i < n; ++i) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append(string);
        } else {
            fastStringBuffer.append(string.substring(0, n2 - n));
            fastStringBuffer.append('.');
            fastStringBuffer.append(string.substring(n2 - n));
        }
        return fastStringBuffer;
    }

    public NumericValue negate() {
        return new DecimalValue(this.value.negate());
    }

    public NumericValue floor() {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue ceiling() {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue round() {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    public NumericValue roundHalfToEven(int n) {
        BigDecimal bigDecimal;
        if (n < 0 && !canSetScaleNegative) {
            try {
                AtomicValue atomicValue = this.convert(BuiltInAtomicType.INTEGER, null);
                if (atomicValue instanceof Int64Value) {
                    return ((Int64Value)atomicValue).roundHalfToEven(n);
                }
                return ((BigIntegerValue)atomicValue).roundHalfToEven(n);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException("internal error in integer-decimal conversion");
            }
        }
        try {
            bigDecimal = this.value.setScale(n, 6);
        }
        catch (ArithmeticException arithmeticException) {
            if (n < 0) {
                canSetScaleNegative = false;
                return this.roundHalfToEven(n);
            }
            throw arithmeticException;
        }
        return new DecimalValue(DecimalValue.stripTrailingZeros(bigDecimal));
    }

    public double signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.equals(this.value.setScale(0, 1));
    }

    public NumericValue arithmetic(int n, NumericValue numericValue, XPathContext xPathContext) throws XPathException {
        if (numericValue instanceof DecimalValue) {
            try {
                switch (n) {
                    case 15: {
                        return new DecimalValue(this.value.add(((DecimalValue)numericValue).value));
                    }
                    case 16: {
                        return new DecimalValue(this.value.subtract(((DecimalValue)numericValue).value));
                    }
                    case 17: {
                        return new DecimalValue(this.value.multiply(((DecimalValue)numericValue).value));
                    }
                    case 18: {
                        int n2 = Math.max(18, Math.max(this.value.scale(), ((DecimalValue)numericValue).value.scale()));
                        BigDecimal bigDecimal = this.value.divide(((DecimalValue)numericValue).value, n2, 5);
                        return new DecimalValue(bigDecimal);
                    }
                    case 50: {
                        if (((DecimalValue)numericValue).value.signum() == 0) {
                            DynamicError dynamicError = new DynamicError("Integer division by zero");
                            dynamicError.setErrorCode("FOAR0001");
                            dynamicError.setXPathContext(xPathContext);
                            throw dynamicError;
                        }
                        BigInteger bigInteger = this.value.divide(((DecimalValue)numericValue).value, 0, 1).toBigInteger();
                        return BigIntegerValue.makeIntegerValue(bigInteger);
                    }
                    case 19: {
                        BigDecimal bigDecimal = this.value.divide(((DecimalValue)numericValue).value, 0, 1);
                        BigDecimal bigDecimal2 = this.value.subtract(bigDecimal.multiply(((DecimalValue)numericValue).value));
                        return new DecimalValue(bigDecimal2);
                    }
                }
                throw new AssertionError((Object)"Unknown operator");
            }
            catch (ArithmeticException arithmeticException) {
                throw new DynamicError(arithmeticException);
            }
        }
        if (NumericValue.isInteger(numericValue)) {
            return this.arithmetic(n, (DecimalValue)numericValue.convert(BuiltInAtomicType.DECIMAL, xPathContext), xPathContext);
        }
        NumericValue numericValue2 = (NumericValue)this.convert(numericValue.getPrimitiveType(), xPathContext);
        return numericValue2.arithmetic(n, numericValue, xPathContext);
    }

    public int compareTo(Object object) {
        if (NumericValue.isInteger((NumericValue)object)) {
            try {
                return this.compareTo(((NumericValue)object).convert(BuiltInAtomicType.DECIMAL, null));
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (object instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)object).value);
        }
        if (object instanceof FloatValue) {
            try {
                return ((FloatValue)this.convert(BuiltInAtomicType.FLOAT, null)).compareTo(object);
            }
            catch (XPathException xPathException) {
                throw new AssertionError((Object)"Conversion of decimal to float should never fail");
            }
        }
        return super.compareTo(object);
    }

    public int compareTo(long l) {
        if (l == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigDecimal.valueOf(l));
    }

    public Comparable getSchemaComparable() {
        return this.value;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz == Object.class || clazz.isAssignableFrom(BigDecimal.class)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(DecimalValue.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == Boolean.class) {
            BooleanValue booleanValue = (BooleanValue)this.convert(BuiltInAtomicType.BOOLEAN, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new Double(this.value.doubleValue());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.value.floatValue());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long(this.value.longValue());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new Integer(this.value.intValue());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short(this.value.shortValue());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte(this.value.byteValue());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new Character((char)this.value.intValue());
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of decimal to " + clazz.getName() + " is not supported");
        }
        return object;
    }
}

