/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XSLKey
extends StyleElement
implements StylesheetProcedure {
    private Pattern match;
    private Expression use;
    private String collationName;
    SlotManager stackFrameMap;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string4 = this.getNamePool().getClarkName(n);
            if (string4 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string4 == "use") {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            if (string4 == "match") {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (string4 == "collation") {
                this.collationName = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(string.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage(), "XTSE0280");
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        if (string2 == null) {
            this.reportAbsence("match");
            string2 = "*";
        }
        this.match = this.makePattern(string2);
        if (string3 != null) {
            this.use = this.makeExpression(string3);
        }
    }

    public void validate() throws XPathException {
        Serializable serializable;
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.use != null) {
            if (this.hasChildNodes()) {
                this.compileError("An xsl:key element with a @use attribute must be empty", "XTSE1205");
            }
            try {
                serializable = new RoleLocator(4, "xsl:key/use", 0, null);
                ((RoleLocator)serializable).setSourceLocator(new ExpressionLocation(this));
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, (RoleLocator)serializable, this.getStaticContext());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        } else if (!this.hasChildNodes()) {
            this.compileError("An xsl:key element must either have a @use attribute or have content", "XTSE1205");
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
        if (this.use != null) {
            this.use = this.use.typeCheck(this.getStaticContext(), this.match.getNodeTest());
        }
        if (this.collationName != null) {
            try {
                serializable = new URI(this.collationName);
                if (!((URI)serializable).isAbsolute()) {
                    URI uRI = new URI(this.getBaseURI());
                    serializable = uRI.resolve((URI)serializable);
                    this.collationName = ((URI)serializable).toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
            }
        } else {
            this.collationName = this.getDefaultCollationName();
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Serializable serializable;
        Serializable serializable2;
        StaticContext staticContext = this.getStaticContext();
        Configuration configuration = staticContext.getConfiguration();
        StringCollator stringCollator = null;
        if (this.collationName != null) {
            stringCollator = this.getPrincipalStylesheet().findCollation(this.collationName);
            if (stringCollator == null) {
                this.compileError("The collation name " + Err.wrap(this.collationName, 7) + " is not recognized", "XTSE1210");
                stringCollator = CodepointCollator.getInstance();
            }
            if (stringCollator instanceof CodepointCollator) {
                stringCollator = null;
                this.collationName = null;
            } else if (!Configuration.getPlatform().canReturnCollationKeys(stringCollator)) {
                this.compileError("The collation used for xsl:key must be capable of generating collation keys", "XTSE1210");
            }
        }
        if (this.use == null) {
            serializable2 = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
            try {
                this.use = new Atomizer(((Expression)serializable2).simplify(staticContext), configuration);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            try {
                serializable = new RoleLocator(4, "xsl:key/use", 0, null);
                ((RoleLocator)serializable).setSourceLocator(new ExpressionLocation(this));
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, (RoleLocator)serializable, staticContext);
                this.use = this.use.typeCheck(this.getStaticContext(), this.match.getNodeTest());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
        serializable2 = configuration.getTypeHierarchy();
        serializable = (BuiltInAtomicType)this.use.getItemType((TypeHierarchy)serializable2).getPrimitiveItemType();
        if (this.backwardsCompatibleModeIsEnabled() && !((BuiltInAtomicType)serializable).equals(BuiltInAtomicType.STRING) && !((BuiltInAtomicType)serializable).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.use = new AtomicSequenceConverter(this.use, BuiltInAtomicType.STRING);
            serializable = BuiltInAtomicType.STRING;
        }
        this.allocateSlots(this.use);
        this.allocatePatternSlots(this.match, this.stackFrameMap);
        KeyManager keyManager = this.getPrincipalStylesheet().getKeyManager();
        KeyDefinition keyDefinition = new KeyDefinition(this.match, this.use, this.collationName, stringCollator);
        keyDefinition.setIndexedItemType((BuiltInAtomicType)serializable);
        keyDefinition.setStackFrameMap(this.stackFrameMap);
        keyDefinition.setLocation(this.getSystemId(), this.getLineNumber());
        keyDefinition.setExecutable(this.getExecutable());
        keyDefinition.setBackwardsCompatible(this.backwardsCompatibleModeIsEnabled());
        try {
            keyManager.addKeyDefinition(this.getObjectFingerprint(), keyDefinition, executable.getConfiguration());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        return null;
    }
}

