/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.GenericAtomicComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;

public class IndexOf
extends CollatingFunction {
    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        GenericAtomicComparer genericAtomicComparer = this.getAtomicComparer(2, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        return new IndexIterator(sequenceIterator, atomicValue, genericAtomicComparer);
    }

    public static class IndexIterator
    implements SequenceIterator {
        SequenceIterator base;
        AtomicValue value;
        GenericAtomicComparer comparer;
        int index = 0;
        int position = 0;
        Item current = null;
        BuiltInAtomicType primitiveTypeRequired;
        TypeHierarchy typeHierarchy;

        public IndexIterator(SequenceIterator sequenceIterator, AtomicValue atomicValue, GenericAtomicComparer genericAtomicComparer) {
            this.base = sequenceIterator;
            this.value = atomicValue;
            this.comparer = genericAtomicComparer;
            this.primitiveTypeRequired = atomicValue.getPrimitiveType();
        }

        public Item next() throws XPathException {
            AtomicValue atomicValue;
            while ((atomicValue = (AtomicValue)this.base.next()) != null) {
                ++this.index;
                if (!Type.isComparable(this.primitiveTypeRequired, atomicValue.getPrimitiveType(), false)) continue;
                try {
                    if (!this.comparer.comparesEqual(atomicValue, this.value)) continue;
                    this.current = Int64Value.makeIntegerValue(this.index);
                    ++this.position;
                    return this.current;
                }
                catch (ClassCastException classCastException) {
                }
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new IndexIterator(this.base.getAnother(), this.value, this.comparer);
        }

        public int getProperties() {
            return 0;
        }
    }
}

