/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Validation;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.XMLReader;

public class URIQueryParameters {
    FilenameFilter filter = null;
    Boolean recurse = null;
    Integer validation = null;
    int strip = 13;
    Integer onError = null;
    XMLReader parser = null;
    Boolean xinclude = null;
    public static final int ON_ERROR_FAIL = 1;
    public static final int ON_ERROR_WARNING = 2;
    public static final int ON_ERROR_IGNORE = 3;

    public URIQueryParameters(String string, Configuration configuration) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n <= 0 || n >= string2.length() - 1) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (string3.equals("select")) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(string4.length() + 6);
                    fastStringBuffer.append('^');
                    for (int i = 0; i < string4.length(); ++i) {
                        char c = string4.charAt(i);
                        if (c == '.') {
                            fastStringBuffer.append("\\.");
                            continue;
                        }
                        if (c == '*') {
                            fastStringBuffer.append(".*");
                            continue;
                        }
                        fastStringBuffer.append(c);
                    }
                    fastStringBuffer.append('$');
                    String string5 = fastStringBuffer.toString();
                    Pattern pattern = Pattern.compile(string5);
                    this.filter = new RegexFilter(pattern);
                    continue;
                }
                if (string3.equals("recurse")) {
                    this.recurse = "yes".equals(string4);
                    continue;
                }
                if (string3.equals("validation")) {
                    int n2 = Validation.getCode(string4);
                    if (n2 == -1) continue;
                    this.validation = new Integer(n2);
                    continue;
                }
                if (string3.equals("strip-space")) {
                    if (string4.equals("yes")) {
                        this.strip = 12;
                        continue;
                    }
                    if (string4.equals("ignorable")) {
                        this.strip = 11;
                        continue;
                    }
                    if (!string4.equals("no")) continue;
                    this.strip = 10;
                    continue;
                }
                if (string3.equals("xinclude")) {
                    if (string4.equals("yes")) {
                        this.xinclude = Boolean.TRUE;
                        continue;
                    }
                    if (!string4.equals("no")) continue;
                    this.xinclude = Boolean.FALSE;
                    continue;
                }
                if (string3.equals("on-error")) {
                    if (string4.equals("warning")) {
                        this.onError = new Integer(2);
                        continue;
                    }
                    if (string4.equals("ignore")) {
                        this.onError = new Integer(3);
                        continue;
                    }
                    if (!string4.equals("fail")) continue;
                    this.onError = new Integer(1);
                    continue;
                }
                if (!string3.equals("parser")) continue;
                try {
                    if (configuration == null) {
                        configuration = new Configuration();
                    }
                    this.parser = (XMLReader)configuration.getInstance(string4, null);
                }
                catch (XPathException xPathException) {}
            }
        }
    }

    public int getStripSpace() {
        return this.strip;
    }

    public Integer getValidationMode() {
        return this.validation;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public Boolean getRecurse() {
        return this.recurse;
    }

    public Integer getOnError() {
        return this.onError;
    }

    public Boolean getXInclude() {
        return this.xinclude;
    }

    public XMLReader getXMLReader() {
        return this.parser;
    }

    public static class RegexFilter
    implements FilenameFilter {
        private Pattern pattern;

        public RegexFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory() || this.pattern.matcher(string).matches();
        }
    }
}

