/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.LeafCastException;
import org.apache.vinci.transport.util.Base64Converter;
import org.apache.vinci.transport.util.Base64FormatException;
import org.apache.vinci.transport.util.UTFConverter;

public class FrameLeaf
extends FrameComponent {
    public static final String NOT_UTF8_ERROR = "*** ERROR: Data not utf8 ***";
    private final byte[] data;

    public FrameLeaf(byte[] mydata, boolean encode) {
        this.data = encode ? Base64Converter.convertBinaryToBase64(mydata) : mydata;
    }

    public FrameLeaf(String mydata) {
        this.data = UTFConverter.convertStringToUTF(mydata);
    }

    public FrameLeaf(String[] mystring) {
        int i;
        String separator = "#";
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < mystring.length; ++i) {
            if (mystring[i].indexOf(separator) == -1) continue;
            separator = separator + String.valueOf((int)(Math.random() * 10.0));
            --i;
        }
        if (separator.length() > 1) {
            separator = separator + "#";
            buf.append(separator);
        }
        for (i = 0; i < mystring.length; ++i) {
            if (i != 0) {
                buf.append(separator);
            }
            buf.append(mystring[i]);
        }
        this.data = UTFConverter.convertStringToUTF(buf.toString());
    }

    public FrameLeaf(float myfloat_) {
        this(Float.toString(myfloat_));
    }

    public FrameLeaf(float[] myfloat) {
        StringBuffer add_me = new StringBuffer();
        for (int i = 0; i < myfloat.length; ++i) {
            add_me.append(Float.toString(myfloat[i]));
            if (i == myfloat.length - 1) continue;
            add_me.append(' ');
        }
        this.data = UTFConverter.convertStringToUTF(add_me.toString());
    }

    public FrameLeaf(double myfloat) {
        this(Double.toString(myfloat));
    }

    public FrameLeaf(double[] mydouble) {
        StringBuffer add_me = new StringBuffer();
        for (int i = 0; i < mydouble.length; ++i) {
            add_me.append(Double.toString(mydouble[i]));
            if (i == mydouble.length - 1) continue;
            add_me.append(' ');
        }
        this.data = UTFConverter.convertStringToUTF(add_me.toString());
    }

    public FrameLeaf(int myint_) {
        this(Integer.toString(myint_));
    }

    public FrameLeaf(int[] myint) {
        StringBuffer add_me = new StringBuffer();
        for (int i = 0; i < myint.length; ++i) {
            add_me.append(Integer.toString(myint[i]));
            if (i == myint.length - 1) continue;
            add_me.append(' ');
        }
        this.data = UTFConverter.convertStringToUTF(add_me.toString());
    }

    public FrameLeaf(long myint) {
        this(Long.toString(myint));
    }

    public FrameLeaf(long[] mylong) {
        StringBuffer add_me = new StringBuffer();
        for (int i = 0; i < mylong.length; ++i) {
            add_me.append(Long.toString(mylong[i]));
            if (i == mylong.length - 1) continue;
            add_me.append(' ');
        }
        this.data = UTFConverter.convertStringToUTF(add_me.toString());
    }

    public FrameLeaf(boolean bool) {
        this(bool ? "true" : "false");
    }

    public String toString() {
        try {
            return UTFConverter.convertUTFToString(this.data);
        }
        catch (UTFDataFormatException e) {
            return NOT_UTF8_ERROR;
        }
    }

    public String[] toStringArray() {
        String work = this.toString();
        if (work.indexOf(35) == -1) {
            if (work.length() > 0) {
                String[] return_me = new String[]{work};
                return return_me;
            }
            return new String[0];
        }
        if (work.charAt(0) != '#') {
            int size = 0;
            for (int i = 0; i < work.length(); ++i) {
                if (work.charAt(i) != '#') continue;
                ++size;
            }
            String[] return_me = new String[++size];
            int begin = 0;
            int end = 0;
            for (int i = 0; i < size - 1; ++i) {
                end = work.indexOf(35, begin + 1);
                return_me[i] = work.substring(begin, end);
                begin = end + 1;
            }
            return_me[size - 1] = work.substring(begin);
            return return_me;
        }
        int end = work.indexOf(35, 1);
        if (end == -1) {
            throw new LeafCastException("Not a string array: " + this.toString());
        }
        String separator = work.substring(0, end + 1);
        int begin = end + 1;
        ArrayList<String> strings = new ArrayList<String>();
        while ((end = work.indexOf(separator, begin)) != -1) {
            strings.add(work.substring(begin, end));
            begin = end + separator.length();
        }
        strings.add(work.substring(begin));
        String[] return_me = new String[strings.size()];
        for (int i = 0; i < return_me.length; ++i) {
            return_me[i] = strings.get(i).toString();
        }
        return return_me;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] toBytes() {
        try {
            return Base64Converter.convertBase64ToBinary(this.data);
        }
        catch (Base64FormatException e) {
            throw new LeafCastException("Not base64: " + e.getMessage());
        }
    }

    public long toLong() {
        try {
            return UTFConverter.convertUTFToLong(this.data);
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Not an integer: " + this.toString());
        }
    }

    public long[] toLongArray() {
        try {
            String array_string = UTFConverter.convertUTFToString(this.data);
            StringTokenizer tokenizer = new StringTokenizer(array_string);
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            long[] return_me = new long[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                return_me[i] = Long.parseLong((String)tokens.get(i));
            }
            return return_me;
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Array contains non-long: " + this.toString());
        }
    }

    public int toInt() {
        try {
            return UTFConverter.convertUTFToInt(this.data);
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Not an integer: " + this.toString());
        }
    }

    public int[] toIntArray() {
        try {
            String array_string = UTFConverter.convertUTFToString(this.data);
            StringTokenizer tokenizer = new StringTokenizer(array_string);
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            int[] return_me = new int[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                return_me[i] = Integer.parseInt((String)tokens.get(i));
            }
            return return_me;
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Array contains non-integer: " + this.toString());
        }
    }

    public float toFloat() {
        try {
            return UTFConverter.convertUTFToFloat(this.data);
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Not a float: " + this.toString());
        }
    }

    public float[] toFloatArray() {
        try {
            String array_string = UTFConverter.convertUTFToString(this.data);
            StringTokenizer tokenizer = new StringTokenizer(array_string);
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            float[] return_me = new float[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                return_me[i] = Float.parseFloat((String)tokens.get(i));
            }
            return return_me;
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Array contains non-float: " + this.toString());
        }
    }

    public double toDouble() {
        try {
            return UTFConverter.convertUTFToDouble(this.data);
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Not a double: " + this.toString());
        }
    }

    public double[] toDoubleArray() {
        try {
            String array_string = UTFConverter.convertUTFToString(this.data);
            StringTokenizer tokenizer = new StringTokenizer(array_string);
            ArrayList<String> tokens = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                tokens.add(tokenizer.nextToken());
            }
            double[] return_me = new double[tokens.size()];
            for (int i = 0; i < tokens.size(); ++i) {
                return_me[i] = Double.parseDouble((String)tokens.get(i));
            }
            return return_me;
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
        catch (NumberFormatException e) {
            throw new LeafCastException("Array contains non-double: " + this.toString());
        }
    }

    public boolean toBoolean() {
        try {
            return UTFConverter.convertUTFToBool(this.data);
        }
        catch (UTFDataFormatException e) {
            throw new LeafCastException(NOT_UTF8_ERROR);
        }
    }
}

