/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.CasCache;
import org.apache.uima.ruta.textruler.core.CasCacheLoader;
import org.apache.uima.ruta.textruler.core.GlobalCASSource;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocumentSet;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.preferences.TextRulerPreferences;
import org.apache.uima.util.FileUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class TextRulerBasicLearner
implements TextRulerLearner,
CasCacheLoader {
    protected TextRulerLearnerDelegate delegate;
    protected AnalysisEngine ae;
    protected TextRulerExampleDocumentSet exampleDocuments;
    protected String inputDirectory;
    protected String tempDirectory;
    protected String preprocessorFile;
    protected Set<String> filterSet;
    protected Set<String> filterSetWithSlotNames;
    protected String[] slotNames;
    protected CasCache casCache;
    protected CAS algTestCAS;
    private boolean skip;
    protected boolean useDynamicAnchoring = false;
    private boolean useDefaultFiltering;
    protected boolean supportBoundaries = false;
    private double maxErrorRate = 5.0;
    private Map<String, TextRulerStatisticsCollector> inducedRules = new TreeMap<String, TextRulerStatisticsCollector>();

    public TextRulerBasicLearner(String inputDir, String prePropTMFile, String tmpDir, String[] slotNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        this.preprocessorFile = prePropTMFile;
        this.tempDirectory = tmpDir;
        this.slotNames = slotNames;
        this.inputDirectory = inputDir;
        this.skip = skip;
        this.delegate = delegate;
        this.filterSet = filterSet;
        this.filterSetWithSlotNames = new HashSet<String>(filterSet);
        this.filterSetWithSlotNames.add("org.apache.uima.ruta.type.RutaBasic");
        for (String s : slotNames) {
            this.filterSetWithSlotNames.add(s);
            this.filterSetWithSlotNames.add(TextRulerTarget.getSingleSlotTypeName(TextRulerTarget.MLTargetType.SINGLE_LEFT_BOUNDARY, s));
            this.filterSetWithSlotNames.add(TextRulerTarget.getSingleSlotTypeName(TextRulerTarget.MLTargetType.SINGLE_RIGHT_BOUNDARY, s));
        }
        this.useDefaultFiltering = true;
        this.useDefaultFiltering &= filterSet.size() == 4;
        this.useDefaultFiltering &= filterSet.contains("org.apache.uima.ruta.type.SPACE");
        this.useDefaultFiltering &= filterSet.contains("org.apache.uima.ruta.type.BREAK");
        this.useDefaultFiltering &= filterSet.contains("org.apache.uima.ruta.type.NBSP");
        this.useDefaultFiltering &= filterSet.contains("org.apache.uima.ruta.type.MARKUP");
        IPreferenceStore store = TextRulerPlugin.getDefault().getPreferenceStore();
        this.maxErrorRate = store.getInt(TextRulerPreferences.MAX_ERROR_RATE);
        int casChacheSize = store.getInt(TextRulerPreferences.CAS_CACHE);
        this.casCache = new CasCache(casChacheSize, this);
    }

    protected String tempDirectory() {
        return TextRulerToolkit.addTrailingSlashToPath(this.tempDirectory);
    }

    protected boolean shouldAbort() {
        if (this.delegate != null) {
            return this.delegate.shouldAbort();
        }
        return false;
    }

    @Override
    public AnalysisEngine getAnalysisEngine() {
        if (this.ae == null) {
            this.updateAE();
        }
        return this.ae;
    }

    private void updateAE() {
        IPath analysisEngineDescriptorPath = null;
        try {
            analysisEngineDescriptorPath = RutaProjectUtils.getAnalysisEngineDescriptorPath((String)this.preprocessorFile);
        }
        catch (CoreException e1) {
            this.sendStatusUpdateToDelegate("Failed to locate descriptor.", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
        }
        String descriptorFile = analysisEngineDescriptorPath.toPortableString();
        this.sendStatusUpdateToDelegate("loading AE...", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
        AnalysisEngineDescription description = TextRulerToolkit.getAnalysisEngineDescription(descriptorFile);
        if (description == null) {
            this.sendStatusUpdateToDelegate("Failed to load descriptor. Please rebuild the project.", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
            return;
        }
        TextRulerToolkit.addBoundaryTypes(description, this.slotNames);
        this.ae = TextRulerToolkit.loadAnalysisEngine(description);
        String tempRulesFileName = this.getTempRulesFileName();
        Path path = new Path(tempRulesFileName);
        this.ae.setConfigParameterValue("mainScript", (Object)path.removeFileExtension().lastSegment());
        String portableString = path.removeLastSegments(1).toPortableString();
        this.ae.setConfigParameterValue("scriptPaths", (Object)new String[]{portableString});
        this.ae.setConfigParameterValue("additionalScripts", (Object)new String[0]);
        this.ae.setConfigParameterValue("reloadScript", (Object)true);
        if (this.useDynamicAnchoring) {
            this.ae.setConfigParameterValue("dynamicAnchoring", (Object)true);
        }
        IPreferenceStore store = TextRulerPlugin.getDefault().getPreferenceStore();
        boolean lowMemoryProfile = store.getBoolean(TextRulerPreferences.LOW_MEMORY_PROFILE);
        boolean removeBasics = store.getBoolean(TextRulerPreferences.REMOVE_BASICS);
        this.ae.setConfigParameterValue("lowMemoryProfile", (Object)lowMemoryProfile);
        this.ae.setConfigParameterValue("removeBasics", (Object)removeBasics);
        try {
            this.ae.reconfigure();
        }
        catch (ResourceConfigurationException e) {
            TextRulerPlugin.error(e);
        }
    }

    protected boolean checkForMandatoryTypes() {
        CAS someCas = this.getTestCAS();
        if (someCas == null) {
            return false;
        }
        TypeSystem ts = someCas.getTypeSystem();
        boolean result = true;
        ArrayList<String> missingTypes = new ArrayList<String>();
        for (String s : this.slotNames) {
            if (ts.getType(s) != null) continue;
            missingTypes.add(s);
            result = false;
        }
        Object missingString = "";
        for (String string : missingTypes) {
            missingString = (String)missingString + string + ", ";
        }
        if (!StringUtils.isEmpty((CharSequence)missingString)) {
            missingString = ((String)missingString).substring(0, ((String)missingString).length() - 2);
        }
        if (!result) {
            this.sendStatusUpdateToDelegate("Error: Some Slot- or Helper-Types were not found in TypeSystem: " + (String)missingString, TextRulerLearner.TextRulerLearnerState.ML_ERROR, false);
        }
        return result;
    }

    protected boolean createTempDirIfNeccessary() {
        File dir = new File(this.tempDirectory());
        if (dir.exists() && dir.isDirectory()) {
            return true;
        }
        return dir.mkdir();
    }

    @Override
    public void run() {
        if (this.createTempDirIfNeccessary()) {
            this.updateAE();
            if (this.ae == null) {
                return;
            }
            this.inducedRules.clear();
            if (this.checkForMandatoryTypes()) {
                this.sendStatusUpdateToDelegate("Finding documents...", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, false);
                this.exampleDocuments = new TextRulerExampleDocumentSet(this.inputDirectory, this.casCache);
                if (!this.shouldAbort()) {
                    this.sendStatusUpdateToDelegate("Starting...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
                    try {
                        this.doRun();
                    }
                    catch (Exception e) {
                        TextRulerPlugin.error(e);
                        this.sendStatusUpdateToDelegate("Aborted due to exception!", TextRulerLearner.TextRulerLearnerState.ML_ERROR, true);
                    }
                    this.cleanUp();
                }
            }
            this.casCache.clear();
            this.casCache = null;
            this.exampleDocuments = null;
            if (this.algTestCAS != null) {
                this.algTestCAS.reset();
                GlobalCASSource.releaseCAS(this.algTestCAS);
                this.algTestCAS = null;
            }
            if (this.shouldAbort()) {
                this.sendStatusUpdateToDelegate("Aborted!", TextRulerLearner.TextRulerLearnerState.ML_ABORTED, false);
            }
        } else {
            this.sendStatusUpdateToDelegate("ERROR CREATING TEMPORARY DIRECTORY!", TextRulerLearner.TextRulerLearnerState.ML_ERROR, false);
        }
    }

    @Override
    public CAS loadCAS(String fileName, CAS reuseCAS) {
        return TextRulerToolkit.readCASfromXMIFile(fileName, this.ae, reuseCAS);
    }

    protected void sendStatusUpdateToDelegate(String statusString, TextRulerLearner.TextRulerLearnerState state, boolean ruleBaseChanged) {
        if (this.delegate != null) {
            this.delegate.algorithmStatusUpdate(this, statusString, state, ruleBaseChanged);
        }
    }

    protected abstract void doRun();

    protected void cleanUp() {
    }

    public String getTempRulesFileName() {
        return this.tempDirectory() + "rules.ruta";
    }

    public String getIntermediateRulesFileName() {
        return this.tempDirectory() + "intermediaterules.ruta";
    }

    public void compareOriginalDocumentWithTestCAS(TextRulerExampleDocument originalDoc, CAS testCas, TextRulerTarget target, TextRulerStatisticsCollector c, boolean collectNegativeExamples) {
        List<TextRulerExample> originalPositives = originalDoc.getPositiveExamples();
        List<TextRulerExample> testPositives = originalDoc.createSlotInstancesForCAS(testCas, target, false);
        for (TextRulerExample e : testPositives) {
            TextRulerExample coveredExample = TextRulerToolkit.exampleListContainsAnnotation(originalPositives, e.getAnnotation());
            if (coveredExample != null) {
                c.addCoveredPositive(coveredExample);
                continue;
            }
            if (collectNegativeExamples) {
                e.setPositive(false);
                c.addCoveredNegative(e);
                continue;
            }
            c.incCoveredNegatives(1);
        }
    }

    public abstract boolean collectNegativeCoveredInstancesWhenTesting();

    public void testRuleOnDocument(TextRulerRule rule, TextRulerExampleDocument doc, TextRulerStatisticsCollector c) {
        CAS testCAS = this.getTestCAS();
        doc.resetAndFillTestCAS(testCAS, rule.getTarget());
        this.testRuleOnDocument(rule, doc, c, testCAS);
        testCAS.reset();
    }

    public void testRuleOnDocument(TextRulerRule rule, TextRulerExampleDocument doc, TextRulerStatisticsCollector c, CAS testCas) {
        try {
            rule.saveToRulesFile(this.getTempRulesFileName());
            this.ae.process(testCas);
            this.compareOriginalDocumentWithTestCAS(doc, testCas, rule.getTarget(), c, this.collectNegativeCoveredInstancesWhenTesting());
        }
        catch (Exception e) {
            TextRulerPlugin.error(e);
        }
    }

    public void testRuleOnDocumentSet(TextRulerRule rule, TextRulerExampleDocumentSet documents) {
        TextRulerExampleDocument[] sortedDocs;
        TextRulerStatisticsCollector sum = new TextRulerStatisticsCollector();
        for (TextRulerExampleDocument theDoc : sortedDocs = documents.getSortedDocumentsInCacheOptimizedOrder()) {
            this.testRuleOnDocument(rule, theDoc, sum);
            if (this.shouldAbort()) break;
        }
        rule.setCoveringStatistics(sum);
    }

    public CAS applyScriptOnDocument(String script, TextRulerExampleDocument doc, TextRulerTarget target) {
        String tempRulesFileName = this.getTempRulesFileName();
        try {
            FileUtils.saveString2File((String)script, (File)new File(tempRulesFileName));
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
        }
        AnalysisEngine analysisEngine = this.getAnalysisEngine();
        CAS testCAS = this.getTestCAS();
        doc.resetAndFillTestCAS(testCAS, target);
        try {
            analysisEngine.process(testCAS);
        }
        catch (AnalysisEngineProcessException e) {
            TextRulerPlugin.error(e);
        }
        return testCAS;
    }

    /*
     * WARNING - void declaration
     */
    public void testRulesOnDocumentSet(List<? extends TextRulerRule> rules, TextRulerExampleDocumentSet documents) {
        void var7_11;
        void var7_9;
        if (rules.isEmpty()) {
            return;
        }
        ArrayList<TextRulerStatisticsCollector> sums = new ArrayList<TextRulerStatisticsCollector>();
        TextRulerExampleDocument[] sortedDocs = documents.getSortedDocumentsInCacheOptimizedOrder();
        TextRulerTarget target = rules.get(0).getTarget();
        for (TextRulerRule textRulerRule : rules) {
            sums.add(new TextRulerStatisticsCollector());
        }
        CAS theTestCAS = this.getTestCAS();
        boolean bl = false;
        while (var7_9 < rules.size()) {
            TextRulerRule theRule = rules.get((int)var7_9);
            String ruleString = theRule.getRuleString();
            if (this.inducedRules.containsKey(ruleString)) {
                theRule.setCoveringStatistics(this.inducedRules.get(ruleString));
            } else {
                TextRulerStatisticsCollector sumC = (TextRulerStatisticsCollector)sums.get((int)var7_9);
                for (TextRulerExampleDocument theDoc : sortedDocs) {
                    theDoc.resetAndFillTestCAS(theTestCAS, target);
                    this.testRuleOnDocument(theRule, theDoc, sumC, theTestCAS);
                    double errorRate = sumC.n / Math.max(sumC.p, 1);
                    if (errorRate > this.maxErrorRate) break;
                    if (!this.shouldAbort()) continue;
                    return;
                }
                this.inducedRules.put(ruleString, sumC);
            }
            ++var7_9;
        }
        theTestCAS.reset();
        boolean bl2 = false;
        while (var7_11 < rules.size()) {
            rules.get((int)var7_11).setCoveringStatistics((TextRulerStatisticsCollector)sums.get((int)var7_11));
            ++var7_11;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testRulesOnDocument(List<? extends TextRulerRule> rules, TextRulerExampleDocument document) {
        void var6_10;
        void var6_8;
        if (rules.isEmpty()) {
            return;
        }
        ArrayList<TextRulerStatisticsCollector> sums = new ArrayList<TextRulerStatisticsCollector>();
        TextRulerTarget target = rules.get(0).getTarget();
        for (TextRulerRule textRulerRule : rules) {
            sums.add(new TextRulerStatisticsCollector());
        }
        CAS theTestCAS = this.getTestCAS();
        boolean bl = false;
        while (var6_8 < rules.size()) {
            TextRulerRule theRule = rules.get((int)var6_8);
            TextRulerStatisticsCollector sumC = (TextRulerStatisticsCollector)sums.get((int)var6_8);
            document.resetAndFillTestCAS(theTestCAS, target);
            this.testRuleOnDocument(theRule, document, sumC, theTestCAS);
            if (this.shouldAbort()) {
                return;
            }
            ++var6_8;
        }
        theTestCAS.reset();
        boolean bl2 = false;
        while (var6_10 < rules.size()) {
            rules.get((int)var6_10).setCoveringStatistics((TextRulerStatisticsCollector)sums.get((int)var6_10));
            ++var6_10;
        }
    }

    public String getFileHeaderString(boolean complete) {
        return this.getPackageString() + this.getScriptImport(complete) + this.getFilterCommandString() + this.getUseDynamicAnchoring(complete) + this.getBoundaryDeclarations(complete);
    }

    private String getBoundaryDeclarations(boolean complete) {
        if (complete && this.supportBoundaries && this.slotNames.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("DECLARE ");
            int count = 0;
            for (String slot : this.slotNames) {
                String[] split = slot.split("[.]");
                String shortName = split[split.length - 1];
                sb.append(shortName);
                sb.append("START");
                sb.append(", ");
                sb.append(shortName);
                sb.append("END");
                if (count < this.slotNames.length - 1) {
                    sb.append(", ");
                }
                ++count;
            }
            sb.append(";\n");
            return sb.toString();
        }
        return "";
    }

    private String getUseDynamicAnchoring(boolean complete) {
        if (this.useDynamicAnchoring && complete) {
            return "Document{-> DYNAMICANCHORING(true)};\n";
        }
        return "";
    }

    private String getScriptImport(boolean complete) {
        if (complete) {
            IPath path = Path.fromOSString((String)this.preprocessorFile);
            IPath removeLastSegments = path.removeLastSegments(1);
            IContainer containerForLocation = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(removeLastSegments);
            IProject project = containerForLocation.getProject();
            String scriptWithPackage = null;
            try {
                scriptWithPackage = RutaProjectUtils.getScriptWithPackage((IPath)path, (IProject)project);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            String moduleName = RutaProjectUtils.getModuleName((IPath)path);
            if (scriptWithPackage != null) {
                String importString = "SCRIPT " + scriptWithPackage + ";\n";
                if (!this.skip) {
                    importString = importString + "Document{-> CALL(" + moduleName + ")};\n";
                }
                return importString;
            }
        }
        return "";
    }

    public String getPackageString() {
        IPath path = Path.fromOSString((String)this.preprocessorFile);
        IPath removeLastSegments = path.removeLastSegments(1);
        IContainer containerForLocation = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(removeLastSegments);
        IPath removeFirstSegments = containerForLocation.getProjectRelativePath().removeFirstSegments(1);
        String replaceAll = removeFirstSegments.toPortableString().replaceAll("/", ".");
        return "PACKAGE " + replaceAll + ";\n\n";
    }

    public String getFilterCommandString() {
        if (this.filterSet != null && this.filterSet.size() > 0 && !this.isDefaultFiltering()) {
            Object fs = "";
            for (String s : this.filterSet) {
                if (((String)fs).length() == 0) {
                    fs = (String)fs + TextRulerToolkit.getTypeShortName(s);
                    continue;
                }
                fs = (String)fs + ", " + TextRulerToolkit.getTypeShortName(s);
            }
            return "Document{->FILTERTYPE(" + (String)fs + ")};\n\n";
        }
        return "";
    }

    private boolean isDefaultFiltering() {
        return this.useDefaultFiltering;
    }

    @Override
    public CAS getTestCAS() {
        if (this.algTestCAS == null) {
            try {
                this.algTestCAS = GlobalCASSource.allocCAS(this.ae);
            }
            catch (Exception e) {
                TextRulerPlugin.error(e);
                return null;
            }
        }
        return this.algTestCAS;
    }

    protected void saveParametersToTempFolder(Map<String, Object> params) {
        if (this.createTempDirIfNeccessary()) {
            Object str = "\nSettings:\n\n";
            str = (String)str + "inputDir: " + this.inputDirectory;
            str = (String)str + "\ntempDir: " + this.tempDirectory;
            str = (String)str + "\npreprocessTMFile: " + this.preprocessorFile;
            str = (String)str + "\n";
            for (Map.Entry<String, Object> e : params.entrySet()) {
                str = (String)str + e.getKey() + " = " + String.valueOf(e.getValue()) + "\n";
            }
            if (this.createTempDirIfNeccessary()) {
                TextRulerToolkit.appendStringToFile(this.tempDirectory() + "settings.txt", (String)str);
            }
        }
    }

    public Set<String> getFilterSet() {
        return this.filterSet;
    }
}

