/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.resource;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.rule.MatchContext;

public class LiteralWordTableExpression
extends WordTableExpression {
    private final String text;

    public LiteralWordTableExpression(String text) {
        if (text.startsWith("'") && text.endsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        this.text = LiteralWordTableExpression.stripEscapes(text);
    }

    public static String stripEscapes(String str) {
        String result = str.replaceAll("\\\\\\\\", "\\\\");
        return result.replaceAll("\\\\\\\"", "\\\"");
    }

    @Override
    public RutaTable getTable(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        RutaTable table = parent.getEnvironment().getWordTable(this.getText());
        return table;
    }

    public String getText() {
        return this.text;
    }
}

