/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.descriptor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.ruta.descriptor.RutaBuildOptions;
import org.apache.uima.ruta.descriptor.RutaDescriptorInformation;
import org.apache.uima.ruta.descriptor.StringTriple;
import org.apache.uima.ruta.resource.RutaResourceLoader;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.xml.sax.SAXException;

public class RutaDescriptorBuilder {
    private static ResourceSpecifierFactory uimaFactory = UIMAFramework.getResourceSpecifierFactory();
    private final URL defaultTypeSystem;
    private final URL defaultAnalysisEngine;

    public RutaDescriptorBuilder(URL defaultTypeSystem, URL defaultAnalysisEngine) {
        this.defaultTypeSystem = defaultTypeSystem;
        this.defaultAnalysisEngine = defaultAnalysisEngine;
    }

    public TypeSystemDescription createTypeSystemDescription(RutaDescriptorInformation desc, String typeSystemOutput, RutaBuildOptions options, String[] enginePaths) throws InvalidXMLException, ResourceInitializationException, IOException, URISyntaxException {
        URL url;
        Object resource;
        TypeSystemDescription typeSystemDescription = uimaFactory.createTypeSystemDescription();
        ResourceManager rm = UIMAFramework.newDefaultResourceManager();
        if (options.getClassLoader() != null) {
            rm = new ResourceManager_impl(options.getClassLoader());
        }
        if (enginePaths != null) {
            Object dataPath = "";
            for (String string : enginePaths) {
                dataPath = (String)dataPath + string + File.pathSeparator;
            }
            rm.setDataPath((String)dataPath);
        }
        HashMap<String, String> typeNameMap = new HashMap<String, String>();
        TypeSystemDescription initialTypeSystem = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(this.defaultTypeSystem));
        CAS cas = CasCreationUtils.createCas((TypeSystemDescription)initialTypeSystem, null, (FsIndexDescription[])new FsIndexDescription[0]);
        this.fillTypeNameMap(typeNameMap, cas.getTypeSystem());
        cas.release();
        ArrayList<TypeSystemDescription> toInclude = new ArrayList<TypeSystemDescription>();
        ArrayList<Import> importList = new ArrayList<Import>();
        Import_impl import_impl = new Import_impl();
        if (options.isImportByName()) {
            String name = initialTypeSystem.getName();
            import_impl.setName(name);
        } else if (options.isResolveImports()) {
            String absoluteLocation = initialTypeSystem.getSourceUrlString();
            import_impl.setLocation(absoluteLocation);
        } else {
            URI uri = null;
            try {
                uri = this.defaultTypeSystem.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uri != null) {
                String relativeLocation = this.getRelativeLocation(uri, typeSystemOutput);
                if (relativeLocation != null) {
                    import_impl.setLocation(relativeLocation);
                } else {
                    import_impl.setName(initialTypeSystem.getName());
                }
            } else {
                toInclude.add(initialTypeSystem);
            }
        }
        this.addImportIfValid(importList, import_impl);
        RutaResourceLoader descriptorRutaResourceLoader = new RutaResourceLoader(enginePaths, options.getClassLoader());
        for (String eachName : desc.getImportedTypeSystems()) {
            TypeSystemDescription each;
            resource = descriptorRutaResourceLoader.getResourceWithDotNotation(eachName, ".xml");
            url = null;
            boolean include = false;
            if (resource != null) {
                url = resource.getURL();
            }
            if (url == null) {
                url = RutaDescriptorBuilder.checkImportExistence(eachName, ".xml", options.getClassLoader());
                include = true;
                if (url == null) {
                    throw new FileNotFoundException("Build process can't find " + eachName + " in " + desc.getScriptName());
                }
            }
            if ((each = this.getTypeSystemDescriptor(url, rm)) != null) {
                this.fillTypeNameMap(typeNameMap, each);
                if (include) {
                    each.resolveImports(rm);
                    toInclude.add(each);
                    continue;
                }
                import_impl = new Import_impl();
                if (options.isImportByName()) {
                    import_impl.setName(eachName);
                } else if (options.isResolveImports()) {
                    String absoluteLocation = each.getSourceUrlString();
                    import_impl.setLocation(absoluteLocation);
                } else {
                    String relativeLocation = this.getRelativeLocation(url.toURI(), typeSystemOutput);
                    if (relativeLocation == null) {
                        import_impl.setName(eachName);
                    } else {
                        File parentFile = new File(typeSystemOutput).getParentFile();
                        File targetFile = new File(parentFile, relativeLocation);
                        if (!targetFile.exists()) {
                            import_impl.setName(eachName);
                        } else {
                            import_impl.setLocation(relativeLocation);
                        }
                    }
                }
                this.addImportIfValid(importList, import_impl);
                continue;
            }
            throw new FileNotFoundException("Build process can't find " + eachName + " in " + desc.getScriptName());
        }
        for (String eachName : desc.getImportedScripts()) {
            resource = descriptorRutaResourceLoader.getResourceWithDotNotation(eachName, options.getTypeSystemSuffix() + ".xml");
            url = null;
            if (resource != null) {
                url = resource.getURL();
            }
            if (url == null && (url = RutaDescriptorBuilder.checkImportExistence(eachName, options.getTypeSystemSuffix() + ".xml", options.getClassLoader())) == null) {
                throw new FileNotFoundException("Build process can't find " + eachName + options.getTypeSystemSuffix() + ".xml in " + desc.getScriptName());
            }
            TypeSystemDescription each = this.getTypeSystemDescriptor(url, rm);
            if (each != null) {
                this.fillTypeNameMap(typeNameMap, each);
                import_impl = new Import_impl();
                if (options.isImportByName()) {
                    import_impl.setName(eachName + options.getTypeSystemSuffix());
                } else if (options.isResolveImports()) {
                    String absoluteLocation = each.getSourceUrlString();
                    import_impl.setLocation(absoluteLocation);
                } else {
                    String relativeLocation = this.getRelativeLocation(url.toURI(), typeSystemOutput);
                    import_impl.setLocation(relativeLocation);
                }
                this.addImportIfValid(importList, import_impl);
                continue;
            }
            throw new FileNotFoundException("Build process can't find " + eachName + " in " + desc.getScriptName());
        }
        typeSystemDescription = CasCreationUtils.mergeTypeSystems(toInclude, (ResourceManager)rm);
        if (!importList.isEmpty()) {
            Import[] newImports = importList.toArray(new Import[0]);
            typeSystemDescription.setImports(newImports);
        }
        if (options.isResolveImports()) {
            typeSystemDescription.resolveImports(rm);
        }
        HashSet<String> finalTypes = new HashSet<String>();
        finalTypes.addAll(Arrays.asList("uima.cas.Boolean", "uima.cas.Byte", "uima.cas.Short", "uima.cas.Integer", "uima.cas.Long", "uima.cas.Float", "uima.cas.Double", "uima.cas.BooleanArray", "uima.cas.ByteArray", "uima.cas.ShortArray", "uima.cas.IntegerArray", "uima.cas.LongArray", "uima.cas.FloatArray", "uima.cas.DoubleArray", "uima.cas.StringArray", "uima.cas.FSArray"));
        int typeIndex = 0;
        for (String eachType : desc.getTypeShortNames()) {
            StringTriple typeTriple = desc.getTypeTriples().get(typeIndex);
            if (typeSystemDescription.getType((typeTriple = this.resolveType(typeTriple, typeNameMap, desc.getScriptName())).getName()) != null) continue;
            if (!finalTypes.contains(typeTriple.getParent())) {
                TypeDescription newType = typeSystemDescription.addType(typeTriple.getName(), typeTriple.getDescription(), typeTriple.getParent());
                Collection<StringTriple> collection = desc.getFeatures().get(eachType);
                if (collection != null) {
                    for (StringTriple eachFeature : collection) {
                        eachFeature = this.resolveFeature(eachFeature, typeNameMap);
                        newType.addFeature(eachFeature.getName(), eachFeature.getDescription(), eachFeature.getParent());
                    }
                }
            }
            ++typeIndex;
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<TypeDescription> types = new HashSet<TypeDescription>();
        for (TypeDescription each : typeSystemDescription.getTypes()) {
            String name = each.getName();
            if (names.contains(name)) continue;
            names.add(name);
            types.add(each);
        }
        TypeDescription[] presentTypes = typeSystemDescription.getTypes();
        types.addAll(Arrays.asList(presentTypes));
        typeSystemDescription.setTypes(types.toArray(new TypeDescription[0]));
        String descName = desc.getScriptName() + options.getTypeSystemSuffix();
        if (!StringUtils.isBlank((CharSequence)desc.getPackageString())) {
            descName = desc.getPackageString() + "." + descName;
        }
        typeSystemDescription.setName(descName);
        if (typeSystemOutput != null) {
            File typeSystemFile = this.getFile(typeSystemOutput);
            typeSystemDescription.setSourceUrl(typeSystemFile.toURI().toURL());
        }
        return typeSystemDescription;
    }

    private void addImportIfValid(List<Import> importList, Import_impl import_impl) {
        if (import_impl.getName() != null && import_impl.getLocation() != null) {
            throw new IllegalArgumentException("Trying to use name and location for import: " + import_impl.getName() + " <->" + import_impl.getLocation());
        }
        if (import_impl.getName() != null || import_impl.getLocation() != null) {
            importList.add((Import)import_impl);
        }
    }

    public AnalysisEngineDescription createAnalysisEngineDescription(RutaDescriptorInformation desc, TypeSystemDescription typeSystemDescription, String typeSystemOutput, String engineOutput, RutaBuildOptions options, String[] scriptPaths, String[] enginePaths, String[] resourcePaths) throws InvalidXMLException, IOException {
        TypeSystemDescription aets = uimaFactory.createTypeSystemDescription();
        Import_impl import_impl = null;
        boolean needToIncludeTypeSystemDescriptor = true;
        if (options.isImportByName()) {
            if (typeSystemDescription != null) {
                import_impl = new Import_impl();
                import_impl.setName(typeSystemDescription.getName());
                needToIncludeTypeSystemDescriptor = false;
            }
        } else if (typeSystemOutput != null) {
            String relativeLocation = this.getRelativeLocation(new File(typeSystemOutput).toURI(), engineOutput);
            import_impl = new Import_impl();
            import_impl.setLocation(relativeLocation);
            needToIncludeTypeSystemDescriptor = false;
        }
        AnalysisEngineDescription analysisEngineDescription = this.configureEngine(desc, engineOutput, options, scriptPaths, enginePaths, resourcePaths, import_impl, aets);
        if (needToIncludeTypeSystemDescriptor) {
            analysisEngineDescription.getAnalysisEngineMetaData().setTypeSystem(typeSystemDescription);
        }
        return analysisEngineDescription;
    }

    @Deprecated
    public void build(RutaDescriptorInformation desc, String typeSystemOutput, String engineOutput, RutaBuildOptions options, String[] scriptPaths, String[] enginePaths) throws SAXException, InvalidXMLException, IOException, ResourceInitializationException, URISyntaxException {
        this.build(desc, typeSystemOutput, engineOutput, options, scriptPaths, enginePaths, null);
    }

    public void build(RutaDescriptorInformation desc, String typeSystemOutput, String engineOutput, RutaBuildOptions options, String[] scriptPaths, String[] enginePaths, String[] resourcePaths) throws SAXException, InvalidXMLException, IOException, ResourceInitializationException, URISyntaxException {
        TypeSystemDescription typeSystemDescription = this.createTypeSystemDescription(desc, typeSystemOutput, options, enginePaths);
        AnalysisEngineDescription analysisEngineDescription = this.createAnalysisEngineDescription(desc, typeSystemDescription, typeSystemOutput, engineOutput, options, scriptPaths, enginePaths, resourcePaths);
        File analysisEngineFile = this.getFile(engineOutput);
        File typeSystemFile = this.getFile(typeSystemOutput);
        this.toFile((XMLizable)typeSystemDescription, typeSystemFile);
        this.toFile((XMLizable)analysisEngineDescription, analysisEngineFile);
    }

    private void fillTypeNameMap(Map<String, String> typeNameMap, TypeSystem typeSystem) {
        Iterator typeIterator = typeSystem.getTypeIterator();
        while (typeIterator.hasNext()) {
            Type type = (Type)typeIterator.next();
            String shortName = type.getShortName();
            String name = type.getName();
            typeNameMap.put(shortName, name);
        }
    }

    private boolean fillTypeNameMap(Map<String, String> typeNameMap, TypeSystemDescription desc) {
        boolean contained = false;
        for (TypeDescription each : desc.getTypes()) {
            String name = each.getName();
            int lastIndexOf = name.lastIndexOf(".");
            String shortName = name.substring(lastIndexOf + 1, name.length());
            typeNameMap.put(shortName, name);
        }
        return contained;
    }

    private StringTriple resolveFeature(StringTriple eachFeature, Map<String, String> types) {
        String parent = eachFeature.getParent();
        String name = eachFeature.getName();
        if ((parent = this.translate(parent)).indexOf(".") == -1 && types.containsKey(parent)) {
            parent = types.get(parent);
        }
        return new StringTriple(name, eachFeature.getDescription(), parent);
    }

    private StringTriple resolveType(StringTriple typeTriple, Map<String, String> types, String packageName) {
        String parent = typeTriple.getParent();
        String name = typeTriple.getName();
        if (parent == null) {
            parent = "uima.tcas.Annotation";
        }
        parent = this.translate(parent);
        name = this.translate(name);
        if (parent.indexOf(".") == -1 && types.containsKey(parent)) {
            parent = types.get(parent);
        }
        if (name.indexOf(".") == -1 && types.containsKey(name)) {
            name = types.get(name);
        }
        int lastIndexOf = name.lastIndexOf(".");
        String shortName = name.substring(lastIndexOf + 1, name.length());
        types.put(shortName, name);
        return new StringTriple(name, typeTriple.getDescription(), parent);
    }

    private String translate(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("Annotation")) {
            return "uima.tcas.Annotation";
        }
        if (name.equals("ANNOTATION")) {
            return "uima.tcas.Annotation";
        }
        if (name.equals("STRING")) {
            return "uima.cas.String";
        }
        if (name.equals("INT")) {
            return "uima.cas.Integer";
        }
        if (name.equals("DOUBLE")) {
            return "uima.cas.Double";
        }
        if (name.equals("FLOAT")) {
            return "uima.cas.Float";
        }
        if (name.equals("BOOLEAN")) {
            return "uima.cas.Boolean";
        }
        if (name.equals("TYPE")) {
            return "uima.cas.String";
        }
        return name;
    }

    private AnalysisEngineDescription configureEngine(RutaDescriptorInformation desc, String engineOutput, RutaBuildOptions option, String[] scriptPaths, String[] descriptorPaths, String[] resourcePaths, Import_impl import_impl, TypeSystemDescription aets) throws InvalidXMLException, IOException {
        AnalysisEngineDescription analysisEngineDescription = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(this.defaultAnalysisEngine));
        if (import_impl != null && (import_impl.getName() != null || import_impl.getLocation() != null)) {
            aets.setImports(new Import[]{import_impl});
        }
        analysisEngineDescription.getAnalysisEngineMetaData().setTypeSystem(aets);
        if (engineOutput != null) {
            File file = this.getFile(engineOutput);
            analysisEngineDescription.setSourceUrl(file.toURI().toURL());
        }
        String descName = desc.getScriptName() + option.getAnalysisEngineSuffix();
        if (!StringUtils.isBlank((CharSequence)desc.getPackageString())) {
            descName = desc.getPackageString() + "." + descName;
            analysisEngineDescription.getAnalysisEngineMetaData().setName(descName);
        }
        if (!desc.getTypeShortNames().isEmpty()) {
            Capability capability = uimaFactory.createCapability();
            for (StringTriple typeTriple : desc.getTypeTriples()) {
                capability.addInputType(typeTriple.getName(), false);
                capability.addOutputType(typeTriple.getName(), false);
            }
            Capability[] capabilities = analysisEngineDescription.getAnalysisEngineMetaData().getCapabilities();
            Capability[] newArray = new Capability[capabilities.length + 1];
            System.arraycopy(capabilities, 0, newArray, 0, capabilities.length);
            newArray[capabilities.length] = capability;
            analysisEngineDescription.getAnalysisEngineMetaData().setCapabilities(newArray);
        }
        if (desc.getRules() != null) {
            analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("rules", (Object)desc.getRules());
        } else {
            String mainScript = desc.getScriptName();
            if (!StringUtils.isBlank((CharSequence)desc.getPackageString())) {
                mainScript = desc.getPackageString().concat(".").concat(mainScript);
            }
            analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("mainScript", (Object)mainScript);
        }
        if (scriptPaths != null) {
            analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("scriptPaths", (Object)scriptPaths);
        }
        if (descriptorPaths != null) {
            analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("descriptorPaths", (Object)descriptorPaths);
        }
        String[] parameterValue = (String[])analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().getParameterValue("resourcePaths");
        HashSet<String> resourceLocations = new HashSet<String>();
        if (parameterValue != null && parameterValue.length != 0) {
            resourceLocations.addAll(Arrays.asList(parameterValue));
        }
        if (resourcePaths != null) {
            resourceLocations.addAll(Arrays.asList(resourcePaths));
        }
        analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("resourcePaths", (Object)resourceLocations.toArray(new String[0]));
        String[] additionalScriptsArray = desc.getImportedScripts().toArray(new String[0]);
        analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("additionalScripts", (Object)additionalScriptsArray);
        String[] additionalEnginesArray = desc.getImportedEngines().toArray(new String[0]);
        analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("additionalEngines", (Object)additionalEnginesArray);
        String[] additionalUimafitEnginesArray = desc.getImportedUimafitEngines().toArray(new String[0]);
        analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings().setParameterValue("additionalUimafitEngines", (Object)additionalUimafitEnginesArray);
        analysisEngineDescription.getAnalysisEngineMetaData().setTypeSystem(aets);
        this.configureExtensions(analysisEngineDescription, option);
        return analysisEngineDescription;
    }

    private String getRelativeLocation(URI target, String base) {
        if (base == null) {
            return null;
        }
        Path basePath = Paths.get(base, new String[0]);
        if (!basePath.toFile().isDirectory()) {
            basePath = basePath.getParent();
        }
        Path targetPath = null;
        try {
            targetPath = Paths.get(target);
        }
        catch (Exception e) {
            return null;
        }
        Path relativePath = null;
        try {
            relativePath = basePath.relativize(targetPath);
        }
        catch (Exception e) {
            return null;
        }
        String result = relativePath.toString().replaceAll("\\\\", "/");
        return result;
    }

    private void configureExtensions(AnalysisEngineDescription analysisEngineDescription, RutaBuildOptions options) {
        ConfigurationParameterSettings configurationParameterSettings = analysisEngineDescription.getAnalysisEngineMetaData().getConfigurationParameterSettings();
        List<String> languageExtensions = options.getLanguageExtensions();
        String[] extensions = (String[])configurationParameterSettings.getParameterValue("additionalExtensions");
        ArrayList<String> es = new ArrayList<String>();
        if (extensions != null) {
            es.addAll(Arrays.asList(extensions));
        }
        es.addAll(languageExtensions);
        configurationParameterSettings.setParameterValue("additionalExtensions", (Object)es.toArray(new String[0]));
    }

    private TypeSystemDescription getTypeSystemDescriptor(URL url, ResourceManager rm) throws InvalidXMLException, IOException {
        TypeSystemDescription tsdesc = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(url));
        tsdesc.resolveImports(rm);
        return tsdesc;
    }

    private File getFile(String location) {
        return new File(location);
    }

    private void toFile(XMLizable desc, File destination) throws SAXException, IOException {
        destination.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(destination);){
            desc.toXML((OutputStream)fos);
        }
    }

    public static URL checkImportExistence(String candidate, String extension, ClassLoader classloader) throws IOException {
        Object p = candidate.replaceAll("[.]", "/");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classloader);
        String prefix = "classpath*:";
        String pattern = prefix + (String)(p = (String)p + extension);
        Resource[] resources = resolver.getResources(pattern);
        if (resources == null || resources.length == 0) {
            return null;
        }
        Resource resource = resources[0];
        URL url = resource.getURL();
        return url;
    }
}

