# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
"""FFI API for namespace `testing`."""

# tvm-ffi-stubgen(begin): import-section
# fmt: off
# isort: off
from __future__ import annotations
from ..registry import init_ffi_api as _FFI_INIT_FUNC
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from collections.abc import Mapping, MutableMapping, MutableSequence, Sequence
    from tvm_ffi import Device, Object, Tensor, dtype
    from tvm_ffi.testing import TestIntPair
    from typing import Any, Callable
# isort: on
# fmt: on
# tvm-ffi-stubgen(end)

# tvm-ffi-stubgen(begin): global/testing@..registry
# fmt: off
_FFI_INIT_FUNC("testing", __name__)
if TYPE_CHECKING:
    def TestIntPairSum(_0: TestIntPair, /) -> int: ...
    def add_one(_0: int, /) -> int: ...
    def apply(*args: Any) -> Any: ...
    def echo(*args: Any) -> Any: ...
    def get_add_one_c_symbol() -> int: ...
    def get_mlir_add_one_c_symbol() -> int: ...
    def make_unregistered_object() -> Object: ...
    def nop(*args: Any) -> Any: ...
    def object_use_count(_0: Object, /) -> int: ...
    def optional_tensor_view_has_value(_0: Tensor | None, /) -> bool: ...
    def run_check_signal(_0: int, /) -> None: ...
    def schema_arr_map_opt(_0: Sequence[int | None], _1: Mapping[str, Sequence[int]], _2: str | None, /) -> Mapping[str, Sequence[int]]: ...
    def schema_id_any(_0: Any, /) -> Any: ...
    def schema_id_arr(_0: Sequence[Any], /) -> Sequence[Any]: ...
    def schema_id_arr_int(_0: Sequence[int], /) -> Sequence[int]: ...
    def schema_id_arr_obj(_0: Sequence[Object], /) -> Sequence[Object]: ...
    def schema_id_arr_str(_0: Sequence[str], /) -> Sequence[str]: ...
    def schema_id_bool(_0: bool, /) -> bool: ...
    def schema_id_bytes(_0: bytes, /) -> bytes: ...
    def schema_id_device(_0: Device, /) -> Device: ...
    def schema_id_dict_str_int(_0: MutableMapping[str, int], /) -> MutableMapping[str, int]: ...
    def schema_id_dict_str_str(_0: MutableMapping[str, str], /) -> MutableMapping[str, str]: ...
    def schema_id_dltensor(_0: Tensor, /) -> Tensor: ...
    def schema_id_dtype(_0: dtype, /) -> dtype: ...
    def schema_id_float(_0: float, /) -> float: ...
    def schema_id_func(_0: Callable[..., Any], /) -> Callable[..., Any]: ...
    def schema_id_func_typed(_0: Callable[[int, float, Callable[..., Any]], None], /) -> Callable[[int, float, Callable[..., Any]], None]: ...
    def schema_id_int(_0: int, /) -> int: ...
    def schema_id_list_int(_0: MutableSequence[int], /) -> MutableSequence[int]: ...
    def schema_id_list_obj(_0: MutableSequence[Object], /) -> MutableSequence[Object]: ...
    def schema_id_list_str(_0: MutableSequence[str], /) -> MutableSequence[str]: ...
    def schema_id_map(_0: Mapping[Any, Any], /) -> Mapping[Any, Any]: ...
    def schema_id_map_str_int(_0: Mapping[str, int], /) -> Mapping[str, int]: ...
    def schema_id_map_str_obj(_0: Mapping[str, Object], /) -> Mapping[str, Object]: ...
    def schema_id_map_str_str(_0: Mapping[str, str], /) -> Mapping[str, str]: ...
    def schema_id_object(_0: Object, /) -> Object: ...
    def schema_id_opt_int(_0: int | None, /) -> int | None: ...
    def schema_id_opt_obj(_0: Object | None, /) -> Object | None: ...
    def schema_id_opt_str(_0: str | None, /) -> str | None: ...
    def schema_id_string(_0: str, /) -> str: ...
    def schema_id_tensor(_0: Tensor, /) -> Tensor: ...
    def schema_id_variant_int_str(_0: int | str, /) -> int | str: ...
    def schema_no_args() -> int: ...
    def schema_no_args_no_return() -> None: ...
    def schema_no_return(_0: int, /) -> None: ...
    def schema_packed(*args: Any) -> Any: ...
    def schema_tensor_view_input(_0: Tensor, /) -> None: ...
    def schema_variant_mix(_0: int | str | Sequence[int], /) -> int | str | Sequence[int]: ...
    def test_raise_error(_0: str, _1: str, /) -> None: ...
# fmt: on
# tvm-ffi-stubgen(end)

__all__ = [
    # tvm-ffi-stubgen(begin): __all__
    "TestIntPairSum",
    "add_one",
    "apply",
    "echo",
    "get_add_one_c_symbol",
    "get_mlir_add_one_c_symbol",
    "make_unregistered_object",
    "nop",
    "object_use_count",
    "optional_tensor_view_has_value",
    "run_check_signal",
    "schema_arr_map_opt",
    "schema_id_any",
    "schema_id_arr",
    "schema_id_arr_int",
    "schema_id_arr_obj",
    "schema_id_arr_str",
    "schema_id_bool",
    "schema_id_bytes",
    "schema_id_device",
    "schema_id_dict_str_int",
    "schema_id_dict_str_str",
    "schema_id_dltensor",
    "schema_id_dtype",
    "schema_id_float",
    "schema_id_func",
    "schema_id_func_typed",
    "schema_id_int",
    "schema_id_list_int",
    "schema_id_list_obj",
    "schema_id_list_str",
    "schema_id_map",
    "schema_id_map_str_int",
    "schema_id_map_str_obj",
    "schema_id_map_str_str",
    "schema_id_object",
    "schema_id_opt_int",
    "schema_id_opt_obj",
    "schema_id_opt_str",
    "schema_id_string",
    "schema_id_tensor",
    "schema_id_variant_int_str",
    "schema_no_args",
    "schema_no_args_no_return",
    "schema_no_return",
    "schema_packed",
    "schema_tensor_view_input",
    "schema_variant_mix",
    "test_raise_error",
    # tvm-ffi-stubgen(end)
]
