/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPOutputStream;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.JSONRPCResult;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRPCServlet
extends HttpServlet {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(JSONRPCServlet.class);
    private static final int buf_size = 4096;
    private static int GZIP_THRESHOLD = 200;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String gzipThresh = config.getInitParameter("gzip_threshold");
        if (gzipThresh != null && gzipThresh.length() > 0) {
            try {
                GZIP_THRESHOLD = Integer.parseInt(gzipThresh);
            }
            catch (NumberFormatException n) {
                log.debug("could not parse " + gzipThresh + " as an integer... defaulting to -1 (gzip compression off)");
                GZIP_THRESHOLD = -1;
            }
        }
        log.debug("GZIP_THRESHOLD is " + GZIP_THRESHOLD);
        if (GZIP_THRESHOLD == -1) {
            log.debug("Gzipping is turned OFF.  No attempts will be made to gzip content from this servlet.");
        } else if (GZIP_THRESHOLD == 0) {
            log.debug("All responses will be Gzipped when gzipping results in a smaller response size.");
        } else {
            log.debug("Responses over this size will be Gzipped when gzipping results in a smaller response size.");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONRPCResult json_res;
        JSONRPCBridge json_bridge = this.findBridge(request);
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        String receiveString = (String)request.getAttribute("_jabsorb_beenHere");
        if (receiveString == null) {
            int ret;
            CharArrayWriter data = new CharArrayWriter();
            char[] buf = new char[4096];
            while ((ret = in.read(buf, 0, 4096)) != -1) {
                data.write(buf, 0, ret);
            }
            receiveString = data.toString();
            request.setAttribute("_jabsorb_beenHere", (Object)receiveString);
        } else {
            log.debug("jetty continuation resumed...");
        }
        if (log.isDebugEnabled()) {
            log.debug("receive: " + receiveString);
            log.debug("receive: " + this.prettyPrintJson(receiveString));
        }
        try {
            JSONObject json_req = new JSONObject(receiveString);
            json_res = json_bridge.call(new Object[]{request, response}, json_req);
        }
        catch (JSONException e) {
            log.error("can't parse call" + receiveString, (Throwable)e);
            json_res = new JSONRPCResult(590, null, "couldn't parse request arguments");
        }
        String sendString = json_res.toString();
        if (log.isDebugEnabled()) {
            log.debug("send: " + sendString);
            log.debug("send: " + this.prettyPrintJson(sendString));
        }
        byte[] bout = sendString.getBytes("UTF-8");
        if (GZIP_THRESHOLD != -1) {
            if (this.acceptsGzip(request)) {
                if (bout.length > GZIP_THRESHOLD) {
                    byte[] gzippedOut = this.gzip(bout);
                    log.debug("gzipping! original size =  " + bout.length + "  gzipped size = " + gzippedOut.length);
                    if (bout.length <= gzippedOut.length) {
                        log.warn("gzipping resulted in a larger output size!  aborting (sending non-gzipped response)... you may want to increase the gzip threshold if this happens a lot! original size = " + bout.length + "  gzipped size = " + gzippedOut.length);
                    } else {
                        bout = gzippedOut;
                        response.addHeader("Content-Encoding", "gzip");
                    }
                } else {
                    log.debug("not gzipping because size is " + bout.length + " (less than the GZIP_THRESHOLD of " + GZIP_THRESHOLD + " bytes)");
                }
            } else {
                log.debug("not gzipping because user agent doesn't accept gzip encoding...");
            }
        }
        response.setContentType("application/json;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        response.setIntHeader("Content-Length", bout.length);
        out.write(bout);
        out.flush();
        out.close();
    }

    protected JSONRPCBridge findBridge(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        JSONRPCBridge json_bridge = null;
        if (session != null) {
            json_bridge = (JSONRPCBridge)session.getAttribute("JSONRPCBridge");
        }
        if (json_bridge == null) {
            json_bridge = JSONRPCBridge.getGlobalBridge();
            if (log.isDebugEnabled()) {
                log.debug("Using global bridge.");
            }
        }
        return json_bridge;
    }

    private String prettyPrintJson(String unformattedJSON) {
        if (unformattedJSON == null || "".equals(unformattedJSON)) {
            return unformattedJSON;
        }
        try {
            return new JSONObject(unformattedJSON).toString(2);
        }
        catch (JSONException je) {
            return unformattedJSON;
        }
    }

    private boolean acceptsGzip(HttpServletRequest request) {
        String ae = request.getHeader("accept-encoding");
        return ae != null && ae.indexOf("gzip") != -1;
    }

    private byte[] gzip(byte[] in) {
        if (in != null && in.length > 0) {
            long tstart = System.currentTimeMillis();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                GZIPOutputStream gout = new GZIPOutputStream(bout);
                gout.write(in);
                gout.flush();
                gout.close();
                if (log.isDebugEnabled()) {
                    log.debug("gzipping took " + (System.currentTimeMillis() - tstart) + " msec");
                }
                return bout.toByteArray();
            }
            catch (IOException io) {
                log.error("io exception gzipping byte array", (Throwable)io);
            }
        }
        return new byte[0];
    }
}

