/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.MappingStrategy;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.UniqueColumnList;
import org.apache.turbine.services.schedule.BaseJobEntryTorquePeer;
import org.apache.turbine.services.schedule.JobEntryTorque;

public class BaseJobEntryTorqueRecordMapper
implements RecordMapper<JobEntryTorque> {
    private static final long serialVersionUID = 1750162102601L;
    private static Log log = LogFactory.getLog(BaseJobEntryTorqueRecordMapper.class);
    private static final String JOB_ID_EXPRESSION = BaseJobEntryTorquePeer.JOB_ID.getSqlExpression();
    private static final String SECOND_EXPRESSION = BaseJobEntryTorquePeer.SECOND.getSqlExpression();
    private static final String MINUTE_EXPRESSION = BaseJobEntryTorquePeer.MINUTE.getSqlExpression();
    private static final String HOUR_EXPRESSION = BaseJobEntryTorquePeer.HOUR.getSqlExpression();
    private static final String WEEK_DAY_EXPRESSION = BaseJobEntryTorquePeer.WEEK_DAY.getSqlExpression();
    private static final String DAY_OF_MONTH_EXPRESSION = BaseJobEntryTorquePeer.DAY_OF_MONTH.getSqlExpression();
    private static final String TASK_EXPRESSION = BaseJobEntryTorquePeer.TASK.getSqlExpression();
    private static final String EMAIL_EXPRESSION = BaseJobEntryTorquePeer.EMAIL.getSqlExpression();
    private static final String PROPERTY_EXPRESSION = BaseJobEntryTorquePeer.PROPERTY.getSqlExpression();
    private boolean useMappingStrategy = true;
    private MappingStrategy<JobEntryTorque> strategy;

    public void initStrategy() {
        this.strategy = new MappingStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobEntryTorque processRow(ResultSet resultSet, int offset, Criteria criteria) throws TorqueException {
        JobEntryTorque jobEntryTorque = new JobEntryTorque();
        try {
            jobEntryTorque.setLoading(true);
            if (criteria == null) {
                jobEntryTorque.setJobId(this.getJobId(resultSet, offset + 1));
                jobEntryTorque.setSecond(this.getSecond(resultSet, offset + 2));
                jobEntryTorque.setMinute(this.getMinute(resultSet, offset + 3));
                jobEntryTorque.setHour(this.getHour(resultSet, offset + 4));
                jobEntryTorque.setWeekDay(this.getWeekDay(resultSet, offset + 5));
                jobEntryTorque.setDayOfMonth(this.getDayOfMonth(resultSet, offset + 6));
                jobEntryTorque.setTask(this.getTask(resultSet, offset + 7));
                jobEntryTorque.setEmail(this.getEmail(resultSet, offset + 8));
                jobEntryTorque.setProperty(this.getProperty(resultSet, offset + 9));
            } else {
                if (this.useMappingStrategy) {
                    this.initStrategy();
                }
                int totalOffset = offset + 1;
                UniqueColumnList selectColumns = criteria.getSelectColumns();
                List columnsWithoutOffset = selectColumns.subList(offset, selectColumns.size());
                HashSet<String> columnsMapped = new HashSet<String>();
                for (Column column : columnsWithoutOffset) {
                    int nextOffset = totalOffset;
                    if (!columnsMapped.contains(JOB_ID_EXPRESSION) && JOB_ID_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setJobId(this.getJobId((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setJobId(this.getJobId(resultSet, totalOffset));
                        }
                        columnsMapped.add(JOB_ID_EXPRESSION);
                    } else if (!columnsMapped.contains(SECOND_EXPRESSION) && SECOND_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setSecond(this.getSecond((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setSecond(this.getSecond(resultSet, totalOffset));
                        }
                        columnsMapped.add(SECOND_EXPRESSION);
                    } else if (!columnsMapped.contains(MINUTE_EXPRESSION) && MINUTE_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setMinute(this.getMinute((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setMinute(this.getMinute(resultSet, totalOffset));
                        }
                        columnsMapped.add(MINUTE_EXPRESSION);
                    } else if (!columnsMapped.contains(HOUR_EXPRESSION) && HOUR_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setHour(this.getHour((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setHour(this.getHour(resultSet, totalOffset));
                        }
                        columnsMapped.add(HOUR_EXPRESSION);
                    } else if (!columnsMapped.contains(WEEK_DAY_EXPRESSION) && WEEK_DAY_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setWeekDay(this.getWeekDay((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setWeekDay(this.getWeekDay(resultSet, totalOffset));
                        }
                        columnsMapped.add(WEEK_DAY_EXPRESSION);
                    } else if (!columnsMapped.contains(DAY_OF_MONTH_EXPRESSION) && DAY_OF_MONTH_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setDayOfMonth(this.getDayOfMonth((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setDayOfMonth(this.getDayOfMonth(resultSet, totalOffset));
                        }
                        columnsMapped.add(DAY_OF_MONTH_EXPRESSION);
                    } else if (!columnsMapped.contains(TASK_EXPRESSION) && TASK_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setTask(this.getTask((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setTask(this.getTask(resultSet, totalOffset));
                        }
                        columnsMapped.add(TASK_EXPRESSION);
                    } else if (!columnsMapped.contains(EMAIL_EXPRESSION) && EMAIL_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setEmail(this.getEmail((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setEmail(this.getEmail(resultSet, totalOffset));
                        }
                        columnsMapped.add(EMAIL_EXPRESSION);
                    } else if (!columnsMapped.contains(PROPERTY_EXPRESSION) && PROPERTY_EXPRESSION.equals(column.getSqlExpression())) {
                        if (this.useMappingStrategy) {
                            this.strategy.addColumn(nextOffset, (res, inst) -> inst.setProperty(this.getProperty((ResultSet)res, nextOffset)));
                        } else {
                            jobEntryTorque.setProperty(this.getProperty(resultSet, totalOffset));
                        }
                        columnsMapped.add(PROPERTY_EXPRESSION);
                    }
                    ++totalOffset;
                }
                if (columnsMapped.isEmpty()) {
                    log.debug((Object)"no columns to map found in criteria, returning null");
                    Iterator iterator = null;
                    return iterator;
                }
                if (this.useMappingStrategy) {
                    this.strategy.finish(9, true);
                    this.strategy.execute(resultSet, (Object)jobEntryTorque);
                }
            }
            jobEntryTorque.setNew(false);
            jobEntryTorque.setModified(false);
        }
        finally {
            jobEntryTorque.setLoading(false);
        }
        return jobEntryTorque;
    }

    protected int getJobId(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected int getSecond(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected int getMinute(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected int getHour(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected int getWeekDay(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected int getDayOfMonth(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getInt(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getTask(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected String getEmail(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    protected byte[] getProperty(ResultSet resultSet, int columnIndex) throws TorqueException {
        try {
            byte[] value = resultSet.getBytes(columnIndex);
            if (resultSet.wasNull()) {
                value = null;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

