/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils.springframework.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import nl.basjes.parse.useragent.utils.springframework.core.io.ClassPathResource;
import nl.basjes.parse.useragent.utils.springframework.core.io.FileUrlResource;
import nl.basjes.parse.useragent.utils.springframework.core.io.ProtocolResolver;
import nl.basjes.parse.useragent.utils.springframework.core.io.Resource;
import nl.basjes.parse.useragent.utils.springframework.core.io.ResourceLoader;
import nl.basjes.parse.useragent.utils.springframework.core.io.UrlResource;
import nl.basjes.parse.useragent.utils.springframework.util.Assert;
import nl.basjes.parse.useragent.utils.springframework.util.ClassUtils;
import nl.basjes.parse.useragent.utils.springframework.util.ResourceUtils;
import nl.basjes.parse.useragent.utils.springframework.util.StringUtils;

public class DefaultResourceLoader
implements ResourceLoader {
    @Nullable
    private ClassLoader classLoader;
    private final Set<ProtocolResolver> protocolResolvers = new LinkedHashSet<ProtocolResolver>(4);

    public DefaultResourceLoader() {
    }

    public DefaultResourceLoader(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : ClassUtils.getDefaultClassLoader();
    }

    public Collection<ProtocolResolver> getProtocolResolvers() {
        return this.protocolResolvers;
    }

    @Override
    public Resource getResource(String location) {
        Assert.notNull(location, "Location must not be null");
        for (ProtocolResolver protocolResolver : this.getProtocolResolvers()) {
            Resource resource = protocolResolver.resolve(location, this);
            if (resource == null) continue;
            return resource;
        }
        if (location.startsWith("/")) {
            return this.getResourceByPath(location);
        }
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL url = new URL(location);
            return ResourceUtils.isFileURL(url) ? new FileUrlResource(url) : new UrlResource(url);
        }
        catch (MalformedURLException ex) {
            return this.getResourceByPath(location);
        }
    }

    protected Resource getResourceByPath(String path) {
        return new ClassPathContextResource(path, this.getClassLoader());
    }

    protected static class ClassPathContextResource
    extends ClassPathResource
    implements Resource {
        public ClassPathContextResource(String path, @Nullable ClassLoader classLoader) {
            super(path, classLoader);
        }

        @Override
        public Resource createRelative(String relativePath) {
            String pathToUse = StringUtils.applyRelativePath(this.getPath(), relativePath);
            return new ClassPathContextResource(pathToUse, this.getClassLoader());
        }
    }
}

