/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.services.BaseService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.Service;
import org.apache.turbine.services.ServiceBroker;
import org.apache.turbine.services.TurbineServiceProvider;

public abstract class BaseServiceBroker
implements ServiceBroker {
    private final Map<String, Class<?>> mapping = new LinkedHashMap();
    private final ConcurrentHashMap<String, Service> services = new ConcurrentHashMap();
    private final ReentrantLock serviceLock = new ReentrantLock();
    private Configuration configuration;
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    private final ConcurrentHashMap<String, Object> serviceObjects = new ConcurrentHashMap();
    private static final Logger log = LogManager.getLogger(BaseServiceBroker.class);
    private String applicationRoot;
    private final ConcurrentHashMap<String, Service> serviceProviderInstanceMap = new ConcurrentHashMap();

    protected BaseServiceBroker() {
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init() throws InitializationException {
        this.initMapping();
        this.initServices(false);
    }

    public void setServiceObject(String name, Object value) {
        this.serviceObjects.put(name, value);
    }

    public Object getServiceObject(String name) {
        return this.serviceObjects.get(name);
    }

    private boolean checkForInterface(Class<?> checkIfc, Class<?>[] interfaces) {
        for (Class<?> ifc : interfaces) {
            if (ifc == checkIfc) {
                return true;
            }
            Class<?>[] subInterfaces = ifc.getInterfaces();
            if (!this.checkForInterface(checkIfc, subInterfaces)) continue;
            return true;
        }
        return false;
    }

    protected void initMapping() throws InitializationException {
        LinkedHashMap<CallSite, String> earlyInitFlags = new LinkedHashMap<CallSite, String>();
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !(keyParts[0] + ".").equals(SERVICE_PREFIX) || !("." + keyParts[2]).equals(CLASSNAME_SUFFIX)) continue;
            String serviceKey = keyParts[1];
            log.info("Added Mapping for Service: {}", (Object)serviceKey);
            if (this.mapping.containsKey(serviceKey)) continue;
            String className = this.configuration.getString(key);
            try {
                Class<?> clazz = Class.forName(className);
                this.mapping.put(serviceKey, clazz);
                if (!this.checkForInterface(TurbineServiceProvider.class, clazz.getInterfaces())) continue;
                log.info("Found a TurbineServiceProvider: {} - initializing it early", (Object)serviceKey);
                earlyInitFlags.put((CallSite)((Object)(SERVICE_PREFIX + serviceKey + ".earlyInit")), "true");
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (OutOfMemoryError t) {
                throw t;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new InitializationException("Class " + className + " is unavailable. Check your jars and classes.", e);
            }
        }
        for (Map.Entry entry : earlyInitFlags.entrySet()) {
            this.configuration.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean isRegistered(String serviceName) {
        return this.services.get(serviceName) != null;
    }

    public Iterator<String> getServiceNames() {
        return Collections.unmodifiableSet(this.mapping.keySet()).iterator();
    }

    public Iterator<String> getServiceNames(String prefix) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>(this.mapping.keySet());
        keys.removeIf(key -> !key.startsWith(prefix));
        return Collections.unmodifiableSet(keys).iterator();
    }

    @Override
    public void initService(String name) throws InitializationException {
        Service instance = this.getServiceInstance(name);
        this.serviceLock.lock();
        try {
            if (!instance.getInit()) {
                instance.init();
            }
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    public void initServices() {
        try {
            this.initServices(false);
        }
        catch (InitializationException | InstantiationException notThrown) {
            log.debug("Caught non fatal exception", (Throwable)notThrown);
        }
    }

    public void initServices(boolean report) throws InstantiationException, InitializationException {
        if (report) {
            Iterator<String> names = this.getServiceNames();
            while (names.hasNext()) {
                this.doInitService(names.next());
            }
        } else {
            Iterator<String> names = this.getServiceNames();
            while (names.hasNext()) {
                try {
                    this.doInitService(names.next());
                }
                catch (InitializationException | InstantiationException e) {
                    log.error((Object)e);
                }
            }
        }
        log.info("Finished initializing all services!");
    }

    private void doInitService(String name) throws InstantiationException, InitializationException {
        if (this.getConfiguration(name).getBoolean("earlyInit", false)) {
            log.info("Start Initializing service (early): {}", (Object)name);
            this.initService(name);
            log.info("Finish Initializing service (early): {}", (Object)name);
        }
    }

    @Override
    public void shutdownService(String name) {
        block6: {
            try {
                Service service = this.getServiceInstance(name);
                if (service == null || !service.getInit()) break block6;
                this.serviceLock.lock();
                try {
                    service.shutdown();
                    if (service.getInit() && service instanceof BaseService) {
                        ((BaseService)service).setInit(false);
                    }
                }
                finally {
                    this.serviceLock.unlock();
                }
            }
            catch (InstantiationException e) {
                log.error("Shutdown of a nonexistent Service '" + name + "' was requested", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdownServices() {
        log.info("Shutting down all services!");
        String serviceName = null;
        ArrayList<String> reverseServicesList = new ArrayList<String>();
        Iterator<String> serviceNames = this.getServiceNames();
        while (serviceNames.hasNext()) {
            serviceName = serviceNames.next();
            reverseServicesList.add(0, serviceName);
        }
        Iterator iterator = reverseServicesList.iterator();
        while (iterator.hasNext()) {
            String s;
            serviceName = s = (String)iterator.next();
            log.info("Shutting down service: {}", (Object)serviceName);
            this.shutdownService(serviceName);
        }
    }

    @Override
    public Object getService(String name) throws InstantiationException {
        if (this.isLocalService(name)) {
            try {
                Service service = this.getServiceInstance(name);
                if (!service.getInit()) {
                    this.serviceLock.lock();
                    try {
                        if (!service.getInit()) {
                            log.info("Start Initializing service (late): {}", (Object)name);
                            service.init();
                            log.info("Finish Initializing service (late): {}", (Object)name);
                        }
                    }
                    finally {
                        this.serviceLock.unlock();
                    }
                }
                if (!service.getInit()) {
                    throw new InitializationException("init() failed to initialize service " + name);
                }
                return service;
            }
            catch (InitializationException e) {
                throw new InstantiationException("Service " + name + " failed to initialize", e);
            }
        }
        if (this.isNonLocalService(name)) {
            return this.getNonLocalService(name);
        }
        throw new InstantiationException("ServiceBroker: unknown service " + name + " requested");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Service getServiceInstance(String name) throws InstantiationException {
        Service service;
        block13: {
            service = this.services.get(name);
            if (service == null) {
                this.serviceLock.lock();
                try {
                    service = this.services.get(name);
                    if (service != null) break block13;
                    if (!this.isLocalService(name)) {
                        throw new InstantiationException("ServiceBroker: unknown service " + name + " requested");
                    }
                    try {
                        Class<?> clazz = this.mapping.get(name);
                        try {
                            Service _service;
                            service = (Service)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (service instanceof TurbineServiceProvider && (_service = this.serviceProviderInstanceMap.putIfAbsent(name, service)) != null) {
                                service = _service;
                            }
                        }
                        catch (ClassCastException e) {
                            throw new InstantiationException("Class " + clazz + " doesn't implement the Service interface", e);
                        }
                        catch (OutOfMemoryError | ThreadDeath t) {
                            throw t;
                        }
                        catch (Throwable t) {
                            throw new InstantiationException("Failed to instantiate " + clazz, t);
                        }
                    }
                    catch (InstantiationException e) {
                        throw new InstantiationException("Failed to instantiate service " + name, e);
                    }
                    service.setServiceBroker(this);
                    service.setName(name);
                    Service _service = this.services.putIfAbsent(name, service);
                    if (_service != null) {
                        service = _service;
                    }
                }
                finally {
                    this.serviceLock.unlock();
                }
            }
        }
        return service;
    }

    @Override
    public Configuration getConfiguration(String name) {
        return this.configuration.subset(SERVICE_PREFIX + name);
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    @Override
    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    protected boolean isLocalService(String name) {
        return this.mapping.containsKey(name);
    }

    protected boolean isNonLocalService(String name) {
        TurbineServiceProvider turbineServiceProvider = null;
        for (Map.Entry<String, Service> entry : this.serviceProviderInstanceMap.entrySet()) {
            turbineServiceProvider = (TurbineServiceProvider)this.getService(entry.getKey());
            if (!turbineServiceProvider.exists(name)) continue;
            return true;
        }
        return false;
    }

    protected Object getNonLocalService(String name) throws InstantiationException {
        TurbineServiceProvider turbineServiceProvider = null;
        for (Map.Entry<String, Service> entry : this.serviceProviderInstanceMap.entrySet()) {
            turbineServiceProvider = (TurbineServiceProvider)this.getService(entry.getKey());
            if (!turbineServiceProvider.exists(name)) continue;
            return turbineServiceProvider.get(name);
        }
        throw new InstantiationException("ServiceBroker: unknown non-local service " + name + " requested");
    }
}

