/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.ValidationException;

public class DateStringValidator
extends DefaultValidator<Date> {
    private static final String DEFAULT_DATE_MESSAGE = "Date could not be parsed";
    private List<String> dateFormats = new ArrayList<String>(5);
    private String dateFormatMessage = null;
    private boolean flexible = false;

    @Override
    public void init(Map<String, ? extends Constraint> paramMap) throws InvalidMaskException {
        super.init(paramMap);
        Constraint constraint = paramMap.get("format");
        if (constraint != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
        }
        int i = 1;
        while ((constraint = paramMap.get("format" + i)) != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
            ++i;
        }
        if (StringUtils.isEmpty((CharSequence)this.dateFormatMessage)) {
            this.dateFormatMessage = DEFAULT_DATE_MESSAGE;
        }
        if ((constraint = paramMap.get("flexible")) != null) {
            this.flexible = Boolean.valueOf(constraint.getValue());
        }
    }

    @Override
    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((CharSequence)testValue)) {
            try {
                this.parse(testValue);
            }
            catch (ParseException e) {
                this.errorMessage = this.dateFormatMessage;
                throw new ValidationException(this.dateFormatMessage);
            }
        }
    }

    public Date parse(String s) throws ParseException {
        Date date = null;
        if (s == null) {
            throw new ParseException("Input string was null", -1);
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setLenient(this.flexible);
        for (int i = 1; i < this.dateFormats.size() && date == null; ++i) {
            sdf.applyPattern(this.dateFormats.get(i));
            try {
                date = sdf.parse(s);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            sdf.applyPattern(this.dateFormats.get(0));
            try {
                date = sdf.parse(s);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            date = SimpleDateFormat.getInstance().parse(s);
        }
        if (date == null) {
            throw new ParseException("Could not parse the date", 0);
        }
        return date;
    }

    public String format(Date date) {
        String s = null;
        if (date != null && !this.dateFormats.isEmpty()) {
            SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormats.get(0));
            s = sdf.format(date);
        }
        return s;
    }

    public String getDateFormatMessage() {
        return this.dateFormatMessage;
    }

    public void setDateFormatMessage(String message) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.dateFormatMessage = message;
        }
    }

    public List<String> getDateFormats() {
        return this.dateFormats;
    }

    public void setDateFormats(List<String> formats) {
        this.dateFormats = formats;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void setFlexible(boolean flexible) {
        this.flexible = flexible;
    }
}

