/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.localization.LocaleTokenizer;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.fulcrum.localization.SimpleLocalizationServiceImpl;

public class DefaultLocalizationService
extends SimpleLocalizationServiceImpl
implements LocalizationService {
    @Override
    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    @Override
    public ResourceBundle getBundle(HttpServletRequest req) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(req));
    }

    @Override
    public ResourceBundle getBundle(String bundleName, HttpServletRequest req) {
        return this.getBundle(bundleName, this.getLocale(req));
    }

    @Override
    public Locale getLocale(HttpServletRequest req) {
        return this.getLocale(req.getHeader("Accept-Language"));
    }

    @Override
    public Locale getLocale(String header) {
        LocaleTokenizer tok;
        if (StringUtils.isNotEmpty((CharSequence)header) && (tok = new LocaleTokenizer(header)).hasNext()) {
            return (Locale)tok.next();
        }
        return this.getDefaultLocale();
    }
}

