/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.util.HashMap;
import java.util.Map;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IdGenerator;

public class Database {
    private final String name;
    private Adapter adapter;
    private DatabaseMap databaseMap;
    private DataSourceFactory dataSourceFactory;
    private String schema = null;
    private TableMap idTable = null;
    private IDBroker idBroker = null;
    private final Map<IDMethod, IdGenerator> idGenerators = new HashMap<IDMethod, IdGenerator>();

    Database(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(Adapter anAdapter) {
        this.adapter = anAdapter;
    }

    public synchronized DatabaseMap getDatabaseMap() {
        if (this.databaseMap == null) {
            this.databaseMap = new DatabaseMap(this);
        }
        return this.databaseMap;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory aDataSourceFactory) {
        this.dataSourceFactory = aDataSourceFactory;
    }

    public TableMap getIdTable() {
        return this.idTable;
    }

    public void setIdTable(TableMap idTable) {
        this.idTable = idTable;
        this.getDatabaseMap().setIdTable(idTable);
    }

    public void setIdTable(String tableName) {
        TableMap tmap = new TableMap(tableName, this.getDatabaseMap());
        this.setIdTable(tmap);
    }

    public IDBroker getIdBroker() {
        return this.idBroker;
    }

    @Deprecated
    public synchronized boolean startIdBroker() {
        return this.createAndRegisterIdBroker();
    }

    public synchronized boolean createAndRegisterIdBroker() {
        if (this.idBroker != null) {
            return false;
        }
        this.setIdTable("ID_TABLE");
        TableMap tMap = this.getIdTable();
        ColumnMap idTableId = new ColumnMap("QUANTITY", tMap);
        idTableId.setType(0);
        idTableId.setPrimaryKey(true);
        tMap.addColumn(idTableId);
        ColumnMap tableName = new ColumnMap("TABLE_NAME", tMap);
        tableName.setType("");
        tMap.addColumn(tableName);
        ColumnMap nextId = new ColumnMap("NEXT_ID", tMap);
        nextId.setType(0);
        tMap.addColumn(nextId);
        ColumnMap quantity = new ColumnMap("QUANTITY", tMap);
        quantity.setType(0);
        tMap.addColumn(quantity);
        this.idBroker = new IDBroker(this);
        this.addIdGenerator(IDMethod.ID_BROKER, this.idBroker);
        return true;
    }

    public IdGenerator getIdGenerator(IDMethod type) {
        return this.idGenerators.get((Object)type);
    }

    public void addIdGenerator(IDMethod type, IdGenerator idGen) {
        this.idGenerators.put(type, idGen);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

