/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.uadetector.OperatingSystem;
import net.sf.uadetector.ReadableUserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.VersionNumber;
import net.sf.uadetector.service.UADetectorServiceFactory;
import org.apache.turbine.util.RunData;

public class BrowserDetector {
    private String userAgentString = "";
    private static volatile Map<String, ReadableUserAgent> userAgentCache = new HashMap<String, ReadableUserAgent>();
    private static UserAgentStringParser parser = UADetectorServiceFactory.getCachingAndUpdatingParser();
    private String browserName = "";
    private float browserVersion = 1.0f;
    private String browserPlatform = "unknown";

    public BrowserDetector(String userAgentString) {
        this.userAgentString = userAgentString;
        this.parse();
    }

    public BrowserDetector(RunData data) {
        this(data.getUserAgent());
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getBrowserPlatform() {
        return this.browserPlatform;
    }

    public float getBrowserVersion() {
        return this.browserVersion;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public ReadableUserAgent getUserAgent() {
        return userAgentCache.get(this.userAgentString);
    }

    private void parse() {
        ReadableUserAgent userAgent = userAgentCache.get(this.userAgentString);
        if (userAgent == null) {
            userAgent = parser.parse(this.userAgentString);
            userAgentCache.put(this.userAgentString, userAgent);
        }
        this.browserName = userAgent.getName();
        VersionNumber version = userAgent.getVersionNumber();
        this.browserVersion = BrowserDetector.toFloat(version.toVersionString());
        OperatingSystem os = userAgent.getOperatingSystem();
        this.browserPlatform = os.getFamilyName();
    }

    private static final float toFloat(String s) {
        return Float.parseFloat(s);
    }
}

