/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.authenticator.Authenticator;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractUserManager
extends AbstractEntityManager
implements UserManager {
    private static final long serialVersionUID = 1L;
    private ACLFactory aclFactory;
    private Authenticator authenticator;

    protected abstract <T extends User> T persistNewUser(T var1) throws DataBackendException;

    @Override
    public <T extends AccessControlList> T getACL(User user) throws UnknownEntityException {
        return this.getACLFactory().getAccessControlList(user);
    }

    @Override
    public boolean checkExists(User user) throws DataBackendException {
        return this.checkExists(user.getName());
    }

    @Override
    public <T extends User> T getUser(String userName, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        T user = this.getUser(userName);
        this.authenticate((User)user, password);
        return user;
    }

    @Override
    public <T extends User> T getUser(String name) throws DataBackendException, UnknownEntityException {
        User user = (User)this.getAllUsers().getByName(name);
        if (user == null) {
            throw new UnknownEntityException("The specified user does not exist");
        }
        return (T)user;
    }

    @Override
    public <T extends User> T getUserById(Object id) throws DataBackendException, UnknownEntityException {
        User user = (User)this.getAllUsers().getById(id);
        if (user == null) {
            throw new UnknownEntityException("The specified user does not exist");
        }
        return (T)user;
    }

    @Override
    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (this.authenticator == null) {
            this.authenticator = (Authenticator)this.resolve(Authenticator.ROLE);
        }
        if (!this.authenticator.authenticate(user, password)) {
            throw new PasswordMismatchException("Can not authenticate user.");
        }
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        if (!this.checkExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        if (!oldPassword.equals(user.getPassword())) {
            throw new PasswordMismatchException("The supplied old password for '" + user.getName() + "' was incorrect");
        }
        user.setPassword(newPassword);
        this.saveUser(user);
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        if (!this.checkExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        user.setPassword(password);
        this.saveUser(user);
    }

    @Override
    public <T extends User> T getUserInstance() throws DataBackendException {
        try {
            User user = (User)Class.forName(this.getClassName()).newInstance();
            return (T)user;
        }
        catch (Exception e) {
            throw new DataBackendException("Problem creating instance of class " + this.getClassName(), e);
        }
    }

    @Override
    public <T extends User> T getUserInstance(String userName) throws DataBackendException {
        T user = this.getUserInstance();
        user.setName(userName);
        return user;
    }

    @Override
    public <T extends User> T addUser(T user, String password) throws DataBackendException, EntityExistsException {
        if (StringUtils.isEmpty((String)user.getName())) {
            throw new DataBackendException("Could not create an user with empty name!");
        }
        if (this.checkExists(user)) {
            throw new EntityExistsException("The account '" + user.getName() + "' already exists");
        }
        user.setPassword(password);
        try {
            return this.persistNewUser(user);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to create account '" + user.getName() + "'", e);
        }
    }

    public ACLFactory getACLFactory() {
        if (this.aclFactory == null) {
            this.aclFactory = (ACLFactory)this.resolve(ACLFactory.ROLE);
        }
        return this.aclFactory;
    }
}

