/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.logging;

import java.lang.reflect.Method;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.reflection.Clazz;
import org.apache.fulcrum.yaafi.interceptor.baseservice.BaseInterceptorServiceImpl;
import org.apache.fulcrum.yaafi.interceptor.logging.LoggingInterceptorService;
import org.apache.fulcrum.yaafi.interceptor.util.DefaultToStringBuilderImpl;
import org.apache.fulcrum.yaafi.interceptor.util.InterceptorToStringBuilder;
import org.apache.fulcrum.yaafi.interceptor.util.MethodToStringBuilderImpl;
import org.apache.fulcrum.yaafi.interceptor.util.StopWatch;

public class LoggingInterceptorServiceImpl
extends BaseInterceptorServiceImpl
implements LoggingInterceptorService,
Reconfigurable,
Initializable {
    private static final int MAX_ARG_LENGTH = 2000;
    private static final String SEPERATOR = ";";
    private int maxArgLength = 2000;
    private String toStringBuilderClassName;
    private boolean monitorAllExceptions;
    private Class toStringBuilderClass;
    static /* synthetic */ Class class$org$apache$fulcrum$yaafi$interceptor$util$ArgumentToStringBuilderImpl;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.maxArgLength = configuration.getChild("maxArgLength").getValueAsInteger(2000);
        this.toStringBuilderClassName = configuration.getChild("toStringBuilderClass").getValue((class$org$apache$fulcrum$yaafi$interceptor$util$ArgumentToStringBuilderImpl == null ? (class$org$apache$fulcrum$yaafi$interceptor$util$ArgumentToStringBuilderImpl = LoggingInterceptorServiceImpl.class$("org.apache.fulcrum.yaafi.interceptor.util.ArgumentToStringBuilderImpl")) : class$org$apache$fulcrum$yaafi$interceptor$util$ArgumentToStringBuilderImpl).getName());
        this.monitorAllExceptions = configuration.getChild("monitorAllExceptions").getValueAsBoolean(true);
    }

    public void initialize() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (Clazz.hasClazz(classLoader, this.getToStringBuilderClassName())) {
            this.toStringBuilderClass = Clazz.getClazz(classLoader, this.getToStringBuilderClassName());
        }
        InterceptorToStringBuilder interceptorToStringBuilder = this.createArgumentToStringBuilder(this);
        ((Object)interceptorToStringBuilder).toString();
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        super.reconfigure(configuration);
        this.configure(configuration);
    }

    public void onEntry(AvalonInterceptorContext interceptorContext) {
        if (this.isServiceMonitored(interceptorContext) && this.getLogger().isInfoEnabled()) {
            String msg = this.toString(interceptorContext, (StopWatch)null, 0);
            this.getLogger().info(msg);
            this.createStopWatch(interceptorContext);
        }
    }

    public void onError(AvalonInterceptorContext interceptorContext, Throwable t) {
        if (this.getLogger().isErrorEnabled() && (this.isMonitorAllExceptions() || this.isServiceMonitored(interceptorContext))) {
            StopWatch stopWatch = this.getStopWatch(interceptorContext);
            stopWatch.stop();
            String msg = this.toString(interceptorContext, stopWatch, t);
            this.getLogger().error(msg);
        }
    }

    public void onExit(AvalonInterceptorContext interceptorContext, Object result) {
        if (this.isServiceMonitored(interceptorContext) && this.getLogger().isDebugEnabled()) {
            StopWatch stopWatch = this.getStopWatch(interceptorContext);
            stopWatch.stop();
            String msg = this.toString(interceptorContext, stopWatch, result);
            this.getLogger().debug(msg);
        }
    }

    protected void createStopWatch(AvalonInterceptorContext interceptorContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        interceptorContext.getRequestContext().put(this.getServiceName(), stopWatch);
    }

    protected StopWatch getStopWatch(AvalonInterceptorContext interceptorContext) {
        StopWatch result = (StopWatch)interceptorContext.getRequestContext().remove(this.getServiceName());
        if (result == null) {
            result = new StopWatch();
            result.start();
        }
        return result;
    }

    protected int getMaxArgLength() {
        return this.maxArgLength;
    }

    protected boolean isMonitorAllExceptions() {
        return this.monitorAllExceptions;
    }

    protected Class getToStringBuilderClass() {
        return this.toStringBuilderClass;
    }

    protected String getToStringBuilderClassName() {
        return this.toStringBuilderClassName;
    }

    protected InterceptorToStringBuilder createArgumentToStringBuilder(Object target) {
        InterceptorToStringBuilder result = null;
        try {
            result = (InterceptorToStringBuilder)this.getToStringBuilderClass().newInstance();
        }
        catch (Exception e) {
            String msg = "Unable to create an instance for " + this.getToStringBuilderClassName();
            this.getLogger().error(msg, (Throwable)e);
            result = new DefaultToStringBuilderImpl();
        }
        result.setTarget(target);
        result.setMaxArgLength(this.getMaxArgLength());
        result.setMode(1);
        return result;
    }

    protected String toString(AvalonInterceptorContext avalonInterceptorContext, StopWatch stopWatch, Object result) {
        StringBuffer methodSignature = new StringBuffer();
        InterceptorToStringBuilder toStringBuilder = this.createArgumentToStringBuilder(result);
        methodSignature.append(this.toString(avalonInterceptorContext, stopWatch, 1));
        methodSignature.append(SEPERATOR);
        methodSignature.append("result={");
        methodSignature.append(((Object)toStringBuilder).toString());
        methodSignature.append("}");
        return methodSignature.toString();
    }

    protected String toString(AvalonInterceptorContext avalonInterceptorContext, StopWatch stopWatch, Throwable throwable) {
        StringBuffer methodSignature = new StringBuffer();
        InterceptorToStringBuilder toStringBuilder = this.createArgumentToStringBuilder(throwable);
        methodSignature.append(this.toString(avalonInterceptorContext, stopWatch, 2));
        methodSignature.append(SEPERATOR);
        methodSignature.append(throwable.getClass().getName());
        methodSignature.append(SEPERATOR);
        methodSignature.append(((Object)toStringBuilder).toString());
        return methodSignature.toString();
    }

    protected String toString(AvalonInterceptorContext interceptorContext, StopWatch stopWatch, int mode) {
        StringBuffer result = new StringBuffer();
        Method method = interceptorContext.getMethod();
        Object[] args = interceptorContext.getArgs();
        InterceptorToStringBuilder toStringBuilder = null;
        MethodToStringBuilderImpl methodToStringBuilder = new MethodToStringBuilderImpl(method);
        if (args == null) {
            args = new Object[]{};
        }
        result.append(interceptorContext.getTransactionId());
        result.append(SEPERATOR);
        result.append(interceptorContext.getInvocationId());
        result.append(SEPERATOR);
        result.append(interceptorContext.getInvocationDepth());
        result.append(SEPERATOR);
        result.append(mode);
        result.append(SEPERATOR);
        result.append(interceptorContext.getServiceShorthand());
        result.append(SEPERATOR);
        result.append(method.getName());
        result.append(SEPERATOR);
        if (stopWatch != null) {
            result.append(stopWatch.getTime());
        } else {
            result.append('0');
        }
        result.append(SEPERATOR);
        result.append(methodToStringBuilder.toString());
        if (0 == mode || 2 == mode) {
            for (int i = 0; i < args.length; ++i) {
                toStringBuilder = this.createArgumentToStringBuilder(args[i]);
                result.append(SEPERATOR);
                result.append("arg[" + i + "]:={");
                result.append(((Object)toStringBuilder).toString());
                result.append("}");
            }
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

