/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContextImpl;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorService;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class AvalonInterceptorInvocationHandler
implements InvocationHandler {
    private String serviceName;
    private String serviceShorthand;
    private Object serviceDelegate;
    private AvalonInterceptorService[] serviceInterceptorList;
    private static volatile long transactionCounter = 0L;
    private Long transactionId;

    public AvalonInterceptorInvocationHandler(String serviceName, String serviceShorthand, Object serviceDelegate, AvalonInterceptorService[] serviceInterceptorList) {
        Validate.notEmpty(serviceName, "serviceName");
        Validate.notEmpty(serviceShorthand, "serviceShorthand");
        Validate.notNull(serviceDelegate, "serviceDelegate");
        Validate.notNull(serviceInterceptorList, "serviceInterceptorList");
        this.serviceName = serviceName;
        this.serviceShorthand = serviceShorthand;
        this.serviceDelegate = serviceDelegate;
        this.serviceInterceptorList = serviceInterceptorList;
    }

    public Object getServiceDelegate() {
        return this.serviceDelegate;
    }

    public AvalonInterceptorService[] getServiceInterceptorList() {
        return this.serviceInterceptorList;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceShorthand() {
        return this.serviceShorthand;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("serviceShorthand", this.serviceShorthand);
        toStringBuilder.append("serviceName", this.serviceName);
        toStringBuilder.append("serviceDelegate", this.serviceDelegate);
        toStringBuilder.append("transactionId", this.transactionId);
        return toStringBuilder.toString();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        AvalonInterceptorContextImpl context = new AvalonInterceptorContextImpl(this.getServiceName(), this.getServiceShorthand(), this.getServiceDelegate(), method, args);
        boolean hasCreatedTransaction = this.createTransactionId(context);
        try {
            context.incrementInvocationDepth();
            this.onEntry(context);
            result = method.invoke(this.getServiceDelegate(), args);
            this.onExit(context, result);
            Object object = result;
            return object;
        }
        catch (InvocationTargetException e) {
            this.onError(context, e.getTargetException());
            throw e.getTargetException();
        }
        finally {
            context.decrementInvocationDepth();
            if (hasCreatedTransaction) {
                context.clearTransactionId();
            }
        }
    }

    private void onEntry(AvalonInterceptorContext context) {
        for (int i = 0; i < this.getServiceInterceptorList().length; ++i) {
            this.getServiceInterceptorList()[i].onEntry(context);
        }
    }

    private void onExit(AvalonInterceptorContext context, Object result) {
        for (int i = this.getServiceInterceptorList().length - 1; i >= 0; --i) {
            this.getServiceInterceptorList()[i].onExit(context, result);
        }
    }

    private void onError(AvalonInterceptorContext context, Throwable t) {
        for (int i = this.getServiceInterceptorList().length - 1; i >= 0; --i) {
            this.getServiceInterceptorList()[i].onError(context, t);
        }
    }

    private boolean createTransactionId(AvalonInterceptorContext context) {
        Long currentTransactionId = null;
        if (!context.hasTransactionId()) {
            currentTransactionId = new Long(++transactionCounter);
            context.setTransactionId(currentTransactionId);
            return true;
        }
        return false;
    }
}

