/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.localization.LocaleTokenizer;
import org.apache.fulcrum.localization.LocalizationService;
import org.apache.fulcrum.localization.SimpleLocalizationServiceImpl;

public class DefaultLocalizationService
extends SimpleLocalizationServiceImpl
implements LocalizationService {
    public ResourceBundle getBundle(String bundleName, String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    public ResourceBundle getBundle(HttpServletRequest req) {
        return this.getBundle(this.getDefaultBundleName(), this.getLocale(req));
    }

    public ResourceBundle getBundle(String bundleName, HttpServletRequest req) {
        return this.getBundle(bundleName, this.getLocale(req));
    }

    public Locale getLocale(HttpServletRequest req) {
        return this.getLocale(req.getHeader("Accept-Language"));
    }

    public Locale getLocale(String header) {
        LocaleTokenizer tok;
        if (!StringUtils.isEmpty((String)header) && (tok = new LocaleTokenizer(header)).hasNext()) {
            return (Locale)tok.next();
        }
        return this.getDefaultLocale();
    }
}

