/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.util.HashMap;
import java.util.Map;
import org.apache.torque.adapter.DB;
import org.apache.torque.adapter.DBAxion;
import org.apache.torque.adapter.DBCloudscape;
import org.apache.torque.adapter.DBDB2400;
import org.apache.torque.adapter.DBDB2App;
import org.apache.torque.adapter.DBDB2Net;
import org.apache.torque.adapter.DBDerby;
import org.apache.torque.adapter.DBFirebird;
import org.apache.torque.adapter.DBHypersonicSQL;
import org.apache.torque.adapter.DBInformix;
import org.apache.torque.adapter.DBInstantDB;
import org.apache.torque.adapter.DBInterbase;
import org.apache.torque.adapter.DBMM;
import org.apache.torque.adapter.DBMSSQL;
import org.apache.torque.adapter.DBNone;
import org.apache.torque.adapter.DBOdbc;
import org.apache.torque.adapter.DBOracle;
import org.apache.torque.adapter.DBPostgres;
import org.apache.torque.adapter.DBSapDB;
import org.apache.torque.adapter.DBSybase;
import org.apache.torque.adapter.DBWeblogic;

public class DBFactory {
    private static Map adapters = new HashMap(40);

    private DBFactory() {
    }

    public static DB create(String key) throws InstantiationException {
        Class adapterClass = (Class)adapters.get(key);
        if (adapterClass == null) {
            return null;
        }
        try {
            DB adapter = (DB)adapterClass.newInstance();
            return adapter;
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Could not instantiate adapter for key : " + key + ": Assure that adapter classes are in your classpath");
        }
    }

    public static DB create(String key, String className) throws InstantiationException {
        Class<?> adapterClass;
        try {
            adapterClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Could not find adapter " + className + " for key " + key + ": Check your configuration file");
        }
        try {
            DB adapter = (DB)adapterClass.newInstance();
            adapters.put(key, adapterClass);
            return adapter;
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Could not instantiate adapter for key: " + key + ": Assure that adapter classes are in your classpath");
        }
    }

    static {
        adapters.put("com.ibm.as400.access.AS400JDBCDriver", DBDB2400.class);
        adapters.put("COM.ibm.db2.jdbc.app.DB2Driver", DBDB2App.class);
        adapters.put("COM.ibm.db2.jdbc.net.DB2Driver", DBDB2Net.class);
        adapters.put("COM.cloudscape.core.JDBCDriver", DBCloudscape.class);
        adapters.put("org.firebirdsql.jdbc.FBDriver", DBFirebird.class);
        adapters.put("org.hsql.jdbcDriver", DBHypersonicSQL.class);
        adapters.put("org.hsqldb.jdbcDriver", DBHypersonicSQL.class);
        adapters.put("interbase.interclient.Driver", DBInterbase.class);
        adapters.put("org.enhydra.instantdb.jdbc.idbDriver", DBInstantDB.class);
        adapters.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", DBMSSQL.class);
        adapters.put("com.jnetdirect.jsql.JSQLDriver", DBMSSQL.class);
        adapters.put("org.gjt.mm.mysql.Driver", DBMM.class);
        adapters.put("oracle.jdbc.driver.OracleDriver", DBOracle.class);
        adapters.put("org.postgresql.Driver", DBPostgres.class);
        adapters.put("com.sap.dbtech.jdbc.DriverSapDB", DBSapDB.class);
        adapters.put("com.sybase.jdbc.SybDriver", DBSybase.class);
        adapters.put("com.sybase.jdbc2.jdbc.SybDriver", DBSybase.class);
        adapters.put("weblogic.jdbc.pool.Driver", DBWeblogic.class);
        adapters.put("org.axiondb.jdbc.AxionDriver", DBAxion.class);
        adapters.put("com.informix.jdbc.IfxDriver", DBInformix.class);
        adapters.put("sun.jdbc.odbc.JdbcOdbcDriver", DBOdbc.class);
        adapters.put("com.ibm.db2.jcc.DB2Driver", DBDerby.class);
        adapters.put("org.apache.derby.jdbc.EmbeddedDriver", DBDerby.class);
        adapters.put("as400", DBDB2400.class);
        adapters.put("db2app", DBDB2App.class);
        adapters.put("db2net", DBDB2Net.class);
        adapters.put("cloudscape", DBCloudscape.class);
        adapters.put("firebird", DBFirebird.class);
        adapters.put("hypersonic", DBHypersonicSQL.class);
        adapters.put("interbase", DBInterbase.class);
        adapters.put("instantdb", DBInstantDB.class);
        adapters.put("mssql", DBMSSQL.class);
        adapters.put("mysql", DBMM.class);
        adapters.put("oracle", DBOracle.class);
        adapters.put("postgresql", DBPostgres.class);
        adapters.put("sapdb", DBSapDB.class);
        adapters.put("sybase", DBSybase.class);
        adapters.put("weblogic", DBWeblogic.class);
        adapters.put("axion", DBAxion.class);
        adapters.put("informix", DBInformix.class);
        adapters.put("odbc", DBOdbc.class);
        adapters.put("msaccess", DBOdbc.class);
        adapters.put("derby", DBDerby.class);
        adapters.put("", DBNone.class);
    }
}

