/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;
import org.apache.turbine.util.TurbineException;

public class TurbineAssemblerBrokerService
extends TurbineBaseService
implements AssemblerBrokerService {
    private static Log log = LogFactory.getLog(TurbineAssemblerBrokerService.class);
    private Map<String, List<AssemblerFactory>> factories = null;
    private Map<String, Assembler> assemblerCache = null;
    private Map<String, Loader> loaderCache = null;
    private boolean isCaching;

    private List<AssemblerFactory> getFactoryGroup(String type) {
        if (!this.factories.containsKey(type)) {
            this.factories.put(type, new Vector());
        }
        return this.factories.get(type);
    }

    private void registerFactories(String type) throws TurbineException {
        List names = this.getConfiguration().getList(type);
        log.info((Object)("Registering " + names.size() + " " + type + " factories."));
        for (String factory : names) {
            try {
                Object o = Class.forName(factory).newInstance();
                this.registerFactory(type, (AssemblerFactory)o);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TurbineException("Failed registering " + type + " factory: " + factory, t);
            }
        }
    }

    @Override
    public void init() throws InitializationException {
        this.factories = new HashMap<String, List<AssemblerFactory>>();
        try {
            Configuration conf = this.getConfiguration();
            Iterator i = conf.getKeys();
            while (i.hasNext()) {
                String type = (String)i.next();
                if ("classname".equalsIgnoreCase(type)) continue;
                this.registerFactories(type);
            }
        }
        catch (TurbineException e) {
            throw new InitializationException("AssemblerBrokerService failed to initialize", e);
        }
        this.isCaching = Turbine.getConfiguration().getBoolean("module.cache", true);
        if (this.isCaching) {
            int cacheSize = Turbine.getConfiguration().getInt("module.cache.size", 128);
            this.assemblerCache = new LRUMap(cacheSize);
            this.loaderCache = new LRUMap(cacheSize);
        }
        this.setInit(true);
    }

    @Override
    public void registerFactory(String type, AssemblerFactory factory) {
        this.getFactoryGroup(type).add(factory);
    }

    @Override
    public Assembler getAssembler(String type, String name) throws TurbineException {
        String key = type + ":" + name;
        Assembler assembler = null;
        if (this.isCaching && this.assemblerCache.containsKey(key)) {
            assembler = this.assemblerCache.get(key);
            log.debug((Object)("Found " + key + " in the cache!"));
        } else {
            log.debug((Object)("Loading " + key));
            List<AssemblerFactory> facs = this.getFactoryGroup(type);
            Iterator<AssemblerFactory> it = facs.iterator();
            while (assembler == null && it.hasNext()) {
                AssemblerFactory fac = it.next();
                try {
                    assembler = fac.getAssembler(name);
                }
                catch (Exception e) {
                    throw new TurbineException("Failed to load an assembler for " + name + " from the " + type + " factory " + fac.getClass().getName(), e);
                }
                if (!this.isCaching || assembler == null) continue;
                this.assemblerCache.put(key, assembler);
            }
        }
        return assembler;
    }

    @Override
    public Loader getLoader(String type) {
        Loader loader = null;
        if (this.isCaching && this.loaderCache.containsKey(type)) {
            loader = this.loaderCache.get(type);
            log.debug((Object)("Found " + type + " loader in the cache!"));
        } else {
            log.debug((Object)("Getting Loader for " + type));
            List<AssemblerFactory> facs = this.getFactoryGroup(type);
            Iterator<AssemblerFactory> it = facs.iterator();
            while (loader == null && it.hasNext()) {
                AssemblerFactory fac = it.next();
                loader = fac.getLoader();
            }
            if (this.isCaching && loader != null) {
                this.loaderCache.put(type, loader);
            }
        }
        if (loader == null) {
            log.warn((Object)("Loader for " + type + " is null."));
        }
        return loader;
    }
}

