/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.commons.lang.StringUtils;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.jsp.TurbineJsp;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class BaseJspScreen
extends TemplateScreen {
    private String prefix = this.getPrefix() + "/";

    @Override
    public ConcreteElement buildTemplate(RunData data) throws Exception {
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = TurbineTemplate.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        TurbineJsp.handleRequest(data, this.prefix + templateName, this.getLayout(data) == null);
        return null;
    }

    @Override
    public ConcreteElement buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = TurbineTemplate.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        TurbineJsp.handleRequest(pipelineData, this.prefix + templateName, this.getLayout(pipelineData) == null);
        return null;
    }

    @Override
    protected void doBuildTemplate(RunData data) throws Exception {
    }

    @Override
    protected void doBuildTemplate(PipelineData pipelineData) throws Exception {
    }
}

