/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.ElementAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;

public class JCSCacheService
extends AbstractLogEnabled
implements GlobalCacheService,
Runnable,
Configurable,
Disposable,
Initializable,
ThreadSafe {
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    private long cacheCheckFrequency;
    private JCS cacheManager;
    private String region;
    private String configFile;
    private static String group = "default_group";
    private Thread refreshing;
    private boolean continueThread;

    public void configure(Configuration config) throws ConfigurationException {
        this.cacheCheckFrequency = config.getChild("cacheCheckFrequency").getValueAsLong(5000L);
        this.region = config.getChild("region").getValue("fulcrum");
        this.configFile = config.getChild("configurationFile").getValue("/cache.ccf");
    }

    public void initialize() throws Exception {
        JCS.setConfigFilename((String)this.configFile);
        this.cacheManager = JCS.getInstance((String)this.region);
        this.continueThread = true;
        this.refreshing = new Thread(this);
        this.refreshing.setDaemon(true);
        this.refreshing.setName("JCSCacheService Refreshing");
        this.refreshing.start();
        this.getLogger().debug("JCSCacheService started.");
    }

    public void dispose() {
        this.continueThread = false;
        this.refreshing.interrupt();
        this.cacheManager.dispose();
        this.cacheManager = null;
        this.getLogger().debug("JCSCacheService stopped.");
    }

    public CachedObject getObject(String id) throws ObjectExpiredException {
        RefreshableCachedObject rco;
        CachedObject obj = (CachedObject)this.cacheManager.getFromGroup((Object)id, group);
        if (obj == null) {
            throw new ObjectExpiredException();
        }
        if (obj.isStale()) {
            if (obj instanceof RefreshableCachedObject) {
                rco = (RefreshableCachedObject)obj;
                if (rco.isUntouched()) {
                    this.removeObject(id);
                    throw new ObjectExpiredException();
                }
                rco.refresh();
                if (rco.isStale()) {
                    this.removeObject(id);
                    throw new ObjectExpiredException();
                }
            } else {
                this.removeObject(id);
                throw new ObjectExpiredException();
            }
        }
        if (obj instanceof RefreshableCachedObject) {
            rco = (RefreshableCachedObject)obj;
            rco.touch();
        }
        return obj;
    }

    public void addObject(String id, CachedObject o) {
        try {
            if (!(o.getContents() instanceof Serializable)) {
                this.getLogger().warn("Object with id [" + id + "] is not serializable. Expect problems with auxiliary caches.");
            }
            ElementAttributes attrib = (ElementAttributes)this.cacheManager.getDefaultElementAttributes();
            if (o instanceof RefreshableCachedObject) {
                attrib.setIsEternal(true);
            } else {
                attrib.setIsEternal(false);
                attrib.setMaxLifeSeconds((o.getExpires() + 500L) / 1000L);
            }
            attrib.setLastAccessTimeNow();
            attrib.setCreateTime();
            this.cacheManager.putInGroup((Object)id, group, (Object)o, (IElementAttributes)attrib);
        }
        catch (CacheException e) {
            this.getLogger().error("Could not add object " + id + " to cache", (Throwable)e);
        }
    }

    public void removeObject(String id) {
        this.cacheManager.remove((Object)id, group);
    }

    public List getKeys() {
        ArrayList keys = new ArrayList();
        keys.addAll(this.cacheManager.getGroupKeys(group));
        return keys;
    }

    public List getCachedObjects() {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator i = this.cacheManager.getGroupKeys(group).iterator();
        while (i.hasNext()) {
            Object o = this.cacheManager.getFromGroup(i.next(), group);
            if (o == null) continue;
            values.add(o);
        }
        return values;
    }

    public void run() {
        while (this.continueThread) {
            block6: {
                try {
                    Thread.sleep(this.cacheCheckFrequency);
                }
                catch (InterruptedException exc) {
                    if (this.continueThread) break block6;
                    return;
                }
            }
            Iterator i = this.cacheManager.getGroupKeys(group).iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Object o = this.cacheManager.getFromGroup((Object)key, group);
                if (o == null) {
                    this.removeObject(key);
                    continue;
                }
                if (!(o instanceof RefreshableCachedObject)) continue;
                RefreshableCachedObject rco = (RefreshableCachedObject)o;
                if (rco.isUntouched()) {
                    this.cacheManager.remove((Object)key, group);
                    continue;
                }
                if (!rco.isStale()) continue;
                rco.refresh();
            }
        }
    }

    public int getCacheSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        Set keys = this.cacheManager.getGroupKeys(group);
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            out.writeObject(this.cacheManager.getFromGroup(i.next(), group));
        }
        out.flush();
        int objectsize = baos.toByteArray().length - 4 * keys.size();
        return objectsize;
    }

    public int getNumberOfObjects() {
        int count = 0;
        Iterator i = this.cacheManager.getGroupKeys(group).iterator();
        while (i.hasNext()) {
            if (this.cacheManager.getFromGroup(i.next(), group) == null) continue;
            ++count;
        }
        return count;
    }

    public void flushCache() {
        this.cacheManager.invalidateGroup(group);
    }
}

