/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.apache.turbine.TurbineConstants;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.rundata.RunDataService;
import org.apache.turbine.services.rundata.TurbineRunDataFacade;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.template.TemplateInfo;

public class Turbine
extends HttpServlet
implements TurbineConstants {
    private static final long serialVersionUID = -6895381097045304308L;
    public static final String REDIRECTED_PATHINFO_NAME = "redirected";
    public static final String BASEDIR_KEY = "basedir";
    private static boolean firstInit = true;
    private static Throwable initFailure = null;
    private static boolean firstDoGet = true;
    private static ServerData serverData = null;
    private static String applicationRoot;
    private static ServletConfig servletConfig;
    private static ServletContext servletContext;
    private static String webappRoot;
    private static Configuration configuration;
    private TemplateService templateService = null;
    private RunDataService rundataService = null;
    private String inputEncoding = null;
    private static Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() throws ServletException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            super.init();
            ServletConfig config = this.getServletConfig();
            if (!firstInit) {
                log.info((Object)"Double initialization of Turbine was attempted!");
                return;
            }
            firstInit = false;
            try {
                ServletContext context = config.getServletContext();
                this.configure(config, context);
                this.templateService = TurbineTemplate.getService();
                this.rundataService = TurbineRunDataFacade.getService();
                if (this.rundataService == null) {
                    throw new TurbineException("No RunData Service configured!");
                }
            }
            catch (Exception e) {
                initFailure = e;
                log.fatal((Object)"Turbine: init() failed: ", (Throwable)e);
                throw new ServletException("Turbine: init() failed", (Throwable)e);
            }
            log.info((Object)"Turbine: init() Ready to Rumble!");
        }
    }

    private void configure(ServletConfig config, ServletContext context) throws Exception {
        String confPath;
        applicationRoot = Turbine.findInitParameter(context, config, "applicationRoot", "webContext");
        webappRoot = config.getServletContext().getRealPath("/");
        if (applicationRoot == null || applicationRoot.equals("webContext")) {
            applicationRoot = webappRoot;
        }
        Turbine.setApplicationRoot(applicationRoot);
        Turbine.createRuntimeDirectories(context, config);
        String confFile = Turbine.findInitParameter(context, config, "configuration", null);
        String confStyle = "unset";
        if (StringUtils.isNotEmpty((String)confFile)) {
            confPath = Turbine.getRealPath(confFile);
            ConfigurationFactory configurationFactory = new ConfigurationFactory(confPath);
            configurationFactory.setBasePath(Turbine.getApplicationRoot());
            configuration = configurationFactory.getConfiguration();
            confStyle = "XML";
        } else {
            confFile = Turbine.findInitParameter(context, config, "properties", "/WEB-INF/conf/TurbineResources.properties");
            confPath = Turbine.getRealPath(confFile);
            configuration = new PropertiesConfiguration(confPath);
            confStyle = "Properties";
        }
        String log4jFile = configuration.getString("log4j.file", "/WEB-INF/conf/Log4j.properties");
        if (StringUtils.isNotEmpty((String)log4jFile) && !log4jFile.equalsIgnoreCase("none")) {
            log4jFile = Turbine.getRealPath(log4jFile);
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(log4jFile));
                p.setProperty("applicationRoot", Turbine.getApplicationRoot());
                PropertyConfigurator.configure((Properties)p);
                log.info((Object)("Configured log4j from " + log4jFile));
            }
            catch (FileNotFoundException fnf) {
                System.err.println("Could not open Log4J configuration file " + log4jFile + ": ");
                fnf.printStackTrace();
            }
        }
        log.info((Object)("Loaded configuration  (" + confStyle + ") from " + confFile + " (" + confPath + ")"));
        Turbine.setTurbineServletConfig(config);
        Turbine.setTurbineServletContext(context);
        this.getServiceManager().setApplicationRoot(applicationRoot);
        configuration.setProperty("applicationRoot", (Object)applicationRoot);
        configuration.setProperty("webappRoot", (Object)webappRoot);
        configuration.setProperty("services.AvalonComponentService.earlyInit", (Object)Boolean.TRUE);
        this.getServiceManager().setConfiguration(configuration);
        this.getServiceManager().init();
        this.inputEncoding = configuration.getString("input.encoding", "ISO-8859-1");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input Encoding has been set to " + this.inputEncoding));
        }
    }

    private static void createRuntimeDirectories(ServletContext context, ServletConfig config) {
        String path = Turbine.findInitParameter(context, config, "loggingRoot", "/logs");
        File logDir = new File(Turbine.getRealPath(path));
        if (!logDir.exists() && !logDir.mkdirs()) {
            System.err.println("Cannot create directory for logs!");
        }
    }

    protected static final String findInitParameter(ServletContext context, ServletConfig config, String name, String defaultValue) {
        String path = null;
        boolean usingNamespace = name.startsWith("org.apache.turbine");
        while (StringUtils.isEmpty((String)(path = config.getInitParameter(name))) && StringUtils.isEmpty((String)(path = context.getInitParameter(name)))) {
            if (usingNamespace) {
                path = defaultValue;
                break;
            }
            name = "org.apache.turbine." + name;
            usingNamespace = true;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(RunData data) {
        Class clazz = Turbine.class;
        synchronized (clazz) {
            if (firstDoGet) {
                Turbine.saveServletInfo(data);
                firstDoGet = false;
                log.info((Object)"Turbine: first Request successful");
            }
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static String getServerName() {
        return Turbine.getDefaultServerData().getServerName();
    }

    public static String getServerScheme() {
        return Turbine.getDefaultServerData().getServerScheme();
    }

    public static String getServerPort() {
        return Integer.toString(Turbine.getDefaultServerData().getServerPort());
    }

    public static String getScriptName() {
        return Turbine.getDefaultServerData().getScriptName();
    }

    public static String getContextPath() {
        return Turbine.getDefaultServerData().getContextPath();
    }

    public static ServerData getDefaultServerData() {
        if (serverData == null) {
            String serverName = configuration.getString("serverdata.default.serverName");
            if (serverName == null) {
                log.error((Object)"ServerData Information requested from Turbine before first request!");
            } else {
                log.info((Object)"ServerData Information retrieved from configuration.");
            }
            serverData = new ServerData(serverName, configuration.getInt("serverdata.default.serverPort", 80), configuration.getString("serverdata.default.serverScheme", "http"), configuration.getString("serverdata.default.scriptName"), configuration.getString("serverdata.default.contextPath"));
        }
        return serverData;
    }

    public static void setTurbineServletConfig(ServletConfig config) {
        servletConfig = config;
    }

    public static ServletConfig getTurbineServletConfig() {
        return servletConfig;
    }

    public static void setTurbineServletContext(ServletContext context) {
        servletContext = context;
    }

    public static ServletContext getTurbineServletContext() {
        return servletContext;
    }

    public final void destroy() {
        this.getServiceManager().shutdownServices();
        System.gc();
        firstInit = true;
        firstDoGet = true;
        log.info((Object)"Turbine: Done shutting down!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        boolean requestRedirected = false;
        RunData data = null;
        try {
            String defaultPage;
            int timeout;
            if (initFailure != null) {
                throw initFailure;
            }
            if (req.getCharacterEncoding() == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Changing Input Encoding to " + this.inputEncoding));
                }
                try {
                    req.setCharacterEncoding(this.inputEncoding);
                }
                catch (UnsupportedEncodingException uee) {
                    log.warn((Object)("Could not change request encoding to " + this.inputEncoding), (Throwable)uee);
                }
            }
            data = this.rundataService.getRunData(req, res, this.getServletConfig());
            if (firstDoGet) {
                this.init(data);
            }
            if (data.getSession().isNew() && (timeout = configuration.getInt("session.timeout", -1)) != -1) {
                data.getSession().setMaxInactiveInterval(timeout);
            }
            data.setScreen(data.getParameters().getString("screen"));
            data.setAction(data.getParameters().getString("action"));
            if (data.hasAction()) {
                String action = data.getAction();
                log.debug((Object)("action = " + action));
                if (action.equalsIgnoreCase(configuration.getString("action.login", "LoginUser"))) {
                    this.loginAction(data);
                } else if (action.equalsIgnoreCase(configuration.getString("action.logout", "LogoutUser"))) {
                    this.logoutAction(data);
                }
            }
            ActionLoader.getInstance().exec(data, configuration.getString("action.sessionvalidator", "sessionvalidator.TemplateSessionValidator"));
            ActionLoader.getInstance().exec(data, configuration.getString("action.accesscontroller", "AccessController"));
            String string = defaultPage = this.templateService == null ? null : this.templateService.getDefaultPageName(data);
            if (defaultPage == null) {
                defaultPage = configuration.getString("page.default", "DefaultPage");
            }
            PageLoader.getInstance().exec(data, defaultPage);
            if (data.getACL() == null) {
                try {
                    data.getSession().removeAttribute("turbine.AccessControlList");
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
            }
            boolean bl = requestRedirected = data.getRedirectURI() != null && data.getRedirectURI().length() > 0;
            if (requestRedirected) {
                if (data.getResponse().isCommitted()) {
                    requestRedirected = false;
                    log.warn((Object)("redirect requested, response already committed: " + data.getRedirectURI()));
                } else {
                    data.getResponse().sendRedirect(data.getRedirectURI());
                }
            }
            if (!requestRedirected) {
                try {
                    if (!data.isPageSet() && !data.isOutSet()) {
                        throw new Exception("Nothing to output");
                    }
                    if (data.isPageSet() && !data.isOutSet()) {
                        data.getResponse().setLocale(data.getLocale());
                        data.getResponse().setContentType(data.getContentType());
                        data.getResponse().setStatus(data.getStatusCode());
                        data.getPage().output(data.getOut());
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"Output stream closed? ", (Throwable)e);
                }
            }
            this.rundataService.putRunData(data);
        }
        catch (Exception e) {
            this.handleException(data, res, e);
        }
        catch (Throwable t) {
            this.handleException(data, res, t);
            this.rundataService.putRunData(data);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.rundataService.putRunData(data);
        }
    }

    public final void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }

    private void loginAction(RunData data) throws Exception {
        ActionLoader.getInstance().exec(data, data.getAction());
        this.cleanupTemplateContext(data);
        data.setAction(null);
    }

    private void logoutAction(RunData data) throws Exception {
        ActionLoader.getInstance().exec(data, data.getAction());
        this.cleanupTemplateContext(data);
        data.setAction(null);
        data.getSession().invalidate();
    }

    private void cleanupTemplateContext(RunData data) throws Exception {
        TemplateInfo ti = data.getTemplateInfo();
        if (ti != null) {
            ti.removeTemp("VELOCITY_CONTEXT");
        }
    }

    public final String getServletInfo() {
        return "Turbine Servlet";
    }

    private void handleException(RunData data, HttpServletResponse res, Throwable t) {
        log.error((Object)"Turbine.handleException: ", t);
        String mimeType = "text/plain";
        try {
            data.setStackTrace(ExceptionUtils.getStackTrace((Throwable)t), t);
            data.setScreen(configuration.getString("screen.error", "VelocityErrorScreen"));
            if (data.getTemplateInfo() != null) {
                data.getTemplateInfo().setScreenTemplate(configuration.getString("template.error", "error.vm"));
            }
            data.setAction("");
            PageLoader.getInstance().exec(data, configuration.getString("page.default", "DefaultPage"));
            data.getResponse().setContentType(data.getContentType());
            data.getResponse().setStatus(data.getStatusCode());
            if (data.isPageSet()) {
                data.getOut().print(data.getPage().toString());
            }
        }
        catch (NoSuchFieldError e) {
            try {
                data.getResponse().setContentType(mimeType);
                data.getResponse().setStatus(200);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                data.getOut().print("java.lang.NoSuchFieldError: Please recompile all of your source code.");
            }
            catch (IOException ignored) {
                // empty catch block
            }
            log.error((Object)data.getStackTrace(), (Throwable)e);
        }
        catch (Throwable reallyScrewedNow) {
            StringBuffer msg = new StringBuffer();
            msg.append("Horrible Exception: ");
            if (data != null) {
                msg.append(data.getStackTrace());
            } else {
                msg.append(t);
            }
            try {
                res.setContentType(mimeType);
                res.setStatus(200);
                res.getWriter().print(msg.toString());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            log.error((Object)reallyScrewedNow.getMessage(), reallyScrewedNow);
        }
    }

    public static synchronized void saveServletInfo(RunData data) {
        serverData = (ServerData)data.getServerData().clone();
    }

    public static void setApplicationRoot(String val) {
        applicationRoot = val;
    }

    public static String getApplicationRoot() {
        return applicationRoot;
    }

    public static String getRealPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return new File(Turbine.getApplicationRoot(), path).getAbsolutePath();
    }

    private ServiceManager getServiceManager() {
        return TurbineServices.getInstance();
    }

    static {
        configuration = null;
        log = LogFactory.getLog((Class)Turbine.class);
    }
}

