/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContextImpl;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorService;
import org.apache.fulcrum.yaafi.framework.util.ReadWriteLock;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class AvalonInterceptorInvocationHandler
implements InvocationHandler {
    private String serviceName;
    private String serviceShorthand;
    private Object serviceDelegate;
    private AvalonInterceptorService[] serviceInterceptorList;
    private ReadWriteLock readWriteLock;
    private static volatile long transactionCounter = 0L;
    private Long transactionId;

    public AvalonInterceptorInvocationHandler(String serviceName, String serviceShorthand, Object serviceDelegate, AvalonInterceptorService[] serviceInterceptorList, ReadWriteLock readWriteLock) {
        Validate.notEmpty(serviceName, "serviceName");
        Validate.notEmpty(serviceShorthand, "serviceShorthand");
        Validate.notNull(serviceDelegate, "serviceDelegate");
        Validate.notNull(serviceInterceptorList, "serviceInterceptorList");
        Validate.notNull(readWriteLock, "readWriteLock");
        this.serviceName = serviceName;
        this.serviceShorthand = serviceShorthand;
        this.serviceDelegate = serviceDelegate;
        this.serviceInterceptorList = serviceInterceptorList;
        this.readWriteLock = readWriteLock;
    }

    public Object getServiceDelegate() {
        return this.serviceDelegate;
    }

    public AvalonInterceptorService[] getServiceInterceptorList() {
        return this.serviceInterceptorList;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceShorthand() {
        return this.serviceShorthand;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        return super.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Object lock = null;
        AvalonInterceptorContextImpl context = new AvalonInterceptorContextImpl(this.getServiceName(), this.getServiceShorthand(), this.getServiceDelegate(), method, args);
        boolean hasCreatedTransaction = this.createTransactionId(context);
        try {
            try {
                context.incrementInvocationDepth();
                lock = this.getReadWriteLock().getReadLock(this.serviceName);
                this.onEntry(context);
                result = method.invoke(this.getServiceDelegate(), args);
                this.onExit(context, result);
                Object object = result;
                Object var10_11 = null;
                this.getReadWriteLock().releaseLock(lock, this.serviceName);
                context.decrementInvocationDepth();
                if (!hasCreatedTransaction) return object;
                context.clearTransactionId();
                return object;
            }
            catch (InvocationTargetException e) {
                this.onError(context, e.getTargetException());
                throw e.getTargetException();
            }
            catch (Throwable t) {
                throw t;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.getReadWriteLock().releaseLock(lock, this.serviceName);
            context.decrementInvocationDepth();
            if (!hasCreatedTransaction) throw throwable;
            context.clearTransactionId();
            throw throwable;
        }
    }

    private void onEntry(AvalonInterceptorContext context) {
        for (int i = 0; i < this.getServiceInterceptorList().length; ++i) {
            this.getServiceInterceptorList()[i].onEntry(context);
        }
    }

    private void onExit(AvalonInterceptorContext context, Object result) {
        for (int i = this.getServiceInterceptorList().length - 1; i >= 0; --i) {
            this.getServiceInterceptorList()[i].onExit(context, result);
        }
    }

    private void onError(AvalonInterceptorContext context, Throwable t) {
        for (int i = this.getServiceInterceptorList().length - 1; i >= 0; --i) {
            this.getServiceInterceptorList()[i].onError(context, t);
        }
    }

    private final ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    private boolean createTransactionId(AvalonInterceptorContext context) {
        Long currentTransactionId = null;
        if (!context.hasTransactionId()) {
            currentTransactionId = new Long(++transactionCounter);
            context.setTransactionId(currentTransactionId);
            return true;
        }
        return false;
    }
}

