/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.upload;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.upload.UploadService;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.ParameterParser;

public class TurbineUploadService
extends TurbineBaseService
implements UploadService {
    private static Log log = LogFactory.getLog((Class)TurbineUploadService.class);
    protected ServletFileUpload fileUpload = null;
    protected DiskFileItemFactory itemFactory = null;
    private boolean automatic;

    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        String repoPath = conf.getString("repository", ".");
        if (!repoPath.startsWith("/")) {
            String testPath = Turbine.getRealPath(repoPath);
            File testDir = new File(testPath);
            if (!testDir.exists() && !testDir.mkdirs()) {
                throw new InitializationException("Could not create target directory!");
            }
            repoPath = testPath;
            conf.setProperty("repository", (Object)repoPath);
        }
        log.debug((Object)("Upload Path is now " + repoPath));
        long sizeMax = conf.getLong("size.max", 0x100000L);
        log.debug((Object)("Max Size " + sizeMax));
        int sizeThreshold = conf.getInt("size.threshold", 10240);
        log.debug((Object)("Threshold Size " + sizeThreshold));
        this.automatic = conf.getBoolean("automatic", false);
        log.debug((Object)("Auto Upload " + this.automatic));
        this.itemFactory = new DiskFileItemFactory();
        this.itemFactory.setSizeThreshold(sizeThreshold);
        this.itemFactory.setRepository(new File(repoPath));
        this.fileUpload = new ServletFileUpload((FileItemFactory)this.itemFactory);
        this.fileUpload.setSizeMax(sizeMax);
        this.setInit(true);
    }

    public long getSizeMax() {
        return this.fileUpload.getSizeMax();
    }

    public int getSizeThreshold() {
        return this.itemFactory.getSizeThreshold();
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public String getRepository() {
        return this.itemFactory.getRepository().getAbsolutePath();
    }

    public void parseRequest(HttpServletRequest req, ParameterParser params, String path) throws TurbineException {
        block9: {
            String contentType = req.getHeader("Content-type");
            if (!contentType.startsWith("multipart/form-data")) {
                throw new TurbineException("the request doesn't contain a multipart/form-data stream");
            }
            int requestSize = req.getContentLength();
            if (requestSize == -1) {
                throw new TurbineException("the request was rejected because it's size is unknown");
            }
            if ((long)requestSize > this.getSizeMax()) {
                throw new TurbineException("the request was rejected because it's size exceeds allowed range");
            }
            try {
                List fileList = this.fileUpload.parseRequest(req);
                if (fileList == null) break block9;
                Iterator it = fileList.iterator();
                while (it.hasNext()) {
                    FileItem fi = (FileItem)it.next();
                    if (fi.isFormField()) {
                        log.debug((Object)("Found an simple form field: " + fi.getFieldName() + ", adding value " + fi.getString()));
                        String value = null;
                        try {
                            value = fi.getString(params.getCharacterEncoding());
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error((Object)(params.getCharacterEncoding() + " encoding is not supported." + "Used the default when reading form data."));
                            value = fi.getString();
                        }
                        params.add(fi.getFieldName(), value);
                        continue;
                    }
                    log.debug((Object)("Found an uploaded file: " + fi.getFieldName()));
                    log.debug((Object)("It has " + fi.getSize() + " Bytes and is " + (fi.isInMemory() ? "" : "not ") + "in Memory"));
                    log.debug((Object)("Adding FileItem as " + fi.getFieldName() + " to the params"));
                    params.add(fi.getFieldName(), fi);
                }
            }
            catch (FileUploadException e) {
                throw new TurbineException(e);
            }
        }
    }
}

