/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.locking.LockStrategy;
import ojb.odmg.locking.SerializableStrategy;
import org.odmg.Database;
import org.odmg.ODMGException;
import test.ojb.odmg.Article;

public class LockTestSerializable
extends TestCase {
    TransactionImpl tx1;
    TransactionImpl tx2;
    String databaseName;
    Article obj;
    LockStrategy ls = new SerializableStrategy();
    private static Class CLASS = class$test$ojb$odmg$LockTestSerializable == null ? (class$test$ojb$odmg$LockTestSerializable = LockTestSerializable.class$("test.ojb.odmg.LockTestSerializable")) : class$test$ojb$odmg$LockTestSerializable;
    static /* synthetic */ Class class$test$ojb$odmg$LockTestSerializable;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public LockTestSerializable(String name) {
        super(name);
    }

    public void setUp() {
        try {
            this.databaseName = "repository.xml";
            OJB odmg = OJB.getInstance();
            Database db = odmg.newDatabase();
            db.open(this.databaseName, 2);
            this.tx1 = (TransactionImpl)odmg.newTransaction();
            this.tx2 = (TransactionImpl)odmg.newTransaction();
            this.obj = new Article();
            this.obj.setArticleId(333);
        }
        catch (ODMGException oDMGException) {
            // empty catch block
        }
    }

    public void testSingleReadLock() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
    }

    public void testUpgradeReadLock() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.upgradeLock(this.tx1, this.obj));
    }

    public void testReadThenWrite() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
    }

    public void testSingleWriteLock() {
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
    }

    public void testWriteThenRead() {
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
    }

    public void testMultipleReadLock() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.readLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testUpgradeWithExistingReader() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.upgradeLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testWriteWithExistingReader() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.writeLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testUpgradeWithMultipleReaders() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.readLock(this.tx2, this.obj) ? 1 : 0) != 0);
        Assert.assertTrue((!this.ls.upgradeLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testWriteWithMultipleReaders() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.readLock(this.tx2, this.obj) ? 1 : 0) != 0);
        Assert.assertTrue((!this.ls.writeLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testUpgradeWithMultipleReadersOn1() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.readLock(this.tx2, this.obj) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.ls.upgradeLock(this.tx1, this.obj));
    }

    public void testWriteWithMultipleReadersOn1() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.readLock(this.tx2, this.obj) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
    }

    public void testReadWithExistingWriter() {
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.readLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testMultipleWriteLock() {
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
        Assert.assertTrue((!this.ls.writeLock(this.tx2, this.obj) ? 1 : 0) != 0);
    }

    public void testReleaseReadLock() {
        Assert.assertTrue((boolean)this.ls.readLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.releaseLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx2, this.obj));
    }

    public void testReleaseUpgradeLock() {
        Assert.assertTrue((boolean)this.ls.upgradeLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.releaseLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx2, this.obj));
    }

    public void testReleaseWriteLock() {
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.releaseLock(this.tx1, this.obj));
        Assert.assertTrue((boolean)this.ls.writeLock(this.tx2, this.obj));
    }

    public void tearDown() {
        try {
            this.ls.releaseLock(this.tx1, this.obj);
            this.ls.releaseLock(this.tx2, this.obj);
            OJB.getInstance().currentTransaction().abort();
            OJB.getInstance().getDatabase(null).close();
            this.databaseName = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

