/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger.task;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ConsumerTask
extends Task {
    private Messenger messenger;
    private String messengerName;
    private Destination destination;
    private String subject;
    private MessengerManager messengerManager;
    private int count;
    private File dir = new File(".");

    public void setDir(File dir) {
        this.dir = dir;
    }

    public Messenger getMessenger() throws JMSException {
        if (this.messenger == null) {
            this.messenger = this.getMessengerManager().getMessenger(this.getMessengerName());
        }
        return this.messenger;
    }

    public void setMessenger(Messenger messenger) {
        this.messenger = messenger;
    }

    public String getMessengerName() {
        return this.messengerName;
    }

    public void setMessengerName(String messengerName) {
        this.messengerName = messengerName;
    }

    public Destination getDestination() throws JMSException {
        if (this.destination == null) {
            this.destination = this.getMessenger().getDestination(this.getSubject());
        }
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MessengerManager getMessengerManager() {
        return this.messengerManager;
    }

    public void setMessengerManager(MessengerManager messengerManager) {
        this.messengerManager = messengerManager;
    }

    public void setConfiguration(String uri) throws JMSException {
        this.setMessengerManager(MessengerManager.load(uri));
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    /*
     * Loose catch block
     */
    public void execute() throws BuildException {
        block14: {
            Messenger messenger = this.getMessenger();
            if (messenger == null) {
                throw new BuildException("Must specify a valid Messenger", this.location);
            }
            Destination destination = this.getDestination();
            if (destination == null) {
                throw new BuildException("Must specify a valid JMS Destination", this.location);
            }
            if (this.count > 0) {
                this.log("Will wait until I receive: " + this.count + " messages and will write to directory: " + this.dir);
                int i = 0;
                while (i < this.count) {
                    Message message = messenger.receive(destination);
                    this.processMessage(message);
                    ++i;
                }
            } else {
                this.log("Infinite loop. Will write to directory: " + this.dir);
                while (true) {
                    Message message = messenger.receive(destination);
                    this.processMessage(message);
                }
            }
            this.log("Finished.");
            Object var6_8 = null;
            try {
                this.messenger.close();
            }
            catch (Exception e) {}
            break block14;
            {
                catch (IOException e) {
                    this.log("Caught exception: " + e, 0);
                    throw new BuildException((Throwable)e, this.location);
                }
                catch (JMSException e) {
                    this.log("Caught exception: " + (Object)((Object)e), 0);
                    throw new BuildException((Throwable)e, this.location);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    this.messenger.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void processMessage(Message message) throws IOException, JMSException {
        this.log("Received message to: " + message);
        String text = null;
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            text = textMessage.toString();
        } else {
            text = message.toString();
        }
        this.processMessageText(text);
    }

    protected void processMessageText(String text) throws IOException {
        FileWriter writer = new FileWriter(this.dir);
        writer.write(text);
        writer.close();
    }
}

