/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLConfiguration
extends AbstractFileConfiguration {
    private static final String ATTRIBUTE_START = "[@";
    private static final String ATTRIBUTE_END = "]";
    private static final String NODE_DELIMITER = ".";
    private Document document;
    private boolean autoSave = false;

    public XMLConfiguration() {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationRuntimeException(e.getMessage(), e);
        }
        this.document = builder.newDocument();
        this.document.appendChild(this.document.createElement("configuration"));
    }

    public XMLConfiguration(String resource) throws ConfigurationException {
        this.fileName = resource;
        this.url = ConfigurationUtils.locate(resource);
        this.load();
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        this.setFile(file);
        this.load();
    }

    public XMLConfiguration(URL url) throws ConfigurationException {
        this.setURL(url);
        this.load();
    }

    public void load(Reader in) throws ConfigurationException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = builder.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        this.initProperties(this.document.getDocumentElement(), new StringBuffer());
    }

    private void initProperties(Element element, StringBuffer hierarchy) {
        StringBuffer buffer = new StringBuffer();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node instanceof Element) {
                Element child = (Element)node;
                StringBuffer subhierarchy = new StringBuffer(hierarchy.toString());
                subhierarchy.append(child.getTagName());
                this.processAttributes(subhierarchy.toString(), child);
                this.initProperties(child, subhierarchy.append(NODE_DELIMITER));
                continue;
            }
            if (!(node instanceof CDATASection) && !(node instanceof Text)) continue;
            CharacterData data = (CharacterData)node;
            buffer.append(data.getData());
        }
        String text = buffer.toString().trim();
        if (text.length() > 0 && hierarchy.length() > 0) {
            super.addProperty(hierarchy.substring(0, hierarchy.length() - 1), text);
        }
    }

    private void processAttributes(String hierarchy, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = hierarchy + ATTRIBUTE_START + attr.getName() + ATTRIBUTE_END;
            super.addProperty(attrName, attr.getValue());
        }
    }

    public void addProperty(String name, Object value) {
        super.addProperty(name, value);
        this.addXmlProperty(name, value);
        this.possiblySave();
    }

    Object getXmlProperty(String name) {
        String[] nodes = XMLConfiguration.parseElementNames(name);
        String attName = XMLConfiguration.parseAttributeName(name);
        List children = this.findElementsForPropertyNodes(nodes);
        ArrayList<String> properties = new ArrayList<String>();
        if (attName == null) {
            Iterator cIter = children.iterator();
            while (cIter.hasNext()) {
                Element child = (Element)cIter.next();
                String text = XMLConfiguration.getChildText(child);
                if (!StringUtils.isNotEmpty((String)text)) continue;
                properties.add(text);
            }
        } else {
            Iterator cIter = children.iterator();
            while (cIter.hasNext()) {
                Element child = (Element)cIter.next();
                if (!child.hasAttribute(attName)) continue;
                properties.add(child.getAttribute(attName));
            }
        }
        switch (properties.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return properties.get(0);
            }
        }
        return properties;
    }

    private List findElementsForPropertyNodes(String[] nodes) {
        ArrayList<Element> children = new ArrayList<Element>();
        ArrayList<Element> elements = new ArrayList<Element>();
        children.add(this.document.getDocumentElement());
        for (int i = 0; i < nodes.length; ++i) {
            elements.clear();
            elements.addAll(children);
            children.clear();
            String eName = nodes[i];
            Iterator eIter = elements.iterator();
            while (eIter.hasNext()) {
                Element element = (Element)eIter.next();
                NodeList list = element.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Element child;
                    Node node = list.item(j);
                    if (!(node instanceof Element) || !eName.equals((child = (Element)node).getTagName())) continue;
                    children.add(child);
                }
            }
        }
        return children;
    }

    private static String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
                continue;
            }
            if (type != 4) continue;
            str.append(child.getNodeValue());
        }
        return StringUtils.trimToNull((String)str.toString());
    }

    private Element getChildElementWithName(String eName, Element element) {
        Element child = null;
        NodeList list = element.getChildNodes();
        for (int j = 0; j < list.getLength(); ++j) {
            Node node = list.item(j);
            if (!(node instanceof Element)) continue;
            child = (Element)node;
            if (eName.equals(child.getTagName())) break;
            child = null;
        }
        return child;
    }

    private void addXmlProperty(String name, Object value) {
        Element element;
        String[] nodes = XMLConfiguration.parseElementNames(name);
        String attName = XMLConfiguration.parseAttributeName(name);
        Element parent = element = this.document.getDocumentElement();
        for (int i = 0; i < nodes.length && element != null; ++i) {
            Element child;
            parent = element;
            String eName = nodes[i];
            element = child = this.getChildElementWithName(eName, element);
        }
        Element child = this.document.createElement(nodes[nodes.length - 1]);
        parent.appendChild(child);
        if (attName == null) {
            Text data = this.document.createTextNode(String.valueOf(value));
            child.appendChild(data);
        } else {
            child.setAttribute(attName, String.valueOf(value));
        }
    }

    public void clearProperty(String name) {
        super.clearProperty(name);
        this.clearXmlProperty(name);
        this.possiblySave();
    }

    private void clearXmlProperty(String name) {
        String[] nodes = XMLConfiguration.parseElementNames(name);
        String attName = XMLConfiguration.parseAttributeName(name);
        List children = this.findElementsForPropertyNodes(nodes);
        if (attName == null) {
            Iterator cIter = children.iterator();
            while (cIter.hasNext()) {
                Node subchild;
                Element child = (Element)cIter.next();
                boolean hasSubelements = false;
                for (subchild = child.getFirstChild(); subchild != null; subchild = subchild.getNextSibling()) {
                    if (subchild.getNodeType() != 1) continue;
                    hasSubelements = true;
                    break;
                }
                if (hasSubelements) continue;
                if (!child.hasAttributes()) {
                    Node parent = child.getParentNode();
                    parent.removeChild(child);
                    continue;
                }
                subchild = child.getLastChild();
                while (subchild != null) {
                    child.removeChild(subchild);
                    subchild = child.getLastChild();
                }
            }
        } else {
            Iterator cIter = children.iterator();
            while (cIter.hasNext()) {
                Element child = (Element)cIter.next();
                child.removeAttribute(attName);
            }
        }
    }

    private void possiblySave() {
        if (this.autoSave && this.fileName != null) {
            try {
                this.save();
            }
            catch (ConfigurationException ce) {
                throw new ConfigurationRuntimeException("Failed to auto-save", (Throwable)((Object)ce));
            }
        }
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public void save(Writer writer) throws ConfigurationException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(writer);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    protected static String[] parseElementNames(String key) {
        if (key == null) {
            return new String[0];
        }
        int attStart = key.indexOf(ATTRIBUTE_START);
        if (attStart > -1) {
            key = key.substring(0, attStart);
        }
        return StringUtils.split((String)key, (String)NODE_DELIMITER);
    }

    protected static String parseAttributeName(String key) {
        int attStart;
        String name = null;
        if (key != null && (attStart = key.indexOf(ATTRIBUTE_START)) > -1) {
            int attEnd = key.indexOf(ATTRIBUTE_END);
            attEnd = attEnd > -1 ? attEnd : key.length();
            name = key.substring(attStart + ATTRIBUTE_START.length(), attEnd);
        }
        return name;
    }
}

