/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratum.component;

import java.io.IOException;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Category;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Initializable;

public class ComponentLoader {
    private static Category log = Category.getInstance((Class)(class$org$apache$stratum$component$ComponentLoader == null ? (class$org$apache$stratum$component$ComponentLoader = ComponentLoader.class$("org.apache.stratum.component.ComponentLoader")) : class$org$apache$stratum$component$ComponentLoader));
    private static String COMPONENT = "component";
    private static String CLASSNAME = "classname";
    private static String CONFIG = "config";
    private static String PROPERTY = "property";
    private static String NAME = "name";
    private Configuration configuration;
    static /* synthetic */ Class class$org$apache$stratum$component$ComponentLoader;

    public ComponentLoader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Object[] load() {
        List components = this.configuration.getList(COMPONENT + '.' + NAME);
        Object[] loadedComponents = new Object[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            String componentName = (String)components.get(i);
            String componentClassName = this.getComponentClassname(componentName);
            String componentConfig = this.getComponentConfigFile(componentName);
            Configuration componentAdditionalConfig = this.getComponentAdditionalConfig(componentName);
            log.info((Object)("loading component: name=" + componentName + " class=" + componentClassName + " config=" + componentConfig));
            loadedComponents[i] = this.loadComponent(componentClassName, componentConfig, componentAdditionalConfig);
        }
        return loadedComponents;
    }

    public Object loadComponent(String className, String configFile, Configuration additionalConfig) {
        Object component = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("attempting to load '" + className + "' with the config file '" + configFile + "'."));
        }
        try {
            component = Class.forName(className).newInstance();
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new PropertiesConfiguration(configFile));
            config.addConfiguration(additionalConfig);
            ((Configurable)component).configure((Configuration)config);
            ((Initializable)component).initialize();
            if (log.isDebugEnabled()) {
                log.debug((Object)("good news! " + className + " successfully configured and initialized"));
            }
        }
        catch (IOException ioe) {
            log.error((Object)(className + " could not be configured with file '" + configFile + "'."), (Throwable)ioe);
        }
        catch (Exception e) {
            log.error((Object)(className + " could not be initialized!"), (Throwable)e);
        }
        return component;
    }

    private String getComponentClassname(String name) {
        return this.configuration.getString(COMPONENT + '.' + name + '.' + CLASSNAME);
    }

    private String getComponentConfigFile(String name) {
        return this.configuration.getString(COMPONENT + '.' + name + '.' + CONFIG);
    }

    private Configuration getComponentAdditionalConfig(String name) {
        return this.configuration.subset(COMPONENT + '.' + name + '.' + PROPERTY);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

