/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.tutorial2;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;
import ojb.odmg.OJB;
import org.odmg.Database;
import org.odmg.ODMGException;
import test.ojb.tutorial2.UCDeleteProduct;
import test.ojb.tutorial2.UCEnterNewProduct;
import test.ojb.tutorial2.UCListAllProducts;
import test.ojb.tutorial2.UCQuitApplication;
import test.ojb.tutorial2.UseCase;

public class Application {
    private Vector useCases;
    private String databaseName = "repository.xml";

    public Application() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            ex.printStackTrace();
        }
        this.useCases = new Vector();
        this.useCases.add(new UCListAllProducts(odmg));
        this.useCases.add(new UCEnterNewProduct(odmg));
        this.useCases.add(new UCDeleteProduct(odmg));
        this.useCases.add(new UCQuitApplication(odmg));
    }

    public void displayUseCases() {
        System.out.println();
        int i = 0;
        while (i < this.useCases.size()) {
            System.out.println("[" + i + "] " + ((UseCase)this.useCases.get(i)).getDescription());
            ++i;
        }
    }

    public static void main(String[] args) {
        Application app = new Application();
        app.run();
    }

    private String readLine() {
        try {
            BufferedReader rin = new BufferedReader(new InputStreamReader(System.in));
            return rin.readLine();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void run() {
        System.out.println("Welcome to the OJB ODMG tutorial application");
        System.out.println();
        while (true) {
            try {
                UseCase uc = this.selectUseCase();
                uc.apply();
                continue;
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
                continue;
            }
            break;
        }
    }

    public UseCase selectUseCase() {
        this.displayUseCases();
        System.out.println("type in number to select a use case");
        String in = this.readLine();
        int index = Integer.parseInt(in);
        return (UseCase)this.useCases.get(index);
    }
}

